/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import java.util.List;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_3532;
import net.minecraft.class_5632;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.mana.ManaBarTooltip;
import vazkii.botania.api.mana.ManaItem;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.item.CustomCreativeTabContents;
import vazkii.botania.xplat.XplatAbstractions;

public class ManaTabletItem
extends class_1792
implements CustomCreativeTabContents {
    public static final int MAX_MANA = 500000;
    private static final String TAG_MANA = "mana";
    private static final String TAG_CREATIVE = "creative";
    private static final String TAG_ONE_USE = "oneUse";

    public ManaTabletItem(class_1792.class_1793 props) {
        super(props);
    }

    @Override
    public void addToCreativeTab(class_1792 me, class_1761.class_7704 output) {
        output.method_45421((class_1935)this);
        class_1799 fullPower = new class_1799((class_1935)this);
        ManaTabletItem.setMana(fullPower, 500000);
        output.method_45420(fullPower);
        class_1799 creative = new class_1799((class_1935)this);
        ManaTabletItem.setMana(creative, 500000);
        ManaTabletItem.setStackCreative(creative);
        output.method_45420(creative);
    }

    @NotNull
    public class_1814 method_7862(@NotNull class_1799 stack) {
        return ManaTabletItem.isStackCreative(stack) ? class_1814.field_8904 : super.method_7862(stack);
    }

    public void method_7851(class_1799 stack, class_1937 world, List<class_2561> stacks, class_1836 flags) {
        if (ManaTabletItem.isStackCreative(stack)) {
            stacks.add((class_2561)class_2561.method_43471((String)"botaniamisc.creative").method_27692(class_124.field_1080));
        }
    }

    public Optional<class_5632> method_32346(class_1799 stack) {
        return Optional.of(ManaBarTooltip.fromManaItem(stack));
    }

    protected static void setMana(class_1799 stack, int mana) {
        if (mana > 0) {
            ItemNBTHelper.setInt(stack, TAG_MANA, mana);
        } else {
            ItemNBTHelper.removeEntry(stack, TAG_MANA);
        }
    }

    public static void setStackCreative(class_1799 stack) {
        ItemNBTHelper.setBoolean(stack, TAG_CREATIVE, true);
    }

    public static boolean isStackCreative(class_1799 stack) {
        return ItemNBTHelper.getBoolean(stack, TAG_CREATIVE, false);
    }

    public boolean method_31567(class_1799 stack) {
        return !ManaTabletItem.isStackCreative(stack);
    }

    public int method_31569(class_1799 stack) {
        ManaItem manaItem = XplatAbstractions.INSTANCE.findManaItem(stack);
        return Math.round(13.0f * ManaBarTooltip.getFractionForDisplay(manaItem));
    }

    public int method_31571(class_1799 stack) {
        ManaItem manaItem = XplatAbstractions.INSTANCE.findManaItem(stack);
        return class_3532.method_15369((float)(ManaBarTooltip.getFractionForDisplay(manaItem) / 3.0f), (float)1.0f, (float)1.0f);
    }

    public static class ManaItemImpl
    implements ManaItem {
        private final class_1799 stack;

        public ManaItemImpl(class_1799 stack) {
            this.stack = stack;
        }

        @Override
        public int getMana() {
            if (ManaTabletItem.isStackCreative(this.stack)) {
                return this.getMaxMana();
            }
            return ItemNBTHelper.getInt(this.stack, ManaTabletItem.TAG_MANA, 0) * this.stack.method_7947();
        }

        @Override
        public int getMaxMana() {
            return (ManaTabletItem.isStackCreative(this.stack) ? 501000 : 500000) * this.stack.method_7947();
        }

        @Override
        public void addMana(int mana) {
            if (!ManaTabletItem.isStackCreative(this.stack)) {
                ManaTabletItem.setMana(this.stack, Math.min(this.getMana() + mana, this.getMaxMana()) / this.stack.method_7947());
            }
        }

        @Override
        public boolean canReceiveManaFromPool(class_2586 pool) {
            return !ItemNBTHelper.getBoolean(this.stack, ManaTabletItem.TAG_ONE_USE, false);
        }

        @Override
        public boolean canReceiveManaFromItem(class_1799 otherStack) {
            return !ManaTabletItem.isStackCreative(this.stack);
        }

        @Override
        public boolean canExportManaToPool(class_2586 pool) {
            return true;
        }

        @Override
        public boolean canExportManaToItem(class_1799 otherStack) {
            return true;
        }

        @Override
        public boolean isNoExport() {
            return false;
        }
    }
}

