/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.compat.jei.category;

import com.simibubi.create.Create;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.compat.jei.category.animations.AnimatedItemDrain;
import com.simibubi.create.content.fluids.potion.PotionFluidHandler;
import com.simibubi.create.content.fluids.transfer.EmptyingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.utility.RegisteredObjects;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import io.github.fabricators_of_create.porting_lib.util.FluidStack;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.fabric.constants.FabricTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.runtime.IIngredientManager;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1812;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_332;

@ParametersAreNonnullByDefault
public class ItemDrainCategory
extends CreateRecipeCategory<EmptyingRecipe> {
    private final AnimatedItemDrain drain = new AnimatedItemDrain();

    public ItemDrainCategory(CreateRecipeCategory.Info<EmptyingRecipe> info) {
        super(info);
    }

    public static void consumeRecipes(Consumer<EmptyingRecipe> consumer, IIngredientManager ingredientManager) {
        for (class_1799 stack : ingredientManager.getAllIngredients((IIngredientType)VanillaTypes.ITEM_STACK)) {
            if (stack.method_7909() instanceof class_1812) {
                FluidStack fluidFromPotionItem = PotionFluidHandler.getFluidFromPotionItem(stack);
                class_1856 potion = class_1856.method_8101((class_1799[])new class_1799[]{stack});
                consumer.accept(new ProcessingRecipeBuilder<EmptyingRecipe>(EmptyingRecipe::new, Create.asResource("potions")).withItemIngredients(potion).withFluidOutputs(fluidFromPotionItem).withSingleItemOutput(new class_1799((class_1935)class_1802.field_8469)).build());
                continue;
            }
            ContainerItemContext testCtx = ContainerItemContext.withInitial((class_1799)stack);
            Storage testStorage = (Storage)testCtx.find(FluidStorage.ITEM);
            if (testStorage == null) continue;
            class_1799 copy = stack.method_7972();
            ContainerItemContext ctx = ContainerItemContext.withInitial((class_1799)copy);
            Storage storage = (Storage)ctx.find(FluidStorage.ITEM);
            FluidStack extracted = TransferUtil.extractAnyFluid((Storage)storage, (long)81000L);
            ItemVariant result = ctx.getItemVariant();
            if (extracted.isEmpty() || result.isBlank()) continue;
            class_1856 ingredient = class_1856.method_8101((class_1799[])new class_1799[]{stack});
            class_2960 itemName = RegisteredObjects.getKeyOrThrow(stack.method_7909());
            class_2960 fluidName = RegisteredObjects.getKeyOrThrow(extracted.getFluid());
            consumer.accept(new ProcessingRecipeBuilder<EmptyingRecipe>(EmptyingRecipe::new, Create.asResource("empty_" + itemName.method_12836() + "_" + itemName.method_12832() + "_of_" + fluidName.method_12836() + "_" + fluidName.method_12832())).withItemIngredients(ingredient).withFluidOutputs(extracted).withSingleItemOutput(result.toStack(ItemHelper.truncateLong(ctx.getAmount()))).build());
        }
    }

    public void setRecipe(IRecipeLayoutBuilder builder, EmptyingRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 27, 8).setBackground(ItemDrainCategory.getRenderedSlot(), -1, -1).addIngredients((class_1856)recipe.method_8117().get(0));
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 132, 8).setBackground(ItemDrainCategory.getRenderedSlot(), -1, -1).addIngredient((IIngredientType)FabricTypes.FLUID_STACK, (Object)ItemDrainCategory.toJei(ItemDrainCategory.withImprovedVisibility(recipe.getResultingFluid())))).addTooltipCallback(ItemDrainCategory.addFluidTooltip(recipe.getResultingFluid().getAmount()));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 132, 27).setBackground(ItemDrainCategory.getRenderedSlot(), -1, -1).addItemStack(ItemDrainCategory.getResultItem(recipe));
    }

    public void draw(EmptyingRecipe recipe, IRecipeSlotsView iRecipeSlotsView, class_332 graphics, double mouseX, double mouseY) {
        AllGuiTextures.JEI_SHADOW.render(graphics, 62, 37);
        AllGuiTextures.JEI_DOWN_ARROW.render(graphics, 73, 4);
        this.drain.withFluid(recipe.getResultingFluid()).draw(graphics, this.getBackground().getWidth() / 2 - 13, 40);
    }
}

