/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.depot;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.util.transform.Rotate;
import com.jozufozu.flywheel.util.transform.TransformStack;
import com.jozufozu.flywheel.util.transform.Translate;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.ShaftRenderer;
import com.simibubi.create.content.logistics.depot.DepotBehaviour;
import com.simibubi.create.content.logistics.depot.DepotRenderer;
import com.simibubi.create.content.logistics.depot.EjectorBlock;
import com.simibubi.create.content.logistics.depot.EjectorBlockEntity;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.LongAttached;
import com.simibubi.create.foundation.utility.VecHelper;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_811;

public class EjectorRenderer
extends ShaftRenderer<EjectorBlockEntity> {
    static final class_243 pivot = VecHelper.voxelSpace(0.0, 11.25, 0.75);

    public EjectorRenderer(class_5614.class_5615 context) {
        super(context);
    }

    public boolean shouldRenderOffScreen(EjectorBlockEntity p_188185_1_) {
        return true;
    }

    @Override
    protected void renderSafe(EjectorBlockEntity be, float partialTicks, class_4587 ms, class_4597 buffer, int light, int overlay) {
        super.renderSafe(be, partialTicks, ms, buffer, light, overlay);
        class_4588 vertexBuilder = buffer.getBuffer(class_1921.method_23577());
        float lidProgress = be.getLidProgress(partialTicks);
        float angle = lidProgress * 70.0f;
        if (!Backend.canUseInstancing((class_1937)be.method_10997())) {
            SuperByteBuffer model = CachedBufferer.partial(AllPartialModels.EJECTOR_TOP, be.method_11010());
            EjectorRenderer.applyLidAngle(be, angle, model);
            model.light(light).renderInto(ms, vertexBuilder);
        }
        TransformStack msr = TransformStack.cast((class_4587)ms);
        float maxTime = (float)(be.earlyTarget != null ? (double)be.earlyTargetTime : be.launcher.getTotalFlyingTicks());
        for (LongAttached<class_1799> LongAttached2 : be.launchedItems) {
            float time = (float)((Long)LongAttached2.getFirst()).longValue() + partialTicks;
            if (time > maxTime) continue;
            ms.method_22903();
            class_243 launchedItemLocation = be.getLaunchedItemLocation(time);
            msr.translate(launchedItemLocation.method_1020(class_243.method_24954((class_2382)be.method_11016())));
            class_243 itemRotOffset = VecHelper.voxelSpace(0.0, 3.0, 0.0);
            msr.translate(itemRotOffset);
            msr.rotateY((double)AngleHelper.horizontalAngle(be.getFacing()));
            msr.rotateX((double)(time * 40.0f));
            msr.translateBack(itemRotOffset);
            class_310.method_1551().method_1480().method_23178(LongAttached2.getValue(), class_811.field_4318, light, overlay, ms, buffer, be.method_10997(), 0);
            ms.method_22909();
        }
        DepotBehaviour behaviour = be.getBehaviour(DepotBehaviour.TYPE);
        if (behaviour == null || behaviour.isEmpty()) {
            return;
        }
        ms.method_22903();
        EjectorRenderer.applyLidAngle(be, angle, msr);
        ((TransformStack)((TransformStack)msr.centre()).rotateY((double)(-180.0f - AngleHelper.horizontalAngle((class_2350)be.method_11010().method_11654(EjectorBlock.HORIZONTAL_FACING))))).unCentre();
        DepotRenderer.renderItemsOf(be, partialTicks, ms, buffer, light, overlay, behaviour);
        ms.method_22909();
    }

    static <T extends Translate<T> & Rotate<T>> void applyLidAngle(KineticBlockEntity be, float angle, T tr) {
        EjectorRenderer.applyLidAngle(be, pivot, angle, tr);
    }

    static <T extends Translate<T> & Rotate<T>> void applyLidAngle(KineticBlockEntity be, class_243 rotationOffset, float angle, T tr) {
        ((Translate)((Rotate)((Translate)((Translate)((Translate)((Rotate)((Translate)tr.centre())).rotateY((double)(180.0f + AngleHelper.horizontalAngle((class_2350)be.method_11010().method_11654(EjectorBlock.HORIZONTAL_FACING))))).unCentre()).translate(rotationOffset))).rotateX((double)(-angle))).translateBack(rotationOffset);
    }
}

