/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.filter;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllPackets;
import com.simibubi.create.content.logistics.filter.AbstractFilterMenu;
import com.simibubi.create.content.logistics.filter.FilterScreenPacket;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.element.GuiGameElement;
import com.simibubi.create.foundation.gui.menu.AbstractSimiContainerScreen;
import com.simibubi.create.foundation.gui.widget.IconButton;
import com.simibubi.create.foundation.gui.widget.Indicator;
import com.simibubi.create.foundation.item.TooltipHelper;
import io.github.fabricators_of_create.porting_lib.util.PlayerEntityHelper;
import java.util.Collections;
import java.util.List;
import me.pepperbell.simplenetworking.C2SPacket;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_768;

public abstract class AbstractFilterScreen<F extends AbstractFilterMenu>
extends AbstractSimiContainerScreen<F> {
    protected AllGuiTextures background;
    private List<class_768> extraAreas = Collections.emptyList();
    private IconButton resetButton;
    private IconButton confirmButton;

    protected AbstractFilterScreen(F menu, class_1661 inv, class_2561 title, AllGuiTextures background) {
        super(menu, inv, title);
        this.background = background;
    }

    @Override
    protected void method_25426() {
        this.setWindowSize(Math.max(this.background.width, AllGuiTextures.PLAYER_INVENTORY.width), this.background.height + 4 + AllGuiTextures.PLAYER_INVENTORY.height);
        super.method_25426();
        int x = this.field_2776;
        int y = this.field_2800;
        this.resetButton = new IconButton(x + this.background.width - 62, y + this.background.height - 24, AllIcons.I_TRASH);
        this.resetButton.withCallback(() -> {
            ((AbstractFilterMenu)this.field_2797).clearContents();
            this.contentsCleared();
            ((AbstractFilterMenu)this.field_2797).sendClearPacket();
        });
        this.confirmButton = new IconButton(x + this.background.width - 33, y + this.background.height - 24, AllIcons.I_CONFIRM);
        this.confirmButton.withCallback(() -> this.field_22787.field_1724.method_7346());
        this.method_37063(this.resetButton);
        this.method_37063(this.confirmButton);
        this.extraAreas = ImmutableList.of((Object)new class_768(x + this.background.width, y + this.background.height - 40, 80, 48));
    }

    protected void method_2389(class_332 graphics, float partialTicks, int mouseX, int mouseY) {
        int invX = this.getLeftOfCentered(AllGuiTextures.PLAYER_INVENTORY.width);
        int invY = this.field_2800 + this.background.height + 4;
        this.renderPlayerInventory(graphics, invX, invY);
        int x = this.field_2776;
        int y = this.field_2800;
        this.background.render(graphics, x, y);
        graphics.method_51439(this.field_22793, this.field_22785, x + (this.background.width - 8) / 2 - this.field_22793.method_27525((class_5348)this.field_22785) / 2, y + 4, AllItems.FILTER.isIn((class_1799)((AbstractFilterMenu)this.field_2797).contentHolder) ? 0x303030 : 5841956, false);
        ((GuiGameElement.GuiRenderBuilder)GuiGameElement.of((class_1799)((AbstractFilterMenu)this.field_2797).contentHolder).at(x + this.background.width + 8, y + this.background.height - 52, -200.0f)).scale(4.0).render(graphics);
    }

    @Override
    protected void method_37432() {
        if (!class_1799.method_7973((class_1799)((AbstractFilterMenu)this.field_2797).player.method_6047(), (class_1799)((class_1799)((AbstractFilterMenu)this.field_2797).contentHolder))) {
            PlayerEntityHelper.closeScreen((class_1657)((AbstractFilterMenu)this.field_2797).player);
        }
        super.method_37432();
        this.handleTooltips();
        this.handleIndicators();
    }

    protected void handleTooltips() {
        List<IconButton> tooltipButtons = this.getTooltipButtons();
        for (IconButton button : tooltipButtons) {
            if (button.getToolTip().isEmpty()) continue;
            button.setToolTip(button.getToolTip().get(0));
            button.getToolTip().add((class_2561)TooltipHelper.holdShift(TooltipHelper.Palette.YELLOW, AbstractFilterScreen.method_25442()));
        }
        if (AbstractFilterScreen.method_25442()) {
            List<class_5250> tooltipDescriptions = this.getTooltipDescriptions();
            for (int i = 0; i < tooltipButtons.size(); ++i) {
                this.fillToolTip(tooltipButtons.get(i), (class_2561)tooltipDescriptions.get(i));
            }
        }
    }

    public void handleIndicators() {
        for (IconButton button : this.getTooltipButtons()) {
            button.field_22763 = this.isButtonEnabled(button);
        }
        for (Indicator indicator : this.getIndicators()) {
            indicator.state = this.isIndicatorOn(indicator) ? Indicator.State.ON : Indicator.State.OFF;
        }
    }

    protected abstract boolean isButtonEnabled(IconButton var1);

    protected abstract boolean isIndicatorOn(Indicator var1);

    protected List<IconButton> getTooltipButtons() {
        return Collections.emptyList();
    }

    protected List<class_5250> getTooltipDescriptions() {
        return Collections.emptyList();
    }

    protected List<Indicator> getIndicators() {
        return Collections.emptyList();
    }

    private void fillToolTip(IconButton button, class_2561 tooltip) {
        if (!button.method_25367()) {
            return;
        }
        List<class_2561> tip = button.getToolTip();
        tip.addAll(TooltipHelper.cutTextComponent(tooltip, TooltipHelper.Palette.ALL_GRAY));
    }

    protected void contentsCleared() {
    }

    protected void sendOptionUpdate(FilterScreenPacket.Option option) {
        AllPackets.getChannel().sendToServer((C2SPacket)new FilterScreenPacket(option));
    }

    @Override
    public List<class_768> getExtraAreas() {
        return this.extraAreas;
    }
}

