/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.schematics;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.simibubi.create.content.contraptions.StructureTransform;
import com.simibubi.create.content.schematics.SchematicItem;
import com.simibubi.create.content.schematics.SchematicWorld;
import com.simibubi.create.foundation.utility.WorldAttached;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2586;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_5425;
import net.minecraft.class_7871;
import net.minecraft.class_7924;

public class SchematicInstances {
    public static final WorldAttached<Cache<Integer, SchematicWorld>> loadedSchematics = new WorldAttached<Cache>($ -> CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build());

    public static void register() {
    }

    @Nullable
    public static SchematicWorld get(class_1937 world, class_1799 schematic) {
        int hash;
        Cache<Integer, SchematicWorld> map = loadedSchematics.get((class_1936)world);
        SchematicWorld ifPresent = (SchematicWorld)((Object)map.getIfPresent((Object)(hash = SchematicInstances.getHash(schematic))));
        if (ifPresent != null) {
            return ifPresent;
        }
        SchematicWorld loadWorld = SchematicInstances.loadWorld(world, schematic);
        if (loadWorld == null) {
            return null;
        }
        map.put((Object)hash, (Object)loadWorld);
        return loadWorld;
    }

    private static SchematicWorld loadWorld(class_1937 wrapped, class_1799 schematic) {
        if (schematic == null || !schematic.method_7985()) {
            return null;
        }
        if (!schematic.method_7969().method_10577("Deployed")) {
            return null;
        }
        class_3499 activeTemplate = SchematicItem.loadSchematic((class_7871<class_2248>)wrapped.method_45448(class_7924.field_41254), schematic);
        if (activeTemplate.method_15160().equals((Object)class_2382.field_11176)) {
            return null;
        }
        class_2338 anchor = class_2512.method_10691((class_2487)schematic.method_7969().method_10562("Anchor"));
        SchematicWorld world = new SchematicWorld(anchor, wrapped);
        class_3492 settings = SchematicItem.getSettings(schematic);
        activeTemplate.method_15172((class_5425)world, anchor, anchor, settings, wrapped.method_8409(), 2);
        StructureTransform transform = new StructureTransform(settings.method_15134(), class_2350.class_2351.field_11052, settings.method_15113(), settings.method_15114());
        for (class_2586 be : world.getBlockEntities()) {
            transform.apply(be);
        }
        return world;
    }

    public static void clearHash(class_1799 schematic) {
        if (schematic == null || !schematic.method_7985()) {
            return;
        }
        schematic.method_7969().method_10551("SchematicHash");
    }

    public static int getHash(class_1799 schematic) {
        if (schematic == null || !schematic.method_7985()) {
            return -1;
        }
        class_2487 tag = schematic.method_7969();
        if (!tag.method_10545("SchematicHash")) {
            tag.method_10569("SchematicHash", tag.toString().hashCode());
        }
        return tag.method_10550("SchematicHash");
    }
}

