/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.newage.content.heat;

import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.LangBuilder;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_2246;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import org.antarcticgardens.newage.config.NewAgeConfig;
import org.antarcticgardens.newage.tools.StringFormattingTool;

public interface HeatBlockEntity {
    public float getHeat();

    public void addHeat(float var1);

    public void setHeat(float var1);

    default public boolean canConnect(class_2350 from) {
        return true;
    }

    default public boolean canAdd(class_2350 from) {
        return this.canConnect(from);
    }

    default public float maxHeat() {
        return 10000.0f;
    }

    default public float getTierHeat() {
        return this.getHeat();
    }

    @Nullable
    default public float[] getHeatTiers() {
        return new float[0];
    }

    default public double getHeatTierMultiplier() {
        return 1.0;
    }

    public static <T extends class_2586> void addToolTips(T self, List<class_2561> tooltip) {
        LangBuilder builder = Lang.translate((String)"tooltip.create_new_age.temperature", (Object[])new Object[]{StringFormattingTool.formatFloat(((HeatBlockEntity)self).getHeat())});
        float max = ((HeatBlockEntity)self).maxHeat() * (float)((Double)NewAgeConfig.getCommon().overheatingMultiplier.get()).doubleValue();
        if (max < 0.0f) {
            builder.style(class_124.field_1075);
        } else if (((HeatBlockEntity)self).getHeat() >= max) {
            builder.style(class_124.field_1079);
        } else if ((double)((HeatBlockEntity)self).getHeat() >= (double)max * 0.9) {
            builder.style(class_124.field_1061);
        } else if ((double)((HeatBlockEntity)self).getHeat() >= (double)max * 0.75) {
            builder.style(class_124.field_1065);
        } else if ((double)((HeatBlockEntity)self).getHeat() >= (double)max * 0.65) {
            builder.style(class_124.field_1054);
        } else {
            builder.style(class_124.field_1075);
        }
        builder.add(Lang.text((String)" / ").add(Lang.translate((String)"tooltip.create_new_age.temperature", (Object[])new Object[]{max > 0.0f ? StringFormattingTool.formatFloat(max) : "\u221e"})).style(class_124.field_1063));
        builder.forGoggles(tooltip, 1);
        float[] tiers = ((HeatBlockEntity)self).getHeatTiers();
        if (tiers == null) {
            return;
        }
        float mult = (float)((HeatBlockEntity)self).getHeatTierMultiplier();
        float tierHeat = ((HeatBlockEntity)self).getTierHeat();
        for (int i = 0; i < tiers.length; ++i) {
            float tis = tiers[i] * mult;
            float next = Float.MAX_VALUE;
            if (tiers.length > i + 1) {
                next = tiers[i + 1] * mult;
            }
            if (tis <= tierHeat && next > tierHeat) {
                builder = Lang.text((String)"> ").add(Lang.translate((String)"tooltip.create_new_age.temperature", (Object[])new Object[]{StringFormattingTool.formatFloat(tis)}));
                builder.style(class_124.field_1080);
                builder.forGoggles(tooltip, 0);
                continue;
            }
            builder = Lang.text((String)"").add(Lang.translate((String)"tooltip.create_new_age.temperature", (Object[])new Object[]{StringFormattingTool.formatFloat(tis)}));
            builder.style(class_124.field_1063);
            builder.forGoggles(tooltip, 2);
        }
    }

    public static <T extends class_2586> void handleOverheat(T self, Runnable onOverHeat) {
        if (self.method_10997() == null) {
            return;
        }
        double multiplier = (Double)NewAgeConfig.getCommon().overheatingMultiplier.get();
        if (multiplier > 0.0 && (double)((HeatBlockEntity)self).getHeat() > (double)((HeatBlockEntity)self).maxHeat() * (Double)NewAgeConfig.getCommon().overheatingMultiplier.get()) {
            onOverHeat.run();
        }
    }

    public static <T extends class_2586> void handleOverheat(T self) {
        HeatBlockEntity.handleOverheat(self, () -> self.method_10997().method_8652(self.method_11016(), class_2246.field_10164.method_9564(), 3));
    }

    public static <T extends class_2586> void transferAround(T self) {
        if (self.method_10997() == null) {
            return;
        }
        float totalToAverage = ((HeatBlockEntity)self).getHeat();
        int totalBlocks = 1;
        HeatBlockEntity[] setters = new HeatBlockEntity[6];
        for (int i = 0; i < 6; ++i) {
            HeatBlockEntity hbe;
            class_2350 value = class_2350.values()[i];
            class_2586 entity = self.method_10997().method_8321(self.method_11016().method_10093(value));
            if (!(entity instanceof HeatBlockEntity) || !(hbe = (HeatBlockEntity)entity).canAdd(value)) continue;
            setters[i] = hbe;
            totalToAverage += hbe.getHeat();
            ++totalBlocks;
        }
        HeatBlockEntity.average(self, totalToAverage, totalBlocks, setters);
        self.method_5431();
    }

    public static <T extends class_2586> void average(T self, float totalToAverage, int totalBlocks, HeatBlockEntity[] setters) {
        float setAmount = totalToAverage / (float)totalBlocks;
        ((HeatBlockEntity)self).setHeat(setAmount);
        int i = 0;
        for (HeatBlockEntity hbe : setters) {
            if (hbe != null) {
                hbe.setHeat(setAmount);
            }
            ++i;
        }
    }
}

