/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.smwyg.mixin;

import io.github.apace100.smwyg.ShowMeWhatYouGot;
import io.github.apace100.smwyg.SmwygItemMatch;
import io.github.apace100.smwyg.duck.ItemSharingTextFieldWidget;
import net.minecraft.class_1074;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_342;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={class_342.class})
public abstract class TextFieldWidgetMixin
implements ItemSharingTextFieldWidget {
    @Shadow
    private String field_2092;
    @Shadow
    private int field_2102;
    private class_1799 itemStack;
    private String insertedString;
    private int insertedLength;
    private int insertedIndex = 0;

    @Override
    public void setStack(class_1799 stack) {
        this.itemStack = stack;
        class_2561 text = stack.method_7954();
        this.insertedString = text.getString();
        this.insertedLength = this.insertedString.length();
    }

    @Override
    public class_1799 getStack() {
        return this.itemStack;
    }

    @Override
    public String getTextBefore() {
        return this.field_2092.substring(0, this.insertedIndex);
    }

    @Override
    public String getTextAfter() {
        return this.field_2092.substring(this.insertedIndex + this.insertedLength);
    }

    @Override
    public boolean hasStack() {
        return this.itemStack != null;
    }

    @Override
    public void onSuggestionInserted(int start, int offset) {
        if (this.itemStack != null && start <= this.insertedIndex) {
            this.insertedIndex += offset;
        }
    }

    @Inject(method={"getCursorPosWithOffset"}, at={@At(value="RETURN")}, cancellable=true)
    private void modifyCursorOffset(int offset, CallbackInfoReturnable<Integer> cir) {
        int original = (Integer)cir.getReturnValue();
        if (original > this.insertedIndex && original < this.insertedIndex + this.insertedLength) {
            if (offset < 0) {
                cir.setReturnValue((Object)this.insertedIndex);
            } else {
                cir.setReturnValue((Object)(this.insertedIndex + this.insertedLength));
            }
        }
    }

    @Inject(method={"write"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/widget/TextFieldWidget;setSelectionStart(I)V")}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void moveInsertedText(String text, CallbackInfo ci, int i, int j, int k, String string, int l, String string2) {
        if (i <= this.insertedIndex && j <= this.insertedIndex) {
            this.insertedIndex += l;
        }
    }

    @ModifyVariable(method={"setCursor"}, at=@At(value="HEAD"), argsOnly=true, ordinal=0)
    private int modifyCursorSetting(int original) {
        if (original > this.insertedIndex && original < this.insertedIndex + this.insertedLength) {
            if (original <= this.insertedIndex + this.insertedLength / 2) {
                return this.insertedIndex;
            }
            return this.insertedIndex + this.insertedLength;
        }
        return original;
    }

    @ModifyVariable(method={"setSelectionStart"}, at=@At(value="HEAD"), argsOnly=true, ordinal=0)
    private int modifySelectionStart(int original) {
        if (original > this.insertedIndex && original < this.insertedIndex + this.insertedLength) {
            return this.insertedIndex;
        }
        return original;
    }

    @Inject(method={"eraseCharacters"}, at={@At(value="INVOKE", target="Ljava/lang/StringBuilder;<init>(Ljava/lang/String;)V")}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void eraseInsertion(int characterOffset, CallbackInfo ci, int i, int j, int k) {
        if (j <= this.insertedIndex && k >= this.insertedIndex + this.insertedLength) {
            this.reset();
        } else if (j <= this.insertedIndex || k <= this.insertedIndex) {
            this.insertedIndex -= k - j;
        }
    }

    @ModifyVariable(method={"setSelectionEnd"}, at=@At(value="HEAD"), argsOnly=true, ordinal=0)
    private int modifySelectionEnd(int original) {
        if (original > this.insertedIndex && original < this.insertedIndex + this.insertedLength) {
            return this.insertedIndex;
        }
        return original;
    }

    @ModifyVariable(method={"setText"}, at=@At(value="HEAD"), argsOnly=true, ordinal=0)
    private String handleItemSetting(String text) {
        if (this.hasStack()) {
            return text;
        }
        if (ShowMeWhatYouGot.hasSmwygItem((String)text)) {
            SmwygItemMatch itemMatch = ShowMeWhatYouGot.extractItem((String)text);
            String before = ((String)text).substring(0, itemMatch.start);
            String after = ((String)text).substring(itemMatch.end);
            if (itemMatch.stack == null) {
                text = before + class_1074.method_4662((String)"smwyg.chat.stale_link", (Object[])new Object[0]) + after;
                this.reset();
            } else {
                String itemText = itemMatch.stack.method_7954().getString();
                text = before + itemText + after;
                this.itemStack = itemMatch.stack;
                this.insertedString = itemText;
                this.insertedIndex = itemMatch.start;
                this.insertedLength = itemText.length();
            }
        } else {
            this.reset();
        }
        return text;
    }

    @Override
    public void reset() {
        this.itemStack = null;
        this.insertedString = "";
        this.insertedIndex = 0;
        this.insertedLength = 0;
    }

    @Override
    public int getInsertionStart() {
        return this.insertedIndex;
    }

    @Override
    public int getInsertionEnd() {
        return this.insertedIndex + this.insertedLength;
    }
}

