/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.graves;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import eu.pb4.graves.config.Config;
import eu.pb4.graves.config.ConfigManager;
import eu.pb4.graves.event.GraveValidPosCheckEvent;
import eu.pb4.graves.event.PlayerGraveCreationEvent;
import eu.pb4.graves.event.PlayerGraveItemAddedEvent;
import eu.pb4.graves.grave.Grave;
import eu.pb4.graves.grave.GraveInventoryMask;
import eu.pb4.graves.grave.GraveManager;
import eu.pb4.graves.other.GraveUtils;
import eu.pb4.graves.other.Location;
import eu.pb4.graves.other.VanillaInventoryMask;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.fabricmc.fabric.api.event.Event;
import net.minecraft.class_1269;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public final class GravesApi {
    private static final BiMap<class_2960, GraveInventoryMask> MASKS_MAP = HashBiMap.create();
    private static final List<GraveInventoryMask> MASKS = new ArrayList<GraveInventoryMask>();
    public static Event<PlayerGraveCreationEvent> CREATION_EVENT = PlayerGraveCreationEvent.EVENT;
    public static Event<GraveValidPosCheckEvent> VALID_POS_CHECK_EVENT = GraveValidPosCheckEvent.EVENT;
    public static Event<PlayerGraveItemAddedEvent> ADD_ITEM_EVENT = PlayerGraveItemAddedEvent.EVENT;

    public static Collection<Grave> getGravesOf(UUID uuid) {
        return ImmutableList.copyOf(GraveManager.INSTANCE.getByUuid(uuid));
    }

    public static Optional<Grave> getGraveAt(class_2960 world, class_2338 pos) {
        return Optional.ofNullable(GraveManager.INSTANCE.getByLocation(new Location(world, pos)));
    }

    public static Collection<Grave> getAllGraves() {
        return ImmutableList.copyOf(GraveManager.INSTANCE.getAll());
    }

    public static boolean canAddItem(class_3222 player, class_1799 itemStack) {
        return !itemStack.method_7960() && ((PlayerGraveItemAddedEvent)PlayerGraveItemAddedEvent.EVENT.invoker()).canAddItem(player, itemStack) != class_1269.field_5814 && !GraveUtils.hasSkippedEnchantment(itemStack) && !class_1890.method_8221((class_1799)itemStack);
    }

    @Nullable
    public static Config getConfig() {
        return ConfigManager.getConfig();
    }

    public static class_2960 getInventoryMaskId(GraveInventoryMask inventoryMask) {
        return (class_2960)MASKS_MAP.inverse().get((Object)inventoryMask);
    }

    public static GraveInventoryMask getInventoryMask(class_2960 identifier) {
        return (GraveInventoryMask)MASKS_MAP.get((Object)identifier);
    }

    public static void registerInventoryMask(class_2960 identifier, GraveInventoryMask mask) {
        if (MASKS_MAP.containsKey((Object)identifier)) {
            throw new RuntimeException("You can't register same mask id twice!");
        }
        MASKS_MAP.put((Object)identifier, (Object)mask);
        MASKS.add(mask);
    }

    public static Collection<GraveInventoryMask> getAllInventoryMasks() {
        return MASKS;
    }

    public static GraveInventoryMask getDefaultedInventoryMask(class_2960 identifier) {
        GraveInventoryMask mask = GravesApi.getInventoryMask(identifier);
        return mask != null ? mask : VanillaInventoryMask.INSTANCE;
    }

    public static void removeInventoryMask(GraveInventoryMask mask) {
        MASKS.remove(mask);
        MASKS_MAP.inverse().remove((Object)mask);
    }

    public static void removeInventoryMask(class_2960 mask) {
        MASKS.remove(MASKS_MAP.remove((Object)mask));
    }
}

