/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.graves.other;

import eu.pb4.common.protection.api.CommonProtection;
import eu.pb4.graves.GravesApi;
import eu.pb4.graves.GravesMod;
import eu.pb4.graves.config.Config;
import eu.pb4.graves.config.ConfigManager;
import eu.pb4.graves.config.data.WrappedText;
import eu.pb4.graves.event.GraveValidPosCheckEvent;
import eu.pb4.graves.event.PlayerGraveCreationEvent;
import eu.pb4.graves.grave.Grave;
import eu.pb4.graves.grave.GraveInventoryMask;
import eu.pb4.graves.grave.GraveManager;
import eu.pb4.graves.grave.PositionedItemStack;
import eu.pb4.graves.other.GravesXPCalculation;
import eu.pb4.graves.other.Location;
import eu.pb4.graves.other.PlayerAdditions;
import eu.pb4.graves.registry.GraveBlock;
import eu.pb4.graves.registry.GraveBlockEntity;
import eu.pb4.graves.registry.SafeXPEntity;
import eu.pb4.graves.registry.TempBlock;
import eu.pb4.predicate.api.PredicateContext;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1277;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1303;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2784;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3612;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class GraveUtils {
    public static final class_2960 REPLACEABLE_ID = new class_2960("universal_graves", "replaceable");
    public static final class_6862<class_2248> REPLACEABLE_TAG = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)REPLACEABLE_ID);
    public static final class_1263 EMPTY_INVENTORY = new class_1277(0);
    private static final Function<Map.Entry<class_2769<?>, Comparable<?>>, String> PROPERTY_MAP_PRINTER = new Function<Map.Entry<class_2769<?>, Comparable<?>>, String>(){

        @Override
        public String apply(@Nullable Map.Entry<class_2769<?>, Comparable<?>> entry) {
            if (entry == null) {
                return "<NULL>";
            }
            class_2769<?> property = entry.getKey();
            return property.method_11899() + "=" + this.nameValue(property, entry.getValue());
        }

        private <T extends Comparable<T>> String nameValue(class_2769<T> property, Comparable<?> value) {
            return property.method_11901(value);
        }
    };

    public static BlockCheckResult findGravePosition(class_3222 player, class_3218 world, class_2338 blockPos, int maxDistance, boolean anyBlock) {
        class_2784 border = world.method_8621();
        blockPos = class_2338.method_49637((double)class_3532.method_15350((double)blockPos.method_10263(), (double)(border.method_11976() + 1.0), (double)(border.method_11963() - 1.0)), (double)class_3532.method_15340((int)blockPos.method_10264(), (int)world.method_31607(), (int)(world.method_31600() - 1)), (double)class_3532.method_15350((double)blockPos.method_10260(), (double)(border.method_11958() + 1.0), (double)(border.method_11977() - 1.0)));
        Config config = ConfigManager.getConfig();
        BlockResult result = GraveUtils.isValidPos(player, world, border, blockPos, false, config);
        if (result.allow) {
            return new BlockCheckResult(blockPos, result);
        }
        if (result == BlockResult.BLOCK_FLUID) {
            class_2338.class_2339 x = blockPos.method_25503();
            while (world.method_8320((class_2338)x).method_26227().method_15772() != class_3612.field_15906) {
                x.method_10100(0, 1, 0);
            }
            blockPos = x.method_10062();
            result = GraveUtils.isValidPos(player, world, border, blockPos, false, config);
            if (result.allow) {
                return new BlockCheckResult(blockPos, result);
            }
        }
        BlockCheckResult checkResult = GraveUtils.findPos(player, world, blockPos, maxDistance, false, 0, config);
        if (!checkResult.result.allow && anyBlock) {
            checkResult = GraveUtils.findPos(player, world, blockPos, maxDistance, true, 0, config);
        }
        return checkResult;
    }

    private static BlockCheckResult findPos(class_3222 player, class_3218 world, class_2338 blockPos, int maxDistance, boolean allowAnyBlock, int iteration, Config config) {
        class_2784 border = world.method_8621();
        BlockResult result = GraveUtils.isValidPos(player, world, border, blockPos, allowAnyBlock, config);
        if (result.allow) {
            return new BlockCheckResult(blockPos, result);
        }
        class_2338.class_2339 pos = new class_2338.class_2339(blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260());
        for (int line = 1; line <= maxDistance; ++line) {
            int side = line * 2 + 1;
            for (int oY = 0; oY < side; ++oY) {
                for (int oX = 0; oX < side; ++oX) {
                    for (int oZ = 0; oZ < side; ++oZ) {
                        pos.method_10103(blockPos.method_10263() - line + oX, blockPos.method_10264() - line + oY, blockPos.method_10260() - line + oZ);
                        if (oX > 0 && oX < side - 1 && oY > 0 && oY < side - 1 && oZ > 0 && oZ < side - 1) continue;
                        BlockResult tempResult = GraveUtils.isValidPos(player, world, border, (class_2338)pos, allowAnyBlock, config);
                        if (tempResult.priority >= result.priority) {
                            result = tempResult;
                        }
                        if (!result.canCreate()) continue;
                        return new BlockCheckResult(pos.method_10062(), result);
                    }
                }
            }
        }
        if (config.placement.shiftLocationOnFailure && iteration < config.placement.maxShiftCount) {
            return GraveUtils.findPos(player, world, blockPos.method_10079(class_2350.method_10162((class_5819)class_5819.method_43047()), config.placement.shiftDistance), maxDistance, allowAnyBlock, iteration + 1, config);
        }
        return new BlockCheckResult(null, result);
    }

    public static void spawnExp(class_3218 world, class_243 pos, int amount) {
        if (ConfigManager.getConfig().storage.useAlternativeXPEntity) {
            SafeXPEntity.spawn(world, pos, amount);
        } else {
            class_1303.method_31493((class_3218)world, (class_243)pos, (int)amount);
        }
    }

    private static BlockResult isValidPos(class_3222 player, class_3218 world, class_2784 border, class_2338 pos, boolean anyBlock, Config config) {
        class_2680 state = world.method_8320(pos);
        if (GraveUtils.canReplaceState(state, anyBlock) && border.method_11952(pos) && pos.method_10264() >= world.method_31607() && pos.method_10264() < world.method_31600()) {
            if (config.placement.generateOnTopOfFluids && state.method_26227().method_15772() != class_3612.field_15906 && world.method_8320(pos.method_10084()).method_26227().method_15772() != class_3612.field_15906) {
                return BlockResult.BLOCK_FLUID;
            }
            List<Config.Arena> areas = config.placement.blacklistedAreas.get(world.method_27983().method_29177());
            if (areas != null) {
                for (Config.Arena area : areas) {
                    if (!area.contains(pos.method_10263(), pos.method_10264(), pos.method_10260())) continue;
                    return BlockResult.BLOCK_CLAIM;
                }
            }
            for (class_2960 id : CommonProtection.getProviderIds()) {
                if (config.placement.blockInProtection.get(id) != Boolean.TRUE || Objects.requireNonNull(CommonProtection.getProvider((class_2960)id)).canPlaceBlock((class_1937)world, pos, player.method_7334(), (class_1657)player)) continue;
                return BlockResult.BLOCK_CLAIM;
            }
            return ((GraveValidPosCheckEvent)GraveValidPosCheckEvent.EVENT.invoker()).isValid(player, world, pos);
        }
        return BlockResult.BLOCK;
    }

    public static class_2561 toWorldName(class_2960 identifier) {
        String[] words;
        WrappedText override = ConfigManager.getConfig().texts.worldNameOverrides.get(identifier);
        if (override != null) {
            return override.text();
        }
        ArrayList<String> parts = new ArrayList<String>();
        for (String word : words = identifier.method_12832().split("_")) {
            CharSequence[] s = word.split("", 2);
            s[0] = s[0].toUpperCase(Locale.ROOT);
            parts.add(String.join((CharSequence)"", s));
        }
        return class_2561.method_43470((String)String.join((CharSequence)" ", parts));
    }

    public static boolean hasSkippedEnchantment(class_1799 stack) {
        Config config = ConfigManager.getConfig();
        for (class_2520 enchant : stack.method_7921()) {
            class_2487 compound;
            class_2960 key;
            if (!(enchant instanceof class_2487) || (key = class_1890.method_37427((class_2487)(compound = (class_2487)enchant))) == null || !config.storage.skippedEnchantments.contains(key)) continue;
            return true;
        }
        return false;
    }

    public static void teleportToGrave(final class_3222 player, Grave grave, final BooleanConsumer finishedCallback) {
        final Config config = ConfigManager.getConfig();
        final Location pos = grave.getLocation();
        WrappedText movingText = config.teleportation.allowMovingDuringTeleportation || player.method_7337() ? config.teleportation.text.teleportTimerTextAllowMoving : config.teleportation.text.teleportTimerText;
        MinecraftServer server = Objects.requireNonNull(player.method_5682(), "server; running on client?");
        final class_3218 world = server.method_3847(class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)pos.world()));
        if (world != null) {
            player.method_43496(movingText.with(Map.of("time", class_2561.method_30163((String)(player.method_7337() ? "0" : Integer.toString(config.teleportation.teleportTime))))));
            GravesMod.DO_ON_NEXT_TICK.add(new Runnable(){
                double x;
                double y;
                double z;
                final class_243 currentPosition;
                int teleportTicks;
                int invulnerableTicks;
                {
                    this.x = pos.x();
                    this.y = (double)pos.y() + config.teleportation.teleportHeight;
                    this.z = pos.z();
                    this.currentPosition = player.method_19538();
                    this.teleportTicks = player.method_7337() ? 1 : config.teleportation.teleportTime * 20;
                    this.invulnerableTicks = config.teleportation.invincibleTime * 20;
                }

                @Override
                public void run() {
                    if (--this.teleportTicks >= 0) {
                        if (!config.teleportation.allowMovingDuringTeleportation && !player.method_19538().equals((Object)this.currentPosition)) {
                            player.method_43496(config.teleportation.text.teleportCancelledText.text());
                            player.method_17356(class_3417.field_15135, class_3419.field_15250, 1.0f, 0.5f);
                            finishedCallback.accept(false);
                            return;
                        }
                        if (this.teleportTicks == 0) {
                            player.method_43496(config.teleportation.text.teleportLocationText.with(Map.of("position", class_2561.method_43469((String)"chat.coordinates", (Object[])new Object[]{this.x, this.y, this.z}))));
                            player.method_14251(world, this.x + 0.5, this.y + 1.0, this.z + 0.5, player.method_36454(), player.method_36455());
                            player.method_17356(class_3417.field_14879, class_3419.field_15250, 1.0f, 1.0f);
                            ((PlayerAdditions)player).graves$setInvulnerable(true);
                        }
                        GravesMod.DO_ON_NEXT_TICK.add(this);
                    } else if (--this.invulnerableTicks > 0) {
                        GravesMod.DO_ON_NEXT_TICK.add(this);
                    } else {
                        ((PlayerAdditions)player).graves$setInvulnerable(false);
                        finishedCallback.accept(true);
                    }
                }
            });
        }
    }

    public static void createGrave(class_3222 player, class_1282 source) {
        Config config = ConfigManager.getConfig();
        if (player.method_37908().method_8450().method_8355(class_1928.field_19389) || config.placement.blacklistedWorlds.contains(player.method_37908().method_27983().method_29177()) || config.placement.maxGraveCount == 0) {
            return;
        }
        WrappedText text = null;
        Map<String, class_2561> placeholders = Map.of("position", class_2561.method_43470((String)player.method_24515().method_23854()), "world", GraveUtils.toWorldName(player.method_37908().method_27983().method_29177()));
        if (source.method_5529() != null) {
            text = config.placement.ignoredAttackers.get(source.method_5529().method_5864());
        }
        if (text == null) {
            text = config.placement.ignoredDamageTypes.get(((class_5321)source.method_48793().method_40230().get()).method_29177());
        }
        if (text == null) {
            PredicateContext ctx = PredicateContext.of((class_3222)player);
            for (Config.Placement.PredicateBlocker test : config.placement.predicates) {
                if (!test.predicate.test(ctx).success()) continue;
                text = test.text;
            }
        }
        if (text == null) {
            PlayerGraveCreationEvent.CreationResult eventResult = ((PlayerGraveCreationEvent)PlayerGraveCreationEvent.EVENT.invoker()).shouldCreate(player);
            if (eventResult.canCreate()) {
                BlockCheckResult result = GraveUtils.findGravePosition(player, player.method_51469(), player.method_24515(), config.placement.maxPlacementDistance, config.placement.replaceAnyBlock);
                if (result.result().canCreate()) {
                    String model = config.getGraveModel(player);
                    class_2338 gravePos = result.pos();
                    ArrayList<PositionedItemStack> items = new ArrayList<PositionedItemStack>();
                    for (GraveInventoryMask mask : GravesApi.getAllInventoryMasks()) {
                        mask.addToGrave(player, (stack, slot, nbt, tags) -> items.add(new PositionedItemStack(stack, slot, mask, nbt, Set.of(tags))));
                    }
                    int experience = 0;
                    if (config.storage.xpStorageType != GravesXPCalculation.DROP) {
                        experience = config.storage.xpStorageType.converter.calc(player);
                    }
                    if (!(items.size() != 0 || config.storage.canStoreOnlyXp && experience != 0)) {
                        return;
                    }
                    if (config.storage.xpStorageType != GravesXPCalculation.DROP) {
                        player.field_7520 = 0;
                    }
                    int finalExperience = experience;
                    class_3218 world = player.method_51469();
                    HashSet<UUID> allowedUUID = new HashSet<UUID>();
                    if (config.protection.allowAttackersToTakeItems) {
                        class_3222 playerEntity;
                        class_1297 class_12972 = source.method_5529();
                        if (class_12972 instanceof class_3222) {
                            playerEntity = (class_3222)class_12972;
                            allowedUUID.add(playerEntity.method_5667());
                        }
                        if ((class_12972 = player.method_6065()) instanceof class_3222) {
                            playerEntity = (class_3222)class_12972;
                            allowedUUID.add(playerEntity.method_5667());
                        }
                    }
                    Grave grave = Grave.createBlock(player, world.method_27983().method_29177(), gravePos, finalExperience, source.method_5506((class_1309)player), allowedUUID, items, (int)(world.method_8503().method_30002().method_8532() / 24000L));
                    ((PlayerAdditions)player).graves$setLastGrave(grave.getId());
                    class_2680 oldBlockState = world.method_8320(gravePos);
                    world.method_8501(gravePos, TempBlock.INSTANCE.method_9564());
                    GravesMod.DO_ON_NEXT_TICK.add(() -> {
                        WrappedText text2;
                        Map<String, class_2561> placeholders2 = placeholders;
                        class_2680 storedBlockState = world.method_8320(gravePos).method_26204() == TempBlock.INSTANCE ? oldBlockState : class_2246.field_10124.method_9564();
                        world.method_8501(gravePos, (class_2680)GraveBlock.INSTANCE.method_9564().method_11657((class_2769)class_2741.field_12532, (Comparable)Integer.valueOf(player.method_6051().method_43048(15))));
                        class_2586 entity = world.method_8321(gravePos);
                        if (entity instanceof GraveBlockEntity) {
                            GraveBlockEntity graveBlockEntity = (GraveBlockEntity)entity;
                            GraveManager.INSTANCE.add(grave);
                            graveBlockEntity.setGrave(grave, storedBlockState);
                            graveBlockEntity.setModelId(model);
                            text2 = config.texts.messageGraveCreated;
                            placeholders2 = grave.getPlaceholders(player.method_5682());
                            if (config.placement.maxGraveCount > -1) {
                                ArrayList<Grave> graves = new ArrayList<Grave>(GraveManager.INSTANCE.getByPlayer(player));
                                graves.sort(Comparator.comparing(x -> x.getCreationTime()));
                                while (graves.size() > config.placement.maxGraveCount) {
                                    graves.remove(0).destroyGrave(player.field_13995, null);
                                }
                            }
                        } else {
                            if (config.storage.xpStorageType != GravesXPCalculation.DROP) {
                                GraveUtils.spawnExp(world, class_243.method_24953((class_2382)gravePos), finalExperience);
                            }
                            text2 = config.placement.messageCreationFailed;
                            class_2371 droppedItems = class_2371.method_37434((int)0);
                            for (PositionedItemStack item : items) {
                                droppedItems.add((Object)item.stack());
                            }
                            class_1264.method_17349((class_1937)world, (class_2338)gravePos, (class_2371)droppedItems);
                            ((PlayerAdditions)player).graves$setLastGrave(-1L);
                        }
                        if (text2 != null) {
                            player.method_43496(text2.with(placeholders2));
                        }
                    });
                } else {
                    text = switch (result.result()) {
                        case BlockResult.BLOCK -> config.placement.messageCreationFailed;
                        case BlockResult.BLOCK_CLAIM -> config.placement.messageCreationFailedClaim;
                        default -> null;
                    };
                }
            } else {
                switch (eventResult) {
                    case BLOCK: {
                        WrappedText wrappedText = config.placement.messageCreationFailed;
                        break;
                    }
                    case BLOCK_CLAIM: {
                        WrappedText wrappedText = config.placement.messageCreationFailedClaim;
                        break;
                    }
                    default: {
                        WrappedText wrappedText = text = null;
                    }
                }
            }
        }
        if (text != null && !text.isEmpty()) {
            player.method_43496(text.with(placeholders));
        }
    }

    public static boolean canReplaceState(class_2680 state, boolean dontValidateWithTag) {
        return state.method_26204() != TempBlock.INSTANCE && !state.method_31709() && (state.method_26215() || dontValidateWithTag || state.method_26164(REPLACEABLE_TAG));
    }

    public static void grandExperience(class_1657 player, int experience) {
        player.method_7285(experience);
        player.field_7510 += (float)experience / (float)player.method_7349();
        player.field_7495 = class_3532.method_15340((int)(player.field_7495 + experience), (int)0, (int)Integer.MAX_VALUE);
        while (player.field_7510 < 0.0f) {
            float f = player.field_7510 * (float)player.method_7349();
            if (player.field_7520 > 0) {
                player.method_7316(-1);
                player.field_7510 = 1.0f + f / (float)player.method_7349();
                continue;
            }
            player.method_7316(-1);
            player.field_7510 = 0.0f;
        }
        while (player.field_7510 >= 1.0f) {
            player.field_7510 = (player.field_7510 - 1.0f) * (float)player.method_7349();
            player.method_7316(1);
            player.field_7510 /= (float)player.method_7349();
        }
    }

    public static enum BlockResult {
        ALLOW(true, 999),
        BLOCK(false, 0),
        BLOCK_CLAIM(false, 1),
        BLOCK_FLUID(false, 2);

        private final boolean allow;
        private final int priority;

        private BlockResult(boolean allow, int priority) {
            this.allow = allow;
            this.priority = priority;
        }

        public boolean canCreate() {
            return this.allow;
        }
    }

    public record BlockCheckResult(@Nullable class_2338 pos, BlockResult result) {
    }
}

