/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.graves.registry;

import com.mojang.authlib.GameProfile;
import eu.pb4.graves.config.Config;
import eu.pb4.graves.config.ConfigManager;
import eu.pb4.graves.grave.Grave;
import eu.pb4.graves.grave.GraveHolder;
import eu.pb4.graves.grave.GraveManager;
import eu.pb4.graves.grave.PositionedItemStack;
import eu.pb4.graves.model.GraveModelHandler;
import eu.pb4.graves.other.VanillaInventoryMask;
import eu.pb4.graves.other.VisualGraveData;
import eu.pb4.graves.registry.AbstractGraveBlock;
import eu.pb4.graves.registry.AbstractGraveBlockEntity;
import eu.pb4.graves.registry.VisualGraveBlock;
import eu.pb4.graves.registry.VisualGraveBlockEntity;
import eu.pb4.polymer.virtualentity.api.attachment.BlockBoundAttachment;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_1306;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_7871;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class GraveBlockEntity
extends AbstractGraveBlockEntity
implements GraveHolder {
    public static class_2591<GraveBlockEntity> BLOCK_ENTITY_TYPE;
    public class_2680 replacedBlockState = class_2246.field_10124.method_9564();
    private Grave data = null;
    private VisualGraveData visualData = VisualGraveData.DEFAULT;
    private long graveId = -1L;
    private GraveModelHandler model;
    private Map<String, class_2561> cachedPlaceholders;

    public GraveBlockEntity(class_2338 pos, class_2680 state) {
        super(BLOCK_ENTITY_TYPE, pos, state);
    }

    public void setGrave(Grave grave, class_2680 oldBlockState) {
        this.replacedBlockState = oldBlockState;
        this.setGrave(grave);
    }

    public void setGrave(Grave grave) {
        this.data = grave;
        if (grave != null) {
            this.visualData = grave.toVisualGraveData();
            this.graveId = grave.getId();
        } else {
            this.graveId = -1L;
        }
        this.method_5431();
    }

    @Override
    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10566("BlockState", (class_2520)class_2512.method_10686((class_2680)this.replacedBlockState));
        nbt.method_10566("VisualData", (class_2520)this.getClientData().toNbt());
        nbt.method_10544("GraveId", this.graveId);
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        try {
            if (nbt.method_10573("GraveInfo", 10)) {
                this.data = new Grave();
                this.data.readNbt(nbt.method_10562("GraveInfo"));
                class_2499 nbtList = nbt.method_10554("Items", 10);
                for (class_2520 compound : nbtList) {
                    this.data.getItems().add(new PositionedItemStack(class_1799.method_7915((class_2487)((class_2487)compound)), -1, VanillaInventoryMask.INSTANCE, null, Set.of()));
                }
                GraveManager.INSTANCE.add(this.data);
                this.visualData = this.data.toVisualGraveData();
            } else if (nbt.method_10573("GraveId", 4)) {
                this.graveId = nbt.method_10537("GraveId");
            }
            if (this.data == null) {
                this.fetchGraveData();
            }
            if (this.visualData == null) {
                this.visualData = VisualGraveData.fromNbt(nbt.method_10562("VisualData"));
            }
            this.replacedBlockState = class_2512.method_10681((class_7871)class_7923.field_41175.method_46771(), (class_2487)((class_2487)Objects.requireNonNull(nbt.method_10580("BlockState"))));
        }
        catch (Exception e) {
            this.visualData = VisualGraveData.DEFAULT;
        }
    }

    protected void fetchGraveData() {
        this.data = GraveManager.INSTANCE.getId(this.graveId);
        if (this.data != null) {
            this.visualData = this.data.toVisualGraveData();
            this.updateForAllPlayers();
            this.method_5431();
        }
    }

    protected void updateForAllPlayers() {
        assert (this.field_11863 != null);
    }

    public static <T extends class_2586> void tick(class_1937 world, class_2338 pos, class_2680 state, T t) {
        GraveBlockEntity self;
        block12: {
            block11: {
                if (!(t instanceof GraveBlockEntity)) break block11;
                self = (GraveBlockEntity)t;
                if (!world.method_8608()) break block12;
            }
            return;
        }
        self.cachedPlaceholders = null;
        if (self.data == null) {
            if (world.method_8510() % 10L == 0L) {
                self.fetchGraveData();
            }
            return;
        }
        if (self.data.isRemoved()) {
            self.breakBlock();
            return;
        }
        if (self.model == null) {
            self.model = (GraveModelHandler)BlockBoundAttachment.get((class_1937)world, (class_2338)pos).holder();
            self.model.setGrave(self);
        }
        if (world.method_8510() % 5L != 0L) {
            self.model.maybeTick(world.method_8510());
            return;
        }
        Config config = ConfigManager.getConfig();
        if (config.protection.breakingTime > -1 && self.data.shouldNaturallyBreak()) {
            world.method_8652(pos, self.replacedBlockState, 3);
            return;
        }
        if (((Boolean)state.method_11654((class_2769)AbstractGraveBlock.IS_LOCKED)).booleanValue() && !self.data.isProtected()) {
            world.method_8501(pos, (class_2680)state.method_11657((class_2769)AbstractGraveBlock.IS_LOCKED, (Comparable)Boolean.valueOf(false)));
            if (self.model != null) {
                self.model.updateModel();
            }
        }
        self.model.maybeTick(world.method_8510());
    }

    @Override
    public void onModelChanged(String model) {
        if (this.model != null) {
            this.model.updateModel();
        }
    }

    public void breakBlock() {
        this.breakBlock(true);
    }

    public void breakBlock(boolean canCreateVisual) {
        assert (this.field_11863 != null);
        if (canCreateVisual && ConfigManager.getConfig().placement.createVisualGrave) {
            this.field_11863.method_8652(this.field_11867, VisualGraveBlock.INSTANCE.method_34725(this.method_11010()), 19);
            class_2586 class_25862 = this.field_11863.method_8321(this.field_11867);
            if (class_25862 instanceof VisualGraveBlockEntity) {
                VisualGraveBlockEntity blockEntity = (VisualGraveBlockEntity)class_25862;
                blockEntity.setVisualData(this.getClientData(), this.replacedBlockState);
                blockEntity.setModelId(this.getGraveModelId());
            }
        } else {
            this.field_11863.method_8652(this.field_11867, this.replacedBlockState, 19);
        }
    }

    @Override
    @Nullable
    public Grave getGrave() {
        if (this.data == null) {
            this.fetchGraveData();
        }
        return this.data;
    }

    @Override
    public VisualGraveData getClientData() {
        return this.data != null ? this.data.toVisualGraveData() : this.visualData;
    }

    @Override
    public void updateModel() {
        if (this.model != null) {
            this.model.updateModel();
        }
    }

    @Override
    public boolean isGraveProtected() {
        return (Boolean)this.method_11010().method_11654((class_2769)AbstractGraveBlock.IS_LOCKED);
    }

    @Override
    public boolean isGraveBroken() {
        return false;
    }

    @Override
    public boolean isGravePlayerMade() {
        return false;
    }

    @Override
    public boolean isGravePaymentRequired() {
        return this.getGrave() != null && this.data.isPaymentRequired();
    }

    @Override
    public class_2561 getGravePlaceholder(String id) {
        Map<String, Object> x = this.cachedPlaceholders;
        if (x == null) {
            assert (this.field_11863 != null);
            MinecraftServer server = this.field_11863.method_8503();
            this.cachedPlaceholders = x = this.getGrave() != null && server != null ? this.data.getPlaceholders(server) : Map.of();
        }
        return x.getOrDefault(id, EMPTY_TEXT);
    }

    @Override
    public GameProfile getGraveGameProfile() {
        return this.getGrave() != null ? this.data.getProfile() : Grave.DEFAULT_GAME_PROFILE;
    }

    @Override
    public class_1799 getGraveSlotItem(int i) {
        List<PositionedItemStack> items;
        if (this.getGrave() != null && i < (items = this.data.getItems()).size()) {
            return items.get(i).stack();
        }
        return class_1799.field_8037;
    }

    @Override
    public class_1799 getGraveTaggedItem(class_2960 identifier) {
        if (this.getGrave() != null) {
            return this.data.getTaggedItem(identifier);
        }
        return class_1799.field_8037;
    }

    @Override
    public class_1306 getGraveMainArm() {
        return this.getGrave() != null ? this.data.mainArm() : class_1306.field_6183;
    }

    @Override
    public byte getGraveSkinModelLayers() {
        return this.getGrave() != null ? this.data.visibleSkinModelParts() : (byte)-1;
    }

    @Override
    public boolean isGravePlayerModelDelayed() {
        return this.getGrave() != null && this.data.delayPlayerModel();
    }
}

