/*
 * Decompiled with CFR 0.152.
 */
package net.zestyblaze.lootr.advancement;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_179;
import net.minecraft.class_195;
import net.minecraft.class_2048;
import net.minecraft.class_2960;
import net.minecraft.class_2985;
import net.minecraft.class_3222;
import net.minecraft.class_5257;
import net.minecraft.class_5258;
import net.zestyblaze.lootr.api.advancement.IGenericPredicate;
import org.jetbrains.annotations.NotNull;

public class GenericTrigger<T>
implements class_179<Instance<T>> {
    private final class_2960 id;
    private final Map<class_2985, Listeners<T>> listeners = Maps.newHashMap();
    private final IGenericPredicate<T> predicate;

    public GenericTrigger(String id, IGenericPredicate<T> predicate) {
        this(new class_2960(id), predicate);
    }

    public GenericTrigger(class_2960 id, IGenericPredicate<T> predicate) {
        this.id = id;
        this.predicate = predicate;
    }

    @NotNull
    public class_2960 method_794() {
        return this.id;
    }

    public void method_792(@NotNull class_2985 advancementsIn, @NotNull class_179.class_180<Instance<T>> listener) {
        Listeners<T> list = this.listeners.get(advancementsIn);
        if (list == null) {
            list = new Listeners(advancementsIn);
            this.listeners.put(advancementsIn, list);
        }
        list.add(listener);
    }

    public void method_793(@NotNull class_2985 advancementsIn, @NotNull class_179.class_180<Instance<T>> listener) {
        Listeners<T> list = this.listeners.get(advancementsIn);
        if (list != null) {
            list.remove(listener);
            if (list.isEmpty()) {
                this.listeners.remove(advancementsIn);
            }
        }
    }

    public void method_791(@NotNull class_2985 advancementsIn) {
        this.listeners.remove(advancementsIn);
    }

    public Instance<T> createInstance(JsonObject jsonObject, class_5257 conditionArrayParser) {
        class_5258 contextawarepredicate = class_2048.method_51705((JsonObject)jsonObject, (String)"player", (class_5257)conditionArrayParser);
        return this.createInstance(jsonObject, contextawarepredicate, conditionArrayParser);
    }

    public Instance<T> createInstance(JsonObject jsonObject, class_5258 context, class_5257 conditionArrayParser) {
        return new Instance<T>(this.method_794(), context, this.predicate.deserialize(jsonObject));
    }

    public void trigger(class_3222 player, T condition) {
        Listeners<T> list = this.listeners.get(player.method_14236());
        if (list != null) {
            list.trigger(player, condition);
        }
    }

    public static class Listeners<T> {
        class_2985 advancements;
        Set<class_179.class_180<Instance<T>>> listeners = Sets.newHashSet();

        Listeners(class_2985 advancementsIn) {
            this.advancements = advancementsIn;
        }

        public boolean isEmpty() {
            return this.listeners.isEmpty();
        }

        public void add(class_179.class_180<Instance<T>> listener) {
            this.listeners.add(listener);
        }

        public void remove(class_179.class_180<Instance<T>> listener) {
            this.listeners.remove(listener);
        }

        void trigger(class_3222 player, T condition) {
            ArrayList list = Lists.newArrayList();
            for (class_179.class_180<Instance<T>> class_1802 : this.listeners) {
                if (!((Instance)class_1802.method_797()).test(player, condition)) continue;
                list.add(class_1802);
            }
            if (list.size() != 0) {
                for (class_179.class_180 class_1803 : list) {
                    class_1803.method_796(this.advancements);
                }
            }
        }
    }

    public static class Instance<T>
    extends class_195 {
        IGenericPredicate<T> predicate;

        Instance(class_2960 location, class_5258 contextPredicate, IGenericPredicate<T> predicate) {
            super(location, contextPredicate);
            this.predicate = predicate;
        }

        public boolean test(class_3222 player, T event) {
            return this.predicate.test(player, event);
        }
    }
}

