/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.addons.biome.pipeline.v2.stage.mutators;

import com.dfsek.terra.addons.biome.pipeline.v2.api.Stage;
import com.dfsek.terra.addons.biome.pipeline.v2.api.biome.PipelineBiome;
import com.dfsek.terra.addons.biome.pipeline.v2.pipeline.BiomeChunkImpl;
import com.dfsek.terra.api.noise.NoiseSampler;
import com.dfsek.terra.api.util.collection.ProbabilityCollection;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Stream;

public class ReplaceListStage
implements Stage {
    private final Map<PipelineBiome, ProbabilityCollection<PipelineBiome>> replace;
    private final NoiseSampler sampler;
    private final ProbabilityCollection<PipelineBiome> replaceDefault;
    private final String defaultTag;

    public ReplaceListStage(Map<PipelineBiome, ProbabilityCollection<PipelineBiome>> replace, String defaultTag, ProbabilityCollection<PipelineBiome> replaceDefault, NoiseSampler sampler) {
        this.replace = replace;
        this.sampler = sampler;
        this.defaultTag = defaultTag;
        this.replaceDefault = replaceDefault;
    }

    @Override
    public PipelineBiome apply(BiomeChunkImpl.ViewPoint viewPoint) {
        PipelineBiome center = viewPoint.getBiome();
        if (this.replace.containsKey(center)) {
            PipelineBiome biome = (PipelineBiome)this.replace.get(center).get(this.sampler, (double)viewPoint.worldX(), (double)viewPoint.worldZ(), viewPoint.worldSeed());
            return biome.isSelf() ? viewPoint.getBiome() : biome;
        }
        if (viewPoint.getBiome().getTags().contains(this.defaultTag)) {
            PipelineBiome biome = (PipelineBiome)this.replaceDefault.get(this.sampler, (double)viewPoint.worldX(), (double)viewPoint.worldZ(), viewPoint.worldSeed());
            return biome.isSelf() ? viewPoint.getBiome() : biome;
        }
        return center;
    }

    @Override
    public int maxRelativeReadDistance() {
        return 0;
    }

    @Override
    public Iterable<PipelineBiome> getBiomes(Iterable<PipelineBiome> biomes) {
        HashSet<PipelineBiome> biomeSet = new HashSet<PipelineBiome>();
        HashSet reject = new HashSet();
        biomes.forEach(biome -> {
            if (!biome.getTags().contains(this.defaultTag) && !this.replace.containsKey(biome)) {
                biomeSet.add((PipelineBiome)biome);
            } else {
                reject.add(biome);
            }
        });
        biomeSet.addAll(this.replaceDefault.getContents().stream().flatMap(terraBiome -> {
            if (terraBiome.isSelf()) {
                return reject.stream();
            }
            return Stream.of(terraBiome);
        }).toList());
        this.replace.forEach((biome, collection) -> biomeSet.addAll(collection.getContents().stream().map(terraBiome -> {
            if (terraBiome.isSelf()) {
                return biome;
            }
            return terraBiome;
        }).toList()));
        return biomeSet;
    }
}

