/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.addons.biome.pipeline.v2.stage.mutators;

import com.dfsek.terra.addons.biome.pipeline.v2.api.Stage;
import com.dfsek.terra.addons.biome.pipeline.v2.api.biome.PipelineBiome;
import com.dfsek.terra.addons.biome.pipeline.v2.pipeline.BiomeChunkImpl;
import com.dfsek.terra.api.noise.NoiseSampler;
import java.util.Objects;

public class SmoothStage
implements Stage {
    private final NoiseSampler sampler;

    public SmoothStage(NoiseSampler sampler) {
        this.sampler = sampler;
    }

    @Override
    public PipelineBiome apply(BiomeChunkImpl.ViewPoint viewPoint) {
        PipelineBiome top = viewPoint.getRelativeBiome(1, 0);
        PipelineBiome bottom = viewPoint.getRelativeBiome(-1, 0);
        PipelineBiome left = viewPoint.getRelativeBiome(0, 1);
        PipelineBiome right = viewPoint.getRelativeBiome(0, -1);
        double roll = this.sampler.noise(viewPoint.worldSeed(), viewPoint.worldX(), viewPoint.worldZ());
        boolean vert = Objects.equals(top, bottom);
        boolean horiz = Objects.equals(left, right);
        if (vert && horiz) {
            return roll > 0.0 ? (roll > 0.25 ? left : right) : (roll > -0.25 ? top : bottom);
        }
        if (vert) {
            return roll > 0.0 ? top : bottom;
        }
        if (horiz) {
            return roll > 0.0 ? left : right;
        }
        return viewPoint.getBiome();
    }

    @Override
    public int maxRelativeReadDistance() {
        return 1;
    }
}

