/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.splashy;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.Expose;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.util.List;
import net.darkhax.splashy.Constants;
import net.darkhax.splashy.platform.Services;

public class Config {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().excludeFieldsWithoutExposeAnnotation().create();
    @Expose
    public boolean includeVanillaSplashes = true;
    @Expose
    public boolean includeModNames = true;
    @Expose
    public List<String> customSplashes = List.of("splash.splashy.squirrels", "splash.splashy.direwolf", "splash.splashy.error_1", "splash.splashy.potato_knishes", "splash.splashy.snail_facts", "splash.splashy.blm", "splash.splashy.blame_jared", "splash.splashy.tips", "splash.splashy.birch_forest", "splash.splashy.multiloader");

    public static Config load() {
        File configFile = Services.HELPER.getConfigDir().resolve("splashy.json").toFile();
        Config config = new Config();
        if (configFile.exists()) {
            try (FileReader reader = new FileReader(configFile);){
                config = (Config)GSON.fromJson((Reader)reader, Config.class);
                Constants.LOG.info("Loaded config file.");
            }
            catch (Exception e) {
                Constants.LOG.error("Could not read config file {}. Defaults will be used.", (Object)configFile.getAbsolutePath());
                Constants.LOG.catching((Throwable)e);
            }
        } else {
            Constants.LOG.info("Creating a new config file at {}.", (Object)configFile.getAbsolutePath());
            configFile.getParentFile().mkdirs();
        }
        try (FileWriter writer = new FileWriter(configFile);){
            GSON.toJson((Object)config, (Appendable)writer);
            Constants.LOG.info("Saved config file.");
        }
        catch (Exception e) {
            Constants.LOG.error("Could not write config file '{}'!", (Object)configFile.getAbsolutePath());
            Constants.LOG.catching((Throwable)e);
        }
        return config;
    }
}

