/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.otyacraftengine.client.gui.components;

import dev.felnull.otyacraftengine.client.gui.TextureRegion;
import dev.felnull.otyacraftengine.client.gui.components.base.OEBasedWidget;
import dev.felnull.otyacraftengine.client.util.OEClientUtils;
import dev.felnull.otyacraftengine.client.util.OERenderUtils;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_1144;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FixedListWidget<E>
extends OEBasedWidget {
    private static final TextureRegion DEFAULT_TEXTURE = TextureRegion.relative(OE_WIDGETS, 40.0f, 34.0f, 18.0f, 42.0f);
    @NotNull
    private List<E> entryList;
    @NotNull
    private final Function<E, class_2561> entryName;
    @Nullable
    private final PressEntry<E> onPressEntry;
    private final boolean selectable;
    private final int entryShowCount;
    private boolean border;
    private float scrollAmount;
    private boolean canScroll;
    protected boolean isHoveredScrollBar;
    protected int hoveredNumber;
    @Nullable
    protected E selectedEntry;
    protected int selectedEntryIndex = -1;

    public FixedListWidget(int x, int y, int width, int height, @NotNull class_2561 message, int entryShowCount, @NotNull List<E> entryList, @NotNull Function<E, class_2561> entryName, @Nullable PressEntry<E> onPressEntry, boolean selectable, @Nullable FixedListWidget<E> old) {
        this(x, y, width, height, message, entryShowCount, entryList, entryName, onPressEntry, selectable, DEFAULT_TEXTURE, old);
    }

    public FixedListWidget(int x, int y, int width, int height, @NotNull class_2561 message, int entryShowCount, @NotNull List<E> entryList, @NotNull Function<E, class_2561> entryName, @Nullable PressEntry<E> onPressEntry, boolean selectable, @NotNull TextureRegion texture, @Nullable FixedListWidget<E> old) {
        super(x, y, width, height, "fixedListWidget", message, texture);
        this.entryShowCount = entryShowCount;
        this.entryList = entryList;
        this.entryName = entryName;
        this.onPressEntry = onPressEntry;
        this.selectable = selectable;
        this.copyValue(old);
    }

    public void method_25394(class_332 guiGraphics, int mx, int my, float parTick) {
        if (this.field_22764) {
            this.hoveredNumber = (my - this.method_46427()) / this.getIndividualHeight();
            this.isHoveredScrollBar = mx >= this.method_46426() + this.getIndividualWidth() && my >= this.method_46427() && mx < this.method_46426() + this.field_22758 && my < this.method_46427() + this.field_22759;
        }
        super.method_25394(guiGraphics, mx, my, parTick);
    }

    public void method_48579(class_332 guiGraphics, int mx, int my, float parTick) {
        int cn;
        for (int i = 0; i < this.entryShowCount && (cn = this.getCurrentFirstEntryIndex() + i) < this.entryList.size() && cn >= 0; ++i) {
            E e = this.entryList.get(cn);
            this.renderOneButton(guiGraphics, e, cn, i, this.method_46426(), this.method_46427() + this.getIndividualHeight() * i, mx, my, parTick, this.selectedEntry == this.entryList.get(cn));
        }
        this.renderScrollbar(guiGraphics, this.method_46426() + this.getIndividualWidth(), this.method_46427(), 9, this.field_22759);
    }

    protected void renderScrollbar(class_332 guiGraphics, int x, int y, int w, int h) {
        class_4587 poseStack = guiGraphics.method_51448();
        boolean hv = this.isScrollBarHovered() || this.method_25370();
        OERenderUtils.drawTexture(this.getTexture().location(), poseStack, x, y, this.getTexture().u0() + (float)(hv ? 9 : 0), this.getTexture().v0(), 9.0f, 3.0f, this.getTexture().width(), this.getTexture().height());
        int bsct = (this.field_22759 - 6) / 16;
        for (int i = 0; i < bsct; ++i) {
            OERenderUtils.drawTexture(this.getTexture().location(), poseStack, x, y + 3 + i * 16, this.getTexture().u0() + (float)(hv ? 9 : 0), this.getTexture().v0() + 3.0f, 9.0f, 16.0f, this.getTexture().width(), this.getTexture().height());
        }
        int bsam = (this.field_22759 - 6) % 16;
        OERenderUtils.drawTexture(this.getTexture().location(), poseStack, x, y + 3 + bsct * 16, this.getTexture().u0() + (float)(hv ? 9 : 0), this.getTexture().v0() + 3.0f, 9.0f, bsam, this.getTexture().width(), this.getTexture().height());
        OERenderUtils.drawTexture(this.getTexture().location(), poseStack, x, y + this.field_22759 - 3, this.getTexture().u0() + (float)(hv ? 9 : 0), this.getTexture().v0() + 19.0f, 9.0f, 3.0f, this.getTexture().width(), this.getTexture().height());
        int barHeight = this.getBarHeight();
        float barY = (float)(this.getActualHeight() - barHeight) * this.scrollAmount;
        OERenderUtils.drawTexture(this.getTexture().location(), poseStack, x + 1, (float)(y + 1) + barY, this.getTexture().u0() + (float)(hv ? 7 : 0), this.getTexture().v0() + 22.0f, 7.0f, 3.0f, this.getTexture().width(), this.getTexture().height());
        int ssct = (barHeight - 6) / 14;
        for (int i = 0; i < ssct; ++i) {
            OERenderUtils.drawTexture(this.getTexture().location(), poseStack, x + 1, (float)(y + 4 + i * 14) + barY, this.getTexture().u0() + (float)(hv ? 7 : 0), this.getTexture().v0() + 25.0f, 7.0f, 14.0f, this.getTexture().width(), this.getTexture().height());
        }
        int ssam = (barHeight - 6) % 14;
        OERenderUtils.drawTexture(this.getTexture().location(), poseStack, x + 1, (float)(y + 4 + ssct * 14) + barY, this.getTexture().u0() + (float)(hv ? 7 : 0), this.getTexture().v0() + 25.0f, 7.0f, ssam, this.getTexture().width(), this.getTexture().height());
        OERenderUtils.drawTexture(this.getTexture().location(), poseStack, x + 1, (float)(y + 1 + barHeight - 3) + barY, this.getTexture().u0() + (float)(hv ? 7 : 0), this.getTexture().v0() + 39.0f, 7.0f, 3.0f, this.getTexture().width(), this.getTexture().height());
    }

    protected void renderOneButton(class_332 guiGraphics, E item, int lnum, int bnum, int bX, int bY, int mx, int my, float parTick, boolean selected) {
        guiGraphics.method_51422(1.0f, 1.0f, 1.0f, this.field_22765);
        guiGraphics.method_49697(field_22757, bX, bY, this.getIndividualWidth(), this.getIndividualHeight(), 20, 4, 200, 20, 0, this.getTextureY(this.isEntryHovered(bnum)));
        guiGraphics.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
        int k = this.field_22763 ? 0xFFFFFF : 0xA0A0A0;
        this.renderString(guiGraphics, this.getMessage(lnum), k | class_3532.method_15386((float)(this.field_22765 * 255.0f)) << 24, bX, bY);
    }

    public void renderString(class_332 guiGraphics, class_2561 message, int i, int x, int y) {
        this.renderScrollingString(guiGraphics, message, 2, i, x, y);
    }

    protected void renderScrollingString(class_332 guiGraphics, class_2561 message, int i, int j, int x, int y) {
        int k = x + i;
        int l = x + this.getIndividualWidth() - i;
        FixedListWidget.method_49605((class_332)guiGraphics, (class_327)FixedListWidget.mc.field_1772, (class_2561)message, (int)k, (int)y, (int)l, (int)(y + this.getIndividualHeight()), (int)j);
    }

    private int getTextureY(boolean hoverd) {
        int i = 1;
        if (!this.field_22763) {
            i = 0;
        } else if (hoverd) {
            i = 2;
        }
        return 46 + i * 20;
    }

    @Override
    public void onFocusedClick() {
    }

    public void method_25354(@NotNull class_1144 soundManager) {
        boolean nflg;
        boolean flg = this.isEntryHovered(this.hoveredNumber);
        boolean bl = nflg = this.entryList.size() > this.hoveredNumber;
        if (!flg || nflg) {
            super.method_25354(soundManager);
        }
    }

    @Override
    public void method_25348(double mx, double my) {
        this.onPress((int)((my - (double)this.method_46427()) / (double)this.getIndividualHeight()));
        super.method_25348(mx, my);
    }

    public boolean method_25403(double mx, double my, int i, double f, double g) {
        this.scroll(my);
        return super.method_25403(mx, my, i, f, g);
    }

    public boolean method_25402(double mx, double my, int i) {
        this.canScroll = this.isScrollBarHovered();
        this.scroll(my);
        return super.method_25402(mx, my, i);
    }

    public boolean method_25401(double d, double e, double f) {
        this.setScrollAmount(this.getScrollAmount() - this.getMouseScrollAmount(f));
        return true;
    }

    @Override
    public boolean method_25404(int i, int j, int k) {
        if (this.field_22763 && this.field_22764 && this.method_25367()) {
            if (i == 265) {
                this.setScrollAmount(this.getScrollAmount() - 0.3f * ((float)this.entryShowCount / (float)this.field_22759));
                return true;
            }
            if (i == 264) {
                this.setScrollAmount(this.getScrollAmount() + 0.3f * ((float)this.entryShowCount / (float)this.field_22759));
                return true;
            }
        }
        return false;
    }

    public void onPress(int num) {
        int cn = this.getCurrentFirstEntryIndex() + num;
        if (cn < this.entryList.size() && this.isEntryHovered(num)) {
            E e = this.entryList.get(cn);
            if (this.selectable) {
                this.selectedEntry = e;
                this.selectedEntryIndex = cn;
            }
            if (this.onPressEntry != null) {
                this.onPressEntry.onPressEntry(this, e);
            }
        }
    }

    public void setSelectedEntry(int index) {
        if (index >= 0 && index < this.entryList.size()) {
            this.selectedEntry = this.entryList.get(index);
            this.selectedEntryIndex = index;
        } else {
            this.selectedEntry = null;
            this.selectedEntryIndex = -1;
        }
    }

    public void setSelectedEntry(@Nullable E selectedEntry) {
        if (selectedEntry == null || this.entryList.stream().anyMatch(n -> n == selectedEntry)) {
            this.selectedEntry = selectedEntry;
            this.selectedEntryIndex = selectedEntry == null ? -1 : this.entryList.indexOf(selectedEntry);
        }
    }

    @Nullable
    public E getSelectedEntry() {
        if (this.entryList.stream().anyMatch(n -> n == this.selectedEntry)) {
            return this.selectedEntry;
        }
        return null;
    }

    public int getSelectedEntryIndex() {
        if (this.getSelectedEntry() == null) {
            return -1;
        }
        return this.selectedEntryIndex;
    }

    protected int getCurrentFirstEntryIndex() {
        if (this.entryList.size() <= this.entryShowCount) {
            return 0;
        }
        return (int)((float)(this.entryList.size() - this.entryShowCount) * this.scrollAmount);
    }

    public boolean isEntryHovered(int lnum) {
        return this.field_22762 && this.hoveredNumber == lnum && !this.isHoveredScrollBar;
    }

    public boolean isScrollBarHovered() {
        return this.field_22762 && this.isHoveredScrollBar;
    }

    public class_2561 getMessage(int index) {
        return this.entryName.apply(this.entryList.get(index));
    }

    public void scroll(double mouseY) {
        if (this.canScroll) {
            int cy = (int)(mouseY - (double)this.method_46427() - 1.0 - (double)(this.getBarHeight() / 2));
            int sa = this.getActualHeight() - this.getBarHeight();
            if (sa > 0) {
                this.setScrollAmount((float)cy / (float)sa);
            }
        }
    }

    public int getBarHeight() {
        return class_3532.method_15340((int)((int)((float)this.getActualHeight() / ((float)this.entryList.size() / (float)this.entryShowCount))), (int)10, (int)this.getActualHeight());
    }

    public float getScrollAmount() {
        return this.scrollAmount;
    }

    public void setScrollAmount(float scrollAmount) {
        this.scrollAmount = class_3532.method_15363((float)scrollAmount, (float)0.0f, (float)1.0f);
    }

    public int getActualHeight() {
        return this.field_22759 - 2;
    }

    public int getIndividualHeight() {
        return this.field_22759 / this.entryShowCount;
    }

    public int getIndividualWidth() {
        return this.field_22758 - (9 + (this.border ? 0 : 1));
    }

    @NotNull
    public List<E> getEntryList() {
        return this.entryList;
    }

    public void setEntryList(@NotNull List<E> entryList) {
        this.entryList = entryList;
    }

    public boolean isBorder() {
        return this.border;
    }

    public void setBorder(boolean border) {
        this.border = border;
    }

    public void copyValue(@Nullable FixedListWidget<E> copyValue) {
        if (copyValue != null) {
            this.selectedEntry = copyValue.selectedEntry;
            this.scrollAmount = copyValue.scrollAmount;
            this.selectedEntryIndex = copyValue.selectedEntryIndex;
        }
    }

    public float getMouseScrollAmount(double mouseAmount) {
        float am = (float)this.getIndividualHeight() / ((float)this.getIndividualHeight() * (float)Math.max(this.entryList.size() - this.entryShowCount, 1));
        float m = 1.0f;
        if (OEClientUtils.isKeyInput(FixedListWidget.mc.field_1690.field_1832)) {
            m *= 3.0f;
        }
        if (OEClientUtils.isKeyInput(FixedListWidget.mc.field_1690.field_1867)) {
            m *= 10.0f;
        }
        return (float)mouseAmount * am * m;
    }

    public static interface PressEntry<E> {
        public void onPressEntry(FixedListWidget<E> var1, E var2);
    }
}

