/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.fabric.event;

import java.util.ArrayList;
import java.util.List;
import net.blay09.mods.balm.api.event.BreakBlockEvent;
import net.blay09.mods.balm.api.event.PlayerConnectedEvent;
import net.blay09.mods.balm.api.event.PlayerLoginEvent;
import net.blay09.mods.balm.api.event.PlayerLogoutEvent;
import net.blay09.mods.balm.api.event.PlayerRespawnEvent;
import net.blay09.mods.balm.api.event.ServerPlayerTickHandler;
import net.blay09.mods.balm.api.event.TickPhase;
import net.blay09.mods.balm.api.event.TickType;
import net.blay09.mods.balm.api.event.UseBlockEvent;
import net.blay09.mods.balm.api.event.UseItemEvent;
import net.blay09.mods.balm.api.event.server.ServerStartedEvent;
import net.blay09.mods.balm.api.event.server.ServerStoppedEvent;
import net.blay09.mods.balm.fabric.event.FabricBalmEvents;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_3222;

public class FabricBalmCommonEvents {
    private static final List<ServerPlayerTickHandler> playerTickStartHandlers = new ArrayList<ServerPlayerTickHandler>();
    private static final List<ServerPlayerTickHandler> playerTickEndHandlers = new ArrayList<ServerPlayerTickHandler>();
    private static ServerTickEvents.StartTick serverTickStartListener = null;
    private static ServerTickEvents.EndTick serverTickEndListener = null;

    public static void registerEvents(FabricBalmEvents events) {
        events.registerTickEvent(TickType.Server, TickPhase.Start, handler -> ServerTickEvents.START_SERVER_TICK.register(handler::handle));
        events.registerTickEvent(TickType.Server, TickPhase.End, handler -> ServerTickEvents.END_SERVER_TICK.register(handler::handle));
        events.registerTickEvent(TickType.ServerLevel, TickPhase.Start, handler -> ServerTickEvents.START_WORLD_TICK.register(handler::handle));
        events.registerTickEvent(TickType.ServerLevel, TickPhase.End, handler -> ServerTickEvents.END_WORLD_TICK.register(handler::handle));
        events.registerTickEvent(TickType.ServerPlayer, TickPhase.Start, handler -> {
            if (serverTickStartListener == null) {
                serverTickStartListener = server -> {
                    for (class_3222 player : server.method_3760().method_14571()) {
                        for (ServerPlayerTickHandler playerTickHandler : playerTickStartHandlers) {
                            playerTickHandler.handle(player);
                        }
                    }
                };
                ServerTickEvents.START_SERVER_TICK.register((Object)serverTickStartListener);
            }
            playerTickStartHandlers.add((ServerPlayerTickHandler)handler);
        });
        events.registerTickEvent(TickType.ServerPlayer, TickPhase.End, handler -> {
            if (serverTickEndListener == null) {
                serverTickEndListener = server -> {
                    for (class_3222 player : server.method_3760().method_14571()) {
                        for (ServerPlayerTickHandler playerTickHandler : playerTickEndHandlers) {
                            playerTickHandler.handle(player);
                        }
                    }
                };
                ServerTickEvents.END_SERVER_TICK.register((Object)serverTickEndListener);
            }
            playerTickEndHandlers.add((ServerPlayerTickHandler)handler);
        });
        events.registerEvent(ServerStartedEvent.class, () -> ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            ServerStartedEvent event = new ServerStartedEvent(server);
            events.fireEventHandlers(event);
        }));
        events.registerEvent(ServerStoppedEvent.class, () -> ServerLifecycleEvents.SERVER_STOPPED.register(server -> {
            ServerStoppedEvent event = new ServerStoppedEvent(server);
            events.fireEventHandlers(event);
        }));
        events.registerEvent(UseBlockEvent.class, () -> UseBlockCallback.EVENT.register((player, world, hand, hitResult) -> {
            UseBlockEvent event = new UseBlockEvent(player, world, hand, hitResult);
            events.fireEventHandlers(event);
            if (event.isCanceled()) {
                return class_1269.field_5814;
            }
            return event.getInteractionResult();
        }));
        events.registerEvent(UseItemEvent.class, () -> UseItemCallback.EVENT.register((player, world, hand) -> {
            UseItemEvent event = new UseItemEvent(player, world, hand);
            events.fireEventHandlers(event);
            if (event.isCanceled()) {
                return class_1271.method_22431((Object)player.method_5998(hand));
            }
            return new class_1271(event.getInteractionResult(), (Object)player.method_5998(hand));
        }));
        events.registerEvent(PlayerConnectedEvent.class, () -> ServerPlayConnectionEvents.JOIN.register((listener, sender, server) -> {
            PlayerLoginEvent event = new PlayerLoginEvent(listener.field_14140);
            events.fireEventHandlers(event);
        }));
        events.registerEvent(PlayerLogoutEvent.class, () -> ServerPlayConnectionEvents.DISCONNECT.register((listener, server) -> {
            PlayerLogoutEvent event = new PlayerLogoutEvent(listener.field_14140);
            events.fireEventHandlers(event);
        }));
        events.registerEvent(BreakBlockEvent.class, () -> PlayerBlockBreakEvents.BEFORE.register((world, player, pos, state, blockEntity) -> {
            BreakBlockEvent event = new BreakBlockEvent(world, player, pos, state, blockEntity);
            events.fireEventHandlers(event);
            return !event.isCanceled();
        }));
        events.registerEvent(PlayerRespawnEvent.class, () -> ServerPlayerEvents.AFTER_RESPAWN.register((oldPlayer, newPlayer, alive) -> {
            PlayerRespawnEvent event = new PlayerRespawnEvent(oldPlayer, newPlayer);
            events.fireEventHandlers(event);
        }));
    }
}

