/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createenchantmentindustry.foundation.ponder.content;

import com.google.common.collect.Lists;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.content.fluids.spout.SpoutBlockEntity;
import com.simibubi.create.content.fluids.tank.CreativeFluidTankBlockEntity;
import com.simibubi.create.content.fluids.tank.FluidTankBlockEntity;
import com.simibubi.create.content.kinetics.deployer.DeployerBlockEntity;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.foundation.ponder.ElementLink;
import com.simibubi.create.foundation.ponder.PonderPalette;
import com.simibubi.create.foundation.ponder.SceneBuilder;
import com.simibubi.create.foundation.ponder.SceneBuildingUtil;
import com.simibubi.create.foundation.ponder.Selection;
import com.simibubi.create.foundation.ponder.element.InputWindowElement;
import com.simibubi.create.foundation.ponder.instruction.EmitParticlesInstruction;
import com.simibubi.create.foundation.utility.Pointing;
import com.tterrag.registrate.fabric.SimpleFlowableFluid;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import io.github.fabricators_of_create.porting_lib.util.FluidStack;
import io.github.fabricators_of_create.porting_lib.util.NBTSerializer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1472;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_5819;
import net.minecraft.class_8080;
import plus.dragons.createenchantmentindustry.content.contraptions.enchanting.enchanter.BlazeEnchanterBlock;
import plus.dragons.createenchantmentindustry.content.contraptions.enchanting.enchanter.BlazeEnchanterBlockEntity;
import plus.dragons.createenchantmentindustry.content.contraptions.enchanting.printer.PrinterBlockEntity;
import plus.dragons.createenchantmentindustry.content.contraptions.fluids.experience.ExperienceFluid;
import plus.dragons.createenchantmentindustry.content.contraptions.fluids.experience.HyperExperienceFluid;
import plus.dragons.createenchantmentindustry.entry.CeiBlocks;
import plus.dragons.createenchantmentindustry.entry.CeiFluids;
import plus.dragons.createenchantmentindustry.entry.CeiItems;

public class EnchantmentScenes {
    public static void disenchant(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("disenchant", "Disenchanting");
        scene.configureBasePlate(0, 0, 7);
        scene.scaleSceneView(0.68f);
        scene.world.setKineticSpeed(util.select.everywhere(), 32.0f);
        scene.showBasePlate();
        scene.idle(5);
        scene.world.showSection(util.select.fromTo(0, 1, 0, 6, 4, 6), class_2350.field_11033);
        scene.overlay.showText(100).text("All received items will have their enchantments removed and the removed enchantments will be converted to liquid experience for storage.").attachKeyFrame().placeNearTarget().pointAt(util.vector.topOf(1, 1, 1));
        scene.world.propagatePipeChange(util.grid.at(2, 1, 5));
        class_2338 beltStart = util.grid.at(6, 1, 1);
        List<class_1799> items = Stream.of(class_1802.field_22022, class_1802.field_8403, class_1802.field_8058, class_1802.field_8598, class_1802.field_8267, class_1802.field_8753, class_1802.field_8406).map(class_1792::method_7854).toList();
        for (class_1799 item : items) {
            EnchantmentScenes.enchantRandomly(item);
            ElementLink itemEntity = scene.world.createItemEntity(util.vector.centerOf(6, 4, 1), util.vector.of(0.0, 0.0, 0.0), item);
            scene.idle(13);
            scene.world.modifyEntity(itemEntity, class_1297::method_31472);
            scene.world.createItemOnBelt(beltStart, class_2350.field_11033, item);
            scene.idle(2);
        }
        scene.idle(80);
        scene.overlay.showText(100).text("Players standing on the disenchanter will be quickly washed away their experience level, and the washed away experience value will be converted into liquid experience for storage").attachKeyFrame().placeNearTarget().pointAt(util.vector.topOf(1, 1, 1));
        scene.idle(120);
    }

    public static void transformBlazeBurner(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("transform", "Using Enchanting Guide");
        scene.configureBasePlate(0, 0, 3);
        scene.showBasePlate();
        scene.idle(5);
        scene.world.showSection(util.select.fromTo(0, 1, 0, 2, 1, 2), class_2350.field_11033);
        scene.overlay.showControls(new InputWindowElement(util.vector.topOf(1, 1, 1), Pointing.DOWN).whileSneaking().rightClick().withItem(CeiItems.ENCHANTING_GUIDE.asStack()), 30);
        scene.overlay.showText(50).text("Right-click the Blaze Burner with an Enchanting Guide in hand when sneaking to transform it to a Blaze Enchanter.").attachKeyFrame().placeNearTarget().pointAt(util.vector.topOf(1, 1, 1));
        scene.idle(30);
        scene.world.setBlock(util.grid.at(1, 1, 1), CeiBlocks.BLAZE_ENCHANTER.getDefaultState(), false);
        scene.world.modifyBlockEntity(util.grid.at(1, 1, 1), BlazeEnchanterBlockEntity.class, be -> be.setTargetItem(EnchantmentScenes.enchantingGuide(class_1893.field_9101, 1)));
        scene.idle(25);
        scene.overlay.showText(100).text("To make Blaze Enchanter work, Enchanting Guide must be configured first. Right-clicking Blaze Enchanter or right-clicking Enchanting Guide in hands can open configuration panel.").attachKeyFrame().placeNearTarget().pointAt(util.vector.centerOf(1, 1, 1));
        scene.idle(105);
        scene.overlay.showControls(new InputWindowElement(util.vector.topOf(1, 1, 1), Pointing.DOWN).whileSneaking().rightClick().withWrench(), 30);
        scene.overlay.showText(50).text("To retrieve the enchanting guide, right-click the Blaze Enchanter with wrench when sneaking.").attachKeyFrame().placeNearTarget().pointAt(util.vector.centerOf(1, 1, 1));
        scene.idle(30);
        scene.world.setBlock(util.grid.at(1, 1, 1), (class_2680)AllBlocks.BLAZE_BURNER.getDefaultState().method_11657((class_2769)BlazeBurnerBlock.HEAT_LEVEL, (Comparable)BlazeBurnerBlock.HeatLevel.SMOULDERING), false);
        scene.idle(25);
        scene.world.setBlock(util.grid.at(1, 1, 1), CeiBlocks.BLAZE_ENCHANTER.getDefaultState(), false);
        scene.world.modifyBlockEntity(util.grid.at(1, 1, 1), BlazeEnchanterBlockEntity.class, be -> be.setTargetItem(EnchantmentScenes.enchantingGuide(class_1893.field_9101, 1)));
        scene.idle(10);
        scene.world.setBlock(util.grid.at(1, 1, 1), (class_2680)AllBlocks.BLAZE_BURNER.getDefaultState().method_11657((class_2769)BlazeBurnerBlock.HEAT_LEVEL, (Comparable)BlazeBurnerBlock.HeatLevel.KINDLED), false);
        scene.overlay.showText(60).text("You can replace the Enchanting Guide by holding it directly in your hand and right-clicking on the Blaze Enchanter.").attachKeyFrame().placeNearTarget().pointAt(util.vector.centerOf(1, 1, 1));
        scene.idle(60);
    }

    public static void enchant(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("enchant", "Enchanting");
        scene.configureBasePlate(0, 0, 8);
        scene.scaleSceneView(0.6f);
        scene.world.setKineticSpeed(util.select.everywhere(), 0.0f);
        scene.showBasePlate();
        scene.idle(5);
        scene.world.setKineticSpeed(util.select.everywhere(), 80.0f);
        scene.world.setKineticSpeed(util.select.fromTo(0, 2, 7, 5, 2, 7), -80.0f);
        scene.world.setKineticSpeed(util.select.fromTo(7, 2, 2, 7, 2, 7), -80.0f);
        scene.world.setBlock(util.grid.at(1, 2, 0), (class_2680)CeiBlocks.BLAZE_ENCHANTER.getDefaultState().method_11657(BlazeEnchanterBlock.HEAT_LEVEL, (Comparable)((Object)BlazeEnchanterBlock.HeatLevel.KINDLED)), false);
        scene.world.setBlock(util.grid.at(0, 2, 6), (class_2680)CeiBlocks.BLAZE_ENCHANTER.getDefaultState().method_11657(BlazeEnchanterBlock.HEAT_LEVEL, (Comparable)((Object)BlazeEnchanterBlock.HeatLevel.KINDLED)), false);
        scene.world.setBlock(util.grid.at(6, 2, 7), (class_2680)CeiBlocks.BLAZE_ENCHANTER.getDefaultState().method_11657(BlazeEnchanterBlock.HEAT_LEVEL, (Comparable)((Object)BlazeEnchanterBlock.HeatLevel.KINDLED)), false);
        scene.world.setBlock(util.grid.at(7, 2, 1), (class_2680)CeiBlocks.BLAZE_ENCHANTER.getDefaultState().method_11657(BlazeEnchanterBlock.HEAT_LEVEL, (Comparable)((Object)BlazeEnchanterBlock.HeatLevel.KINDLED)), false);
        scene.world.modifyBlockEntity(util.grid.at(1, 2, 0), BlazeEnchanterBlockEntity.class, be -> {
            be.setTargetItem(EnchantmentScenes.enchantingGuide(class_1893.field_9097, 1));
            TransferUtil.insertFluid(be.getFluidStorage(null), (FluidStack)new FluidStack(((ExperienceFluid)((Object)((Object)CeiFluids.EXPERIENCE.get()))).method_15751(), 1000L));
        });
        scene.world.modifyBlockEntity(util.grid.at(0, 2, 6), BlazeEnchanterBlockEntity.class, be -> {
            be.setTargetItem(EnchantmentScenes.enchantingGuide(class_1893.field_9097, 2));
            TransferUtil.insertFluid(be.getFluidStorage(null), (FluidStack)new FluidStack(((ExperienceFluid)((Object)((Object)CeiFluids.EXPERIENCE.get()))).method_15751(), 1000L));
        });
        scene.world.modifyBlockEntity(util.grid.at(6, 2, 7), BlazeEnchanterBlockEntity.class, be -> {
            be.setTargetItem(EnchantmentScenes.enchantingGuide(class_1893.field_9101, 1));
            TransferUtil.insertFluid(be.getFluidStorage(null), (FluidStack)new FluidStack(((ExperienceFluid)((Object)((Object)CeiFluids.EXPERIENCE.get()))).method_15751(), 1000L));
        });
        scene.world.modifyBlockEntity(util.grid.at(7, 2, 1), BlazeEnchanterBlockEntity.class, be -> {
            be.setTargetItem(EnchantmentScenes.enchantingGuide(class_1893.field_9119, 1));
            TransferUtil.insertFluid(be.getFluidStorage(null), (FluidStack)new FluidStack(((ExperienceFluid)((Object)((Object)CeiFluids.EXPERIENCE.get()))).method_15751(), 1000L));
        });
        scene.world.modifyBlockEntity(util.grid.at(3, 1, 3), CreativeFluidTankBlockEntity.class, be -> ((CreativeFluidTankBlockEntity.CreativeSmartFluidTank)be.getTankInventory()).setContainedFluid(new FluidStack(((ExperienceFluid)((Object)((Object)CeiFluids.EXPERIENCE.get()))).method_15751(), 1000L)));
        scene.world.propagatePipeChange(util.grid.at(2, 1, 2));
        scene.world.propagatePipeChange(util.grid.at(5, 1, 2));
        scene.world.propagatePipeChange(util.grid.at(5, 1, 5));
        scene.world.propagatePipeChange(util.grid.at(5, 1, 2));
        scene.world.showSection(util.select.fromTo(0, 1, 0, 7, 4, 7), class_2350.field_11033);
        scene.idle(5);
        List<class_1799> items = Stream.of(class_1802.field_22028, class_1802.field_8529, class_1802.field_8598, class_1802.field_8802, class_1802.field_8802, class_1802.field_8577).map(class_1792::method_7854).toList();
        for (class_1799 item : items) {
            class_2338 beltStart = util.grid.at(7, 2, 0);
            ElementLink itemEntity = scene.world.createItemEntity(util.vector.centerOf(7, 5, 0), util.vector.of(0.0, 0.0, 0.0), item);
            scene.idle(13);
            scene.world.modifyEntity(itemEntity, class_1297::method_31472);
            scene.world.createItemOnBelt(beltStart, class_2350.field_11033, item);
            scene.idle(10);
        }
        scene.overlay.showText(60).text("Blaze Enchanter can enchant your items.").attachKeyFrame().placeNearTarget().pointAt(util.vector.topOf(1, 2, 0));
        scene.idle(70);
        scene.overlay.showText(60).text("However, it cannot work on books...").attachKeyFrame().placeNearTarget().pointAt(util.vector.topOf(1, 2, 0));
        scene.idle(70);
        scene.overlay.showText(60).text("... nor can it add incompatible enchantments to your items.").attachKeyFrame().placeNearTarget().pointAt(util.vector.topOf(1, 2, 0));
        scene.idle(70);
        scene.overlay.showText(60).text("Blaze Enchanter can upgrade an existing enchantment to a higher level if feasible").attachKeyFrame().placeNearTarget().pointAt(util.vector.topOf(0, 2, 6));
        scene.idle(70);
        scene.idle(100);
    }

    public static void hyperEnchant(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("hyper_enchant", "Hyper-enchanting");
        scene.configureBasePlate(0, 0, 5);
        scene.scaleSceneView(0.68f);
        scene.showBasePlate();
        scene.idle(5);
        scene.world.modifyBlockEntity(util.grid.at(3, 1, 1), CreativeFluidTankBlockEntity.class, be -> ((CreativeFluidTankBlockEntity.CreativeSmartFluidTank)be.getTankInventory()).setContainedFluid(new FluidStack(((ExperienceFluid)((Object)((Object)CeiFluids.EXPERIENCE.get()))).method_15751(), 1000L)));
        scene.world.modifyBlockEntity(util.grid.at(3, 1, 3), CreativeFluidTankBlockEntity.class, be -> ((CreativeFluidTankBlockEntity.CreativeSmartFluidTank)be.getTankInventory()).setContainedFluid(new FluidStack(((HyperExperienceFluid)((Object)((Object)CeiFluids.HYPER_EXPERIENCE.get()))).method_15751(), 1000L)));
        scene.world.propagatePipeChange(util.grid.at(2, 1, 1));
        scene.world.propagatePipeChange(util.grid.at(2, 1, 3));
        scene.world.showSection(util.select.fromTo(0, 1, 0, 4, 3, 4), class_2350.field_11033);
        scene.overlay.showText(60).text("This is liquid hyper experience").attachKeyFrame().placeNearTarget().pointAt(util.vector.topOf(3, 3, 3));
        scene.overlay.showOutline(PonderPalette.BLUE, new Object(), util.select.fromTo(3, 1, 3, 3, 3, 3), 80);
        scene.idle(90);
        scene.world.setKineticSpeed(util.select.everywhere(), 128.0f);
        scene.idle(25);
        scene.world.setBlock(util.grid.at(1, 2, 1), (class_2680)CeiBlocks.BLAZE_ENCHANTER.getDefaultState().method_11657(BlazeEnchanterBlock.HEAT_LEVEL, (Comparable)((Object)BlazeEnchanterBlock.HeatLevel.KINDLED)), false);
        scene.world.setBlock(util.grid.at(1, 2, 3), (class_2680)CeiBlocks.BLAZE_ENCHANTER.getDefaultState().method_11657(BlazeEnchanterBlock.HEAT_LEVEL, (Comparable)((Object)BlazeEnchanterBlock.HeatLevel.SEETHING)), false);
        scene.idle(15);
        scene.overlay.showOutline(PonderPalette.BLUE, new Object(), util.select.position(1, 2, 3), 80);
        scene.overlay.showText(80).text("Hyper experience can make the Blaze Enchanter into seething state, and the level of the enchantment produced in this state will be one level higher than the set enchantment.").attachKeyFrame().placeNearTarget().pointAt(util.vector.centerOf(1, 2, 3));
        scene.idle(90);
        scene.overlay.showText(60).text("Enchantment with level cap of 1 level cannot be upgraded to level 2 in hyper-enchant.").attachKeyFrame().placeNearTarget().pointAt(util.vector.centerOf(1, 2, 3));
        scene.idle(60);
    }

    public static void handleExperienceNugget(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("absorb_experience_nugget", "Converting Experience Nugget to Liquid");
        scene.configureBasePlate(0, 0, 5);
        scene.scaleSceneView(0.68f);
        scene.world.setKineticSpeed(util.select.everywhere(), 32.0f);
        scene.world.setKineticSpeed(util.select.fromTo(0, 1, 2, 2, 1, 4), -32.0f);
        scene.showBasePlate();
        scene.idle(5);
        scene.world.showSection(util.select.fromTo(0, 1, 0, 4, 1, 4), class_2350.field_11033);
        ArrayList poses = Lists.newArrayList((Object[])new class_2338[]{util.grid.at(2, 1, 0), util.grid.at(0, 1, 2), util.grid.at(2, 1, 4), util.grid.at(4, 1, 2)});
        for (class_2338 pos : poses) {
            class_1799 item = AllItems.EXP_NUGGET.asStack(64);
            ElementLink itemEntity = scene.world.createItemEntity(class_243.method_24953((class_2382)pos.method_10086(3)), util.vector.of(0.0, 0.0, 0.0), item);
            scene.idle(13);
            scene.world.modifyEntity(itemEntity, class_1297::method_31472);
            scene.world.createItemOnBelt(pos, class_2350.field_11033, item);
            scene.idle(10);
        }
        scene.overlay.showText(60).text("Experience nugget can be absorbed by disenchanter.").placeNearTarget().pointAt(util.vector.topOf(2, 1, 2));
        scene.idle(60);
    }

    public static void dropExperienceNugget(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("drop_experience_nugget", "Maybe A Exp-farm?");
        scene.configureBasePlate(0, 0, 3);
        scene.scaleSceneView(1.2f);
        scene.showBasePlate();
        scene.idle(5);
        scene.world.showSection(util.select.fromTo(0, 1, 0, 2, 1, 2), class_2350.field_11033);
        class_2338 deployerPos = util.grid.at(1, 1, 2);
        Selection deployerSelection = util.select.position(deployerPos);
        class_1799 sword = new class_1799((class_1935)class_1802.field_22022);
        scene.idle(10);
        scene.world.modifyBlockEntityNBT(deployerSelection, DeployerBlockEntity.class, nbt -> {
            nbt.method_10566("HeldItem", NBTSerializer.serializeNBT((Object)sword));
            nbt.method_10582("mode", "PUNCH");
        });
        scene.idle(30);
        scene.world.setKineticSpeed(util.select.everywhere(), 32.0f);
        scene.addKeyframe();
        ElementLink sheep = scene.world.createEntity(w -> {
            class_1472 entity = (class_1472)class_1299.field_6115.method_5883(w);
            entity.method_6631(class_1767.field_7954);
            class_243 p = util.vector.topOf(util.grid.at(1, 0, 0));
            entity.method_5814(p.field_1352, p.field_1351, p.field_1350);
            entity.field_6014 = p.field_1352;
            entity.field_6036 = p.field_1351;
            entity.field_5969 = p.field_1350;
            class_8080 animation = entity.field_42108;
            animation.method_48568(-animation.method_48569(), 1.0f);
            animation.method_48567(1.0f);
            entity.field_5982 = 210.0f;
            entity.method_36456(210.0f);
            entity.field_6259 = 210.0f;
            entity.field_6241 = 210.0f;
            return entity;
        });
        scene.idle(5);
        scene.world.moveDeployer(deployerPos, 1.0f, 25);
        scene.idle(26);
        scene.world.modifyEntity(sheep, class_1297::method_31472);
        scene.effects.emitParticles(util.vector.topOf(deployerPos.method_10088(2)).method_1031(0.0, -0.25, 0.0), EmitParticlesInstruction.Emitter.withinBlockSpace((class_2394)new class_2388(class_2398.field_11217, class_2246.field_10459.method_9564()), (class_243)util.vector.of(0.0, 0.0, 0.0)), 25.0f, 1);
        scene.world.moveDeployer(deployerPos, -1.0f, 25);
        scene.overlay.showText(60).text("When mob is killed by deployer, experience nuggets are dropped.").placeNearTarget().pointAt(util.vector.centerOf(1, 1, 2));
        scene.overlay.showOutline(PonderPalette.BLUE, new Object(), util.select.position(1, 1, 2), 50);
        scene.world.flapFunnel(deployerPos.method_10095(), true);
        scene.world.createItemEntity(util.vector.centerOf(deployerPos.method_10067()).method_1023(0.0, 0.45, 0.0), util.vector.of(-0.1, 0.0, 0.0), new class_1799((class_1935)class_1802.field_19050));
        scene.idle(10);
        scene.world.flapFunnel(deployerPos.method_10095(), true);
        scene.world.createItemEntity(util.vector.centerOf(deployerPos.method_10067()).method_1023(0.0, 0.45, 0.0), util.vector.of(-0.1, 0.0, 0.0), new class_1799((class_1935)class_1802.field_8748));
        scene.idle(10);
        scene.world.flapFunnel(deployerPos.method_10095(), true);
        scene.world.createItemEntity(util.vector.centerOf(deployerPos.method_10067()).method_1023(0.0, 0.45, 0.0), util.vector.of(-0.1, 0.0, 0.0), AllItems.EXP_NUGGET.asStack());
        scene.idle(40);
    }

    public static void crushingWheelTweak(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("crushing_wheel_tweak", "We call it inefficiency...");
        scene.configureBasePlate(0, 0, 5);
        scene.scaleSceneView(0.75f);
        scene.showBasePlate();
        scene.idle(5);
        scene.world.showSection(util.select.fromTo(0, 1, 0, 4, 3, 4), class_2350.field_11033);
        Selection crushWheelSelection = util.select.position(util.grid.at(4, 3, 3));
        scene.world.setKineticSpeed(util.select.everywhere(), 128.0f);
        scene.world.setKineticSpeed(crushWheelSelection, -128.0f);
        scene.addKeyframe();
        ElementLink sheep = scene.world.createEntity(w -> {
            class_1472 entity = (class_1472)class_1299.field_6115.method_5883(w);
            entity.method_6631(class_1767.field_7954);
            class_243 p = util.vector.topOf(util.grid.at(4, 3, 2));
            entity.method_5814(p.field_1352, p.field_1351, p.field_1350);
            entity.field_6014 = p.field_1352;
            entity.field_6036 = p.field_1351;
            entity.field_5969 = p.field_1350;
            class_8080 animation = entity.field_42108;
            animation.method_48568(-animation.method_48569(), 1.0f);
            animation.method_48567(1.0f);
            entity.field_5982 = 210.0f;
            entity.method_36456(210.0f);
            entity.field_6259 = 210.0f;
            entity.field_6241 = 210.0f;
            return entity;
        });
        scene.idle(10);
        scene.world.modifyEntity(sheep, class_1297::method_31472);
        scene.effects.emitParticles(util.vector.topOf(util.grid.at(4, 3, 2)).method_1031(0.0, -0.25, 0.0), EmitParticlesInstruction.Emitter.withinBlockSpace((class_2394)new class_2388(class_2398.field_11217, class_2246.field_10058.method_9564()), (class_243)util.vector.centerOf(0, 0, 0)), 25.0f, 1);
        ElementLink itemEntity = scene.world.createItemEntity(util.vector.blockSurface(util.grid.at(4, 2, 2), class_2350.field_11033, 0.0f), util.vector.of(0.0, 0.0, 0.0), new class_1799((class_1935)class_1802.field_19050));
        ElementLink itemEntity2 = scene.world.createItemEntity(util.vector.blockSurface(util.grid.at(4, 2, 2), class_2350.field_11033, 0.0f), util.vector.of(0.0, 0.0, 0.0), new class_1799((class_1935)AllItems.EXP_NUGGET.get()));
        scene.idle(13);
        scene.world.modifyEntity(itemEntity, class_1297::method_31472);
        scene.world.createItemOnBelt(util.grid.at(4, 1, 2), class_2350.field_11033, new class_1799((class_1935)class_1802.field_19050));
        scene.idle(3);
        scene.world.modifyEntity(itemEntity2, class_1297::method_31472);
        scene.world.createItemOnBelt(util.grid.at(4, 1, 2), class_2350.field_11033, new class_1799((class_1935)AllItems.EXP_NUGGET.get()));
        scene.idle(10);
        scene.overlay.showText(60).text("The Crushing Wheel has a chance of dropping a very small amount of experience nugget when it kills a creature.").placeNearTarget().pointAt(util.vector.centerOf(4, 3, 2));
        scene.idle(60);
    }

    public static void handleExperienceBottle(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("experience_bottle", "Dealing with Bottle o' Enchanting");
        scene.configureBasePlate(0, 0, 6);
        scene.scaleSceneView(0.68f);
        scene.world.setKineticSpeed(util.select.everywhere(), 16.0f);
        scene.showBasePlate();
        scene.idle(5);
        scene.world.showSection(util.select.fromTo(0, 1, 0, 5, 4, 5), class_2350.field_11033);
        scene.world.propagatePipeChange(util.grid.at(3, 1, 1));
        scene.world.propagatePipeChange(util.grid.at(2, 3, 3));
        class_1799 item = class_1802.field_8287.method_7854();
        item.method_7939(64);
        class_2338 beltStart = util.grid.at(4, 1, 0);
        ElementLink itemEntity = scene.world.createItemEntity(util.vector.centerOf(4, 5, 0), util.vector.of(0.0, 0.0, 0.0), item);
        scene.idle(13);
        scene.world.modifyEntity(itemEntity, class_1297::method_31472);
        scene.world.createItemOnBelt(beltStart, class_2350.field_11033, item);
        scene.idle(10);
        scene.overlay.showText(80).text("Bottle o' Enchanting can be emptied at Item Drain.").attachKeyFrame().placeNearTarget().pointAt(util.vector.topOf(2, 1, 0));
        scene.idle(80);
        scene.overlay.showText(80).text("Bottle o' Enchanting also can be manufactured by Spout as well.").attachKeyFrame().placeNearTarget().pointAt(util.vector.topOf(0, 3, 3));
        class_1799 item2 = class_1802.field_8469.method_7854();
        class_2338 beltStart2 = util.grid.at(0, 1, 1);
        ElementLink itemEntity2 = scene.world.createItemEntity(util.vector.centerOf(0, 5, 1), util.vector.of(0.0, 0.0, 0.0), item2);
        scene.idle(13);
        scene.world.modifyEntity(itemEntity2, class_1297::method_31472);
        ElementLink beltItem = scene.world.createItemOnBelt(beltStart2, class_2350.field_11033, item2);
        Selection spoutS = util.select.position(0, 3, 3);
        class_2338 spoutPos = util.grid.at(0, 3, 3);
        scene.idle(60);
        scene.world.stallBeltItem(beltItem, true);
        scene.world.modifyBlockEntityNBT(spoutS, SpoutBlockEntity.class, nbt -> nbt.method_10569("ProcessingTicks", 20));
        scene.idle(10);
        scene.world.removeItemsFromBelt(spoutPos.method_10087(2));
        scene.world.createItemOnBelt(spoutPos.method_10087(2), class_2350.field_11036, class_1802.field_8287.method_7854());
        scene.idle(70);
    }

    public static void copy(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("copy", "Using Printer");
        scene.configureBasePlate(0, 0, 7);
        scene.scaleSceneView(0.68f);
        scene.world.setKineticSpeed(util.select.everywhere(), 32.0f);
        scene.showBasePlate();
        scene.idle(5);
        scene.world.showSection(util.select.fromTo(0, 1, 0, 6, 3, 6), class_2350.field_11033);
        scene.overlay.showControls(new InputWindowElement(util.vector.centerOf(2, 3, 2), Pointing.DOWN).rightClick().withItem(class_1802.field_8598.method_7854()), 40);
        scene.world.modifyBlockEntity(util.grid.at(2, 1, 5), CreativeFluidTankBlockEntity.class, be -> ((CreativeFluidTankBlockEntity.CreativeSmartFluidTank)be.getTankInventory()).setContainedFluid(new FluidStack(((ExperienceFluid)((Object)((Object)CeiFluids.EXPERIENCE.get()))).method_15751(), 1000L)));
        scene.world.modifyBlockEntity(util.grid.at(2, 3, 2), PrinterBlockEntity.class, be -> TransferUtil.insertFluid(be.getFluidStorage(null), (FluidStack)new FluidStack(((ExperienceFluid)((Object)((Object)CeiFluids.EXPERIENCE.get()))).method_15751(), 3000L)));
        scene.overlay.showText(40).text("Liquid Experience is required to duplicate enchanted books.").attachKeyFrame().placeNearTarget().pointAt(util.vector.centerOf(2, 3, 2));
        scene.idle(40);
        scene.world.modifyBlockEntity(util.grid.at(2, 1, 5), CreativeFluidTankBlockEntity.class, be -> ((CreativeFluidTankBlockEntity.CreativeSmartFluidTank)be.getTankInventory()).setContainedFluid(new FluidStack(((HyperExperienceFluid)((Object)((Object)CeiFluids.HYPER_EXPERIENCE.get()))).method_15751(), 1000L)));
        scene.world.modifyBlockEntity(util.grid.at(2, 3, 2), PrinterBlockEntity.class, be -> {
            TransferUtil.clearStorage(be.getFluidStorage(null));
            TransferUtil.insertFluid(be.getFluidStorage(null), (FluidStack)new FluidStack(((ExperienceFluid)((Object)((Object)CeiFluids.EXPERIENCE.get()))).method_15751(), 3000L));
        });
        scene.overlay.showText(40).text("If the enchantment on the enchantment book you are copying has a level that exceeds its maximum level, then you will need Hyper Experience.").attachKeyFrame().placeNearTarget().pointAt(util.vector.centerOf(2, 3, 2));
        scene.idle(40);
        class_1799 item = class_1802.field_8529.method_7854();
        class_2338 beltStart = util.grid.at(6, 1, 2);
        ElementLink beltItem = scene.world.createItemOnBelt(beltStart, class_2350.field_11033, item);
        Selection copier = util.select.position(2, 3, 2);
        class_2338 copierPos = util.grid.at(2, 3, 2);
        scene.idle(60);
        scene.world.stallBeltItem(beltItem, true);
        scene.world.modifyBlockEntityNBT(copier, PrinterBlockEntity.class, nbt -> nbt.method_10569("ProcessingTicks", 100));
        scene.idle(95);
        scene.world.removeItemsFromBelt(copierPos.method_10087(2));
        scene.world.createItemOnBelt(copierPos.method_10087(2), class_2350.field_11036, class_1802.field_8598.method_7854());
        scene.idle(40);
        scene.overlay.showControls(new InputWindowElement(util.vector.centerOf(2, 3, 2), Pointing.DOWN).rightClick().withItem(class_1802.field_8360.method_7854()), 40);
        scene.world.modifyBlockEntity(util.grid.at(2, 1, 5), CreativeFluidTankBlockEntity.class, be -> ((CreativeFluidTankBlockEntity.CreativeSmartFluidTank)be.getTankInventory()).setContainedFluid(new FluidStack(((SimpleFlowableFluid.Flowing)CeiFluids.INK.get()).method_15751(), 1000L)));
        scene.world.modifyBlockEntity(util.grid.at(2, 3, 2), PrinterBlockEntity.class, be -> {
            TransferUtil.clearStorage(be.getFluidStorage(null));
            TransferUtil.insertFluid(be.getFluidStorage(null), (FluidStack)new FluidStack(((SimpleFlowableFluid.Flowing)CeiFluids.INK.get()).method_15751(), 3000L));
        });
        scene.overlay.showText(40).text("Ink is required to duplicate written books.").attachKeyFrame().placeNearTarget().pointAt(util.vector.centerOf(2, 3, 2));
        scene.idle(40);
        item = class_1802.field_8529.method_7854();
        beltStart = util.grid.at(6, 1, 2);
        beltItem = scene.world.createItemOnBelt(beltStart, class_2350.field_11033, item);
        copier = util.select.position(2, 3, 2);
        copierPos = util.grid.at(2, 3, 2);
        scene.idle(60);
        scene.world.stallBeltItem(beltItem, true);
        scene.world.modifyBlockEntityNBT(copier, PrinterBlockEntity.class, nbt -> nbt.method_10569("ProcessingTicks", 100));
        scene.idle(95);
        scene.world.removeItemsFromBelt(copierPos.method_10087(2));
        scene.world.createItemOnBelt(copierPos.method_10087(2), class_2350.field_11036, class_1802.field_8360.method_7854());
        scene.idle(50);
        scene.world.modifyBlockEntity(util.grid.at(2, 1, 5), CreativeFluidTankBlockEntity.class, be -> ((CreativeFluidTankBlockEntity.CreativeSmartFluidTank)be.getTankInventory()).setContainedFluid(new FluidStack(((ExperienceFluid)((Object)((Object)CeiFluids.EXPERIENCE.get()))).method_15751(), 1000L)));
        scene.world.modifyBlockEntity(util.grid.at(2, 3, 2), PrinterBlockEntity.class, be -> {
            TransferUtil.clearStorage(be.getFluidStorage(null));
            TransferUtil.insertFluid(be.getFluidStorage(null), (FluidStack)new FluidStack(((ExperienceFluid)((Object)((Object)CeiFluids.EXPERIENCE.get()))).method_15751(), 3000L));
        });
        scene.overlay.showControls(new InputWindowElement(util.vector.centerOf(2, 3, 2), Pointing.DOWN).rightClick().withItem(class_1802.field_8448.method_7854()), 40);
        scene.overlay.showText(40).text("Name Tag and Train Schedule can also be copied.").attachKeyFrame().placeNearTarget().pointAt(util.vector.centerOf(2, 3, 2));
        scene.idle(40);
        item = class_1802.field_8802.method_7854();
        beltStart = util.grid.at(6, 1, 2);
        beltItem = scene.world.createItemOnBelt(beltStart, class_2350.field_11033, item);
        copier = util.select.position(2, 3, 2);
        copierPos = util.grid.at(2, 3, 2);
        scene.idle(60);
        scene.world.stallBeltItem(beltItem, true);
        scene.world.modifyBlockEntityNBT(copier, PrinterBlockEntity.class, nbt -> nbt.method_10569("ProcessingTicks", 100));
        scene.idle(95);
        scene.world.removeItemsFromBelt(copierPos.method_10087(2));
        scene.world.createItemOnBelt(copierPos.method_10087(2), class_2350.field_11036, class_1802.field_8802.method_7854());
        scene.overlay.showText(40).text("If you set the name tag as the print target, you can use the printer to name the item.").attachKeyFrame().placeNearTarget().pointAt(util.vector.centerOf(2, 3, 2));
        scene.idle(40);
    }

    public static void leak(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("leak", "Oh no! It's leaking!");
        scene.configureBasePlate(0, 0, 5);
        scene.scaleSceneView(0.5f);
        scene.world.setKineticSpeed(util.select.everywhere(), 0.0f);
        scene.showBasePlate();
        scene.idle(5);
        scene.world.showSection(util.select.fromTo(3, 1, 3, 4, 4, 4), class_2350.field_11033);
        scene.idle(5);
        scene.world.modifyBlockEntity(util.grid.at(3, 1, 3), FluidTankBlockEntity.class, be -> TransferUtil.insertFluid((Storage)be.getFluidStorage(null), (FluidStack)new FluidStack(((ExperienceFluid)((Object)((Object)CeiFluids.EXPERIENCE.get()))).method_15751(), 48000L)));
        scene.overlay.showText(40).text("I have a tank full of experience").placeNearTarget().pointAt(util.vector.topOf(2, 4, 2));
        scene.idle(50);
        scene.world.showSection(util.select.fromTo(0, 1, 0, 4, 4, 2), class_2350.field_11033);
        scene.world.showSection(util.select.fromTo(0, 1, 3, 2, 4, 4), class_2350.field_11033);
        scene.idle(5);
        scene.overlay.showText(40).text("I have an open-ended pipe").placeNearTarget().pointAt(util.vector.topOf(3, 4, 0));
        scene.idle(50);
        scene.world.setKineticSpeed(util.select.everywhere(), 128.0f);
        scene.world.propagatePipeChange(util.grid.at(0, 1, 3));
        scene.world.propagatePipeChange(util.grid.at(3, 1, 0));
        scene.world.propagatePipeChange(util.grid.at(3, 4, 0));
        scene.idle(80);
        scene.overlay.showText(40).text("Ugh!").colored(PonderPalette.RED).placeNearTarget().pointAt(util.vector.topOf(3, 4, 0));
        scene.overlay.showOutline(PonderPalette.RED, new Object(), util.select.position(3, 4, 0), 40);
        scene.idle(50);
        scene.overlay.showText(40).text("Don't worry, the leaked liquid experience will turn into experience orbs. Players can also stand at the opening of the pipe to absorb experience.").colored(PonderPalette.GREEN).attachKeyFrame().placeNearTarget().pointAt(util.vector.topOf(3, 4, 0));
        scene.overlay.showOutline(PonderPalette.GREEN, new Object(), util.select.position(3, 4, 0), 40);
        scene.idle(50);
    }

    private static void enchantItem(class_1799 itemStack, class_1887 enchantment, int level) {
        Map m = class_1890.method_8222((class_1799)itemStack);
        m.put(enchantment, level);
        class_1890.method_8214((Map)m, (class_1799)itemStack);
    }

    private static void enchantRandomly(class_1799 itemStack) {
        if (itemStack.method_31574(class_1802.field_8598)) {
            EnchantmentScenes.enchantItem(itemStack, class_1893.field_9101, 1);
        } else {
            class_1890.method_8233((class_5819)class_5819.method_43047(), (class_1799)itemStack, (int)30, (boolean)true);
        }
    }

    private static class_1799 enchantingGuide(class_1887 enchantment, int level) {
        class_1799 ret = CeiItems.ENCHANTING_GUIDE.asStack();
        ret.method_7948().method_10569("index", 0);
        class_1799 book = class_1802.field_8598.method_7854();
        class_1890.method_8214(Map.of(enchantment, level), (class_1799)book);
        ret.method_7948().method_10566("target", NBTSerializer.serializeNBT((Object)book));
        return ret;
    }
}

