/*
 * Decompiled with CFR 0.152.
 */
package wraith.fabricaeexnihilo.compatibility.emi.recipes;

import dev.emi.emi.api.FabricEmiStack;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_1799;
import net.minecraft.class_1826;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;
import wraith.fabricaeexnihilo.FabricaeExNihilo;
import wraith.fabricaeexnihilo.compatibility.emi.EmiIngredientUtil;
import wraith.fabricaeexnihilo.compatibility.emi.FENEmiPlugin;
import wraith.fabricaeexnihilo.compatibility.emi.FENEmiTextures;
import wraith.fabricaeexnihilo.config.FabricaeExNihiloConfig;
import wraith.fabricaeexnihilo.modules.ModTags;
import wraith.fabricaeexnihilo.recipe.barrel.BarrelRecipe;
import wraith.fabricaeexnihilo.recipe.barrel.BarrelRecipeAction;
import wraith.fabricaeexnihilo.recipe.barrel.BarrelRecipeCondition;
import wraith.fabricaeexnihilo.recipe.barrel.BarrelRecipeTrigger;

public class EmiBarrelRecipe
implements EmiRecipe {
    private static final int WIDTH = 144;
    private static final int HEIGHT = 54;
    private final class_2960 id;
    private final int duration;
    @Nullable
    private final EmiIngredient triggerItem;
    @Nullable
    private EmiIngredient above;
    @Nullable
    private EmiIngredient below;
    @Nullable
    private EmiIngredient inputFluid;
    @Nullable
    private EmiIngredient nearby;
    @Nullable
    private EmiStack conversionOutput;
    @Nullable
    private EmiStack compostResult;
    private float compostAmount;
    private final List<EmiStack> outputs = new ArrayList<EmiStack>();

    public EmiBarrelRecipe(BarrelRecipe recipe) {
        this.id = recipe.method_8114();
        this.duration = recipe.getDuration() * ((FabricaeExNihiloConfig)FabricaeExNihilo.CONFIG.get()).barrels().tickRate() / 20;
        this.triggerItem = this.getTriggerItem(recipe);
        recipe.getConditions().forEach(this::processCondition);
        recipe.getActions().forEach(this::processAction);
    }

    private void processCondition(BarrelRecipeCondition condition) {
        if (condition instanceof BarrelRecipeCondition.BlockAbove) {
            BarrelRecipeCondition.BlockAbove blockAbove = (BarrelRecipeCondition.BlockAbove)condition;
            this.above = EmiIngredientUtil.ingredientOf(blockAbove.block());
        } else if (condition instanceof BarrelRecipeCondition.FluidAbove) {
            BarrelRecipeCondition.FluidAbove fluidAbove = (BarrelRecipeCondition.FluidAbove)condition;
            this.above = EmiIngredientUtil.ingredientOf(fluidAbove.fluid());
        } else if (condition instanceof BarrelRecipeCondition.BlockBelow) {
            BarrelRecipeCondition.BlockBelow blockBelow = (BarrelRecipeCondition.BlockBelow)condition;
            this.below = EmiIngredientUtil.ingredientOf(blockBelow.block());
        } else if (condition instanceof BarrelRecipeCondition.FluidIn) {
            BarrelRecipeCondition.FluidIn fluidIn = (BarrelRecipeCondition.FluidIn)condition;
            this.inputFluid = EmiIngredientUtil.ingredientOf(fluidIn.fluid());
        } else {
            FabricaeExNihilo.LOGGER.warn("Unsupported barrel recipe condition in REI code: " + condition);
        }
    }

    private void processAction(BarrelRecipeAction action) {
        if (action instanceof BarrelRecipeAction.SpawnEntity) {
            BarrelRecipeAction.SpawnEntity spawnEntity = (BarrelRecipeAction.SpawnEntity)action;
            class_1826 egg = class_1826.method_8019(spawnEntity.entities().getType());
            if (egg == null) {
                return;
            }
            class_1799 stack = new class_1799((class_1935)egg, spawnEntity.entities().getSize());
            this.outputs.add(EmiStack.of((class_1799)stack));
        } else if (action instanceof BarrelRecipeAction.StoreItem) {
            BarrelRecipeAction.StoreItem storeItem = (BarrelRecipeAction.StoreItem)action;
            this.outputs.add(EmiStack.of((class_1799)storeItem.stack()));
        } else if (action instanceof BarrelRecipeAction.StoreFluid) {
            BarrelRecipeAction.StoreFluid storeFluid = (BarrelRecipeAction.StoreFluid)action;
            if (storeFluid.fluid().isBlank()) {
                return;
            }
            this.outputs.add(FabricEmiStack.of((FluidVariant)storeFluid.fluid(), (long)storeFluid.amount()));
        } else if (action instanceof BarrelRecipeAction.ConsumeFluid) {
            BarrelRecipeAction.ConsumeFluid consumeFluid = (BarrelRecipeAction.ConsumeFluid)action;
            if (consumeFluid.fluid().isEmpty()) {
                return;
            }
            this.inputFluid = EmiIngredientUtil.ingredientOf(consumeFluid.fluid()).setAmount(consumeFluid.amount());
        } else if (action instanceof BarrelRecipeAction.ConvertBlock) {
            BarrelRecipeAction.ConvertBlock convertBlock = (BarrelRecipeAction.ConvertBlock)action;
            this.nearby = EmiIngredientUtil.ingredientOf(convertBlock.filter());
            this.conversionOutput = EmiStack.of((class_1935)convertBlock.result().method_26204());
        } else if (action instanceof BarrelRecipeAction.DropItem) {
            BarrelRecipeAction.DropItem dropItem = (BarrelRecipeAction.DropItem)action;
            this.outputs.add(EmiStack.of((class_1799)dropItem.stack()));
        } else if (action instanceof BarrelRecipeAction.FillCompost) {
            BarrelRecipeAction.FillCompost fillCompost = (BarrelRecipeAction.FillCompost)action;
            this.compostResult = EmiStack.of((class_1799)fillCompost.result()).setChance(this.compostAmount);
            this.compostAmount = fillCompost.increment();
        } else {
            FabricaeExNihilo.LOGGER.warn("Unsupported barrel recipe action in REI code: " + action);
        }
    }

    @Nullable
    private EmiIngredient getTriggerItem(BarrelRecipe recipe) {
        BarrelRecipeTrigger trigger = recipe.getTrigger();
        if (trigger instanceof BarrelRecipeTrigger.ItemInserted) {
            BarrelRecipeTrigger.ItemInserted itemInsertedTrigger = (BarrelRecipeTrigger.ItemInserted)trigger;
            return EmiIngredient.of((class_1856)itemInsertedTrigger.predicate());
        }
        return null;
    }

    public EmiRecipeCategory getCategory() {
        return FENEmiPlugin.BARREL_CATEGORY;
    }

    @Nullable
    public class_2960 getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        ArrayList<EmiIngredient> inputs = new ArrayList<EmiIngredient>();
        if (this.triggerItem != null) {
            inputs.add(this.triggerItem);
        }
        if (this.above != null) {
            inputs.add(this.above);
        }
        if (this.below != null) {
            inputs.add(this.below);
        }
        if (this.nearby != null) {
            inputs.add(this.nearby);
        }
        if (this.inputFluid != null) {
            inputs.add(this.inputFluid);
        }
        return inputs;
    }

    public List<EmiStack> getOutputs() {
        ArrayList<EmiStack> outputs = new ArrayList<EmiStack>(this.outputs);
        if (this.conversionOutput != null) {
            outputs.add(this.conversionOutput);
        }
        if (this.compostResult != null) {
            outputs.add(this.compostResult);
        }
        return outputs;
    }

    public int getDisplayWidth() {
        return 144;
    }

    public int getDisplayHeight() {
        return 54;
    }

    public void addWidgets(WidgetHolder widgets) {
        int rowCount = (this.outputs.size() - 1) / 2;
        for (int i = 0; i < this.outputs.size(); ++i) {
            int col = i % 2;
            int row = i / 2;
            widgets.addSlot((EmiIngredient)this.outputs.get(i), (col + 6) * 18, (int)(((double)(row + 1) - (double)rowCount / 2.0) * 18.0)).recipeContext((EmiRecipe)this);
        }
        if (this.outputs.size() > 0) {
            widgets.addTexture(EmiTexture.EMPTY_ARROW, 66, 17);
        }
        if (this.above != null) {
            widgets.addSlot(this.above, 36, 0);
        }
        if (this.below != null) {
            widgets.addSlot(this.below, 36, 36);
        }
        if (this.triggerItem != null) {
            widgets.addSlot(this.triggerItem, 0, this.inputFluid == null ? 18 : 9);
        }
        if (this.inputFluid != null) {
            widgets.addSlot(this.inputFluid, 0, this.triggerItem == null ? 18 : 27);
        }
        widgets.addTexture(FENEmiTextures.ARROW_RIGHT, 19, 18);
        widgets.addSlot(EmiIngredient.of(ModTags.BARRELS), 36, 18).drawBack(false);
        if (this.nearby != null && this.conversionOutput != null) {
            widgets.addText((class_2561)class_2561.method_43471((String)"emi.category.fabricaeexnihilo.barrel.nearby"), 58, 24, -1, true);
            widgets.addSlot(this.nearby, 58, 36);
            widgets.addTexture(FENEmiTextures.ARROW_RIGHT, 71, 36);
            widgets.addSlot((EmiIngredient)this.conversionOutput, 85, 36).recipeContext((EmiRecipe)this);
        }
        if (this.compostResult != null) {
            widgets.addSlot((EmiIngredient)this.compostResult, 58, 0).recipeContext((EmiRecipe)this);
            widgets.addText((class_2561)class_2561.method_43469((String)"emi.category.fabricaeexnihilo.barrel.compost", (Object[])new Object[]{Float.valueOf(this.compostAmount * 100.0f)}), 76, 4, -1, true);
        }
        if (this.duration != 0) {
            widgets.addText((class_2561)class_2561.method_43469((String)"emi.category.fabricaeexnihilo.barrel.duration", (Object[])new Object[]{this.duration}), 0, 0, -1, true);
        }
    }
}

