/*
 * Decompiled with CFR 0.152.
 */
package wraith.fabricaeexnihilo.modules.barrels;

import java.util.Optional;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2237;
import net.minecraft.class_2338;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import org.jetbrains.annotations.Nullable;
import wraith.fabricaeexnihilo.FabricaeExNihilo;
import wraith.fabricaeexnihilo.config.FabricaeExNihiloConfig;
import wraith.fabricaeexnihilo.modules.ModEffects;
import wraith.fabricaeexnihilo.modules.barrels.BarrelBlockEntity;
import wraith.fabricaeexnihilo.modules.barrels.BarrelState;
import wraith.fabricaeexnihilo.modules.fluids.BloodFluid;
import wraith.fabricaeexnihilo.recipe.barrel.MilkingRecipe;

public class BarrelBlock
extends class_2237 {
    private static final class_265 SHAPE = BarrelBlock.method_9541((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    private final boolean isFireproof;

    public BarrelBlock(class_4970.class_2251 settings, boolean isFireproof) {
        super(settings);
        this.isFireproof = isFireproof;
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new BarrelBlockEntity(pos, state);
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return SHAPE;
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    public void method_9504(class_2680 state, class_1937 world, class_2338 pos, class_1959.class_1963 precipitation) {
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof BarrelBlockEntity) {
            BarrelBlockEntity barrel = (BarrelBlockEntity)blockEntity;
            if (precipitation == class_1959.class_1963.field_9382) {
                try (Transaction transaction = Transaction.openOuter();){
                    long inserted = barrel.fluidStorage.insert(FluidVariant.of((class_3611)class_3612.field_15910), 810L, (TransactionContext)transaction);
                    if (inserted != 0L) {
                        transaction.commit();
                    }
                }
            }
        }
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return world.field_9236 ? null : BarrelBlock.method_31618(type, BarrelBlockEntity.TYPE, (world1, blockPos, blockState, barrelEntity) -> barrelEntity.tick());
    }

    public boolean isFireproof() {
        return this.isFireproof;
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 itemStack) {
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof BarrelBlockEntity) {
            BarrelBlockEntity barrelEntity = (BarrelBlockEntity)class_25862;
            class_1890.method_8222((class_1799)itemStack).forEach((enchantment, level) -> barrelEntity.getEnchantmentContainer().setEnchantmentLevel((class_1887)enchantment, (int)level));
        }
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        BarrelBlockEntity barrel;
        class_2586 class_25862;
        if (!state.method_27852(newState.method_26204()) && (class_25862 = world.method_8321(pos)) instanceof BarrelBlockEntity && (barrel = (BarrelBlockEntity)class_25862).getState() == BarrelState.ITEM) {
            class_1264.method_5449((class_1937)world, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), (class_1799)barrel.getItem());
        }
        super.method_9536(state, world, pos, newState, moved);
    }

    public void method_9591(class_1937 world, class_2338 pos, class_2680 state, class_1297 entity) {
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof BarrelBlockEntity) {
            BarrelBlockEntity barrel = (BarrelBlockEntity)blockEntity;
            if (entity instanceof class_1309) {
                Optional<MilkingRecipe> recipe;
                int thorns;
                class_1309 livingEntity = (class_1309)entity;
                if (((FabricaeExNihiloConfig)FabricaeExNihilo.CONFIG.get()).barrels().bleeding() && (thorns = barrel.getEnchantmentContainer().getEnchantmentLevel(class_1893.field_9097)) > 0 && barrel.fluidStorage.simulateInsert(FluidVariant.of((class_3611)BloodFluid.STILL), 1L, null) >= 1L && livingEntity.method_5643(world.method_48963().method_48826(), (float)thorns / 2.0f)) {
                    float amount = (float)(81000L * (long)thorns) / livingEntity.method_6063();
                    try (Transaction t = Transaction.openOuter();){
                        barrel.fluidStorage.insert(FluidVariant.of((class_3611)BloodFluid.STILL), (long)amount, (TransactionContext)t);
                        t.commit();
                    }
                }
                if (!(livingEntity instanceof class_1657) && !livingEntity.method_6059(ModEffects.MILKED) && ((FabricaeExNihiloConfig)FabricaeExNihilo.CONFIG.get()).barrels().milking() && (recipe = MilkingRecipe.find(livingEntity.method_5864(), world)).isPresent()) {
                    long inserted;
                    try (Transaction t = Transaction.openOuter();){
                        inserted = barrel.fluidStorage.insert(recipe.get().getFluid(), recipe.get().getAmount(), (TransactionContext)t);
                        t.commit();
                    }
                    if (inserted > 0L) {
                        livingEntity.method_6092(new class_1293(ModEffects.MILKED, recipe.get().getCooldown(), 1, false, false, false));
                    }
                }
            }
        }
        super.method_9591(world, pos, state, entity);
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hitResult) {
        class_1269 class_12692;
        if (world == null || pos == null) {
            return class_1269.field_5811;
        }
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof BarrelBlockEntity) {
            BarrelBlockEntity barrelBlock = (BarrelBlockEntity)blockEntity;
            class_12692 = barrelBlock.activate(player, hand);
        } else {
            class_12692 = class_1269.field_5811;
        }
        return class_12692;
    }
}

