/*
 * Decompiled with CFR 0.152.
 */
package wraith.fabricaeexnihilo.modules.barrels;

import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import wraith.fabricaeexnihilo.modules.ModTags;
import wraith.fabricaeexnihilo.modules.barrels.BarrelBlockEntity;
import wraith.fabricaeexnihilo.modules.barrels.BarrelState;

public class BarrelFluidStorage
extends SnapshotParticipant<BarrelBlockEntity.Snapshot>
implements SingleSlotStorage<FluidVariant> {
    private final BarrelBlockEntity barrel;

    public BarrelFluidStorage(BarrelBlockEntity barrel) {
        this.barrel = barrel;
    }

    public long insert(FluidVariant fluid, long maxAmount, TransactionContext transaction) {
        StoragePreconditions.notBlankNotNegative((TransferVariant)fluid, (long)maxAmount);
        if (this.barrel.isCrafting()) {
            return 0L;
        }
        if (this.barrel.getState() == BarrelState.FLUID && !fluid.equals(this.barrel.getFluid())) {
            return 0L;
        }
        if (this.barrel.getState() != BarrelState.FLUID && this.barrel.getState() != BarrelState.EMPTY) {
            return 0L;
        }
        if (fluid.getFluid().method_15791(ModTags.HOT) && !this.barrel.isFireproof()) {
            return 0L;
        }
        long inserted = Math.min(this.getCapacity() - this.getAmount(), maxAmount);
        if (inserted == 0L) {
            return 0L;
        }
        this.updateSnapshots(transaction);
        this.barrel.setFluid(fluid, this.getAmount() + inserted);
        return inserted;
    }

    public long extract(FluidVariant fluid, long maxAmount, TransactionContext transaction) {
        StoragePreconditions.notBlankNotNegative((TransferVariant)fluid, (long)maxAmount);
        if (this.barrel.isCrafting()) {
            return 0L;
        }
        if (this.barrel.getState() != BarrelState.FLUID) {
            return 0L;
        }
        if (!fluid.equals(this.barrel.getFluid())) {
            return 0L;
        }
        long extracted = Math.min(this.getAmount(), maxAmount);
        if (extracted == 0L) {
            return 0L;
        }
        this.updateSnapshots(transaction);
        this.barrel.setFluid(this.barrel.getFluid(), this.getAmount() - extracted);
        return extracted;
    }

    public boolean isResourceBlank() {
        return this.getResource().isBlank();
    }

    public FluidVariant getResource() {
        return this.barrel.getFluid();
    }

    public long getAmount() {
        return this.barrel.getFluidAmount();
    }

    public long getCapacity() {
        return 81000L;
    }

    protected BarrelBlockEntity.Snapshot createSnapshot() {
        return this.barrel.new BarrelBlockEntity.Snapshot();
    }

    protected void readSnapshot(BarrelBlockEntity.Snapshot snapshot) {
        snapshot.apply();
    }
}

