/*
 * Decompiled with CFR 0.152.
 */
package wraith.fabricaeexnihilo.modules.barrels;

import java.util.Optional;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.minecraft.class_1799;
import wraith.fabricaeexnihilo.modules.barrels.BarrelBlockEntity;
import wraith.fabricaeexnihilo.modules.barrels.BarrelState;
import wraith.fabricaeexnihilo.recipe.barrel.BarrelRecipe;

public class BarrelItemStorage
extends SnapshotParticipant<BarrelBlockEntity.Snapshot>
implements SingleSlotStorage<ItemVariant> {
    private final BarrelBlockEntity barrel;

    public BarrelItemStorage(BarrelBlockEntity barrel) {
        this.barrel = barrel;
    }

    public long insert(ItemVariant item, long maxAmount, TransactionContext transaction) {
        StoragePreconditions.notBlankNotNegative((TransferVariant)item, (long)maxAmount);
        if (this.barrel.isCrafting()) {
            return 0L;
        }
        if (this.barrel.getState() != BarrelState.EMPTY && this.barrel.getState() != BarrelState.FLUID && this.barrel.getState() != BarrelState.COMPOST) {
            return 0L;
        }
        Optional<BarrelRecipe> recipe = BarrelRecipe.findInsert(this.barrel, item);
        if (recipe.isPresent()) {
            this.updateSnapshots(transaction);
            this.barrel.beginRecipe(recipe.get());
            return 1L;
        }
        return 0L;
    }

    public long extract(ItemVariant item, long maxAmount, TransactionContext transaction) {
        StoragePreconditions.notBlankNotNegative((TransferVariant)item, (long)maxAmount);
        if (this.barrel.isCrafting()) {
            return 0L;
        }
        if (this.barrel.getState() != BarrelState.ITEM) {
            return 0L;
        }
        if (!item.equals(this.getResource())) {
            return 0L;
        }
        long extracted = Math.min(this.getAmount(), maxAmount);
        if (extracted == 0L) {
            return 0L;
        }
        this.updateSnapshots(transaction);
        class_1799 stack = this.barrel.getItem();
        stack.method_7934((int)extracted);
        this.barrel.setItem(stack);
        return extracted;
    }

    public boolean isResourceBlank() {
        return this.getResource().isBlank();
    }

    public ItemVariant getResource() {
        return ItemVariant.of((class_1799)this.barrel.getItem());
    }

    public long getAmount() {
        return this.barrel.getItem().method_7947();
    }

    public long getCapacity() {
        return this.barrel.getItem().method_7914();
    }

    protected BarrelBlockEntity.Snapshot createSnapshot() {
        return this.barrel.new BarrelBlockEntity.Snapshot();
    }

    protected void readSnapshot(BarrelBlockEntity.Snapshot snapshot) {
        snapshot.apply();
    }
}

