/*
 * Decompiled with CFR 0.152.
 */
package wraith.fabricaeexnihilo.modules.infested;

import java.util.Optional;
import net.fabricmc.fabric.api.object.builder.v1.block.entity.FabricBlockEntityTypeBuilder;
import net.minecraft.class_1920;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2397;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_7923;
import wraith.fabricaeexnihilo.FabricaeExNihilo;
import wraith.fabricaeexnihilo.config.FabricaeExNihiloConfig;
import wraith.fabricaeexnihilo.modules.ModBlocks;
import wraith.fabricaeexnihilo.modules.base.BaseBlockEntity;
import wraith.fabricaeexnihilo.modules.base.Colored;
import wraith.fabricaeexnihilo.modules.infested.InfestedHelper;
import wraith.fabricaeexnihilo.modules.infested.InfestedLeavesBlock;
import wraith.fabricaeexnihilo.util.Color;

public class InfestingLeavesBlockEntity
extends BaseBlockEntity
implements Colored {
    public static final class_2960 BLOCK_ENTITY_ID = FabricaeExNihilo.id("infesting");
    private double progress = 0.0;
    private InfestedLeavesBlock target = ModBlocks.INFESTED_LEAVES.values().stream().findFirst().orElseThrow();
    private int tickCounter;
    public static final class_2591<InfestingLeavesBlockEntity> TYPE = FabricBlockEntityTypeBuilder.create(InfestingLeavesBlockEntity::new, (class_2248[])new class_2248[]{ModBlocks.INFESTING_LEAVES}).build(null);

    public InfestingLeavesBlockEntity(class_2338 pos, class_2680 state) {
        super(TYPE, pos, state);
        this.tickCounter = this.field_11863 == null ? 0 : this.field_11863.field_9229.method_43048(((FabricaeExNihiloConfig)FabricaeExNihilo.CONFIG.get()).barrels().tickRate());
    }

    public static void ticker(class_1937 world, class_2338 blockPos, class_2680 blockState, InfestingLeavesBlockEntity infestedLeavesEntity) {
        if (++infestedLeavesEntity.tickCounter % ((FabricaeExNihiloConfig)FabricaeExNihilo.CONFIG.get()).infested().updateFrequency() != 0) {
            return;
        }
        infestedLeavesEntity.progress += ((FabricaeExNihiloConfig)FabricaeExNihilo.CONFIG.get()).infested().progressPerUpdate();
        if (infestedLeavesEntity.progress < 1.0) {
            infestedLeavesEntity.method_5431();
            if (infestedLeavesEntity.progress > ((FabricaeExNihiloConfig)FabricaeExNihilo.CONFIG.get()).infested().minimumSpreadProgress() && world != null) {
                InfestedHelper.tryToSpreadFrom(world, blockPos, ((FabricaeExNihiloConfig)FabricaeExNihilo.CONFIG.get()).infested().infestingSpreadAttempts());
            }
            return;
        }
        if (world == null) {
            return;
        }
        class_2680 curState = world.method_8320(blockPos);
        class_2680 newState = (class_2680)((class_2680)infestedLeavesEntity.target.method_9564().method_11657((class_2769)class_2397.field_11199, (Comparable)((Integer)curState.method_11654((class_2769)class_2397.field_11199)))).method_11657((class_2769)class_2397.field_11200, (Comparable)((Boolean)curState.method_11654((class_2769)class_2397.field_11200)));
        world.method_8501(blockPos, newState);
    }

    @Override
    public int getColor(int index) {
        int originalColor = class_310.method_1551().method_1505().method_1697(((class_2248)class_7923.field_41175.method_10223(this.target.getOld())).method_9564(), (class_1920)this.field_11863, this.field_11867, 0);
        return Color.average(Color.WHITE, new Color(originalColor), this.progress).toInt();
    }

    public double getProgress() {
        return this.progress;
    }

    public InfestedLeavesBlock getTarget() {
        return this.target;
    }

    public void setTarget(InfestedLeavesBlock target) {
        this.target = target;
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        if (nbt == null) {
            FabricaeExNihilo.LOGGER.warn("An infesting leaves block at " + this.field_11867 + " is missing data.");
            return;
        }
        this.readNbtWithoutWorldInfo(nbt);
    }

    public void readNbtWithoutWorldInfo(class_2487 nbt) {
        this.progress = nbt.method_10574("progress");
        this.target = class_7923.field_41175.method_17966(new class_2960(nbt.method_10558("target"))).flatMap(block -> {
            Optional<Object> optional;
            if (block instanceof InfestedLeavesBlock) {
                InfestedLeavesBlock infested = (InfestedLeavesBlock)block;
                optional = Optional.of(infested);
            } else {
                optional = Optional.empty();
            }
            return optional;
        }).orElse(ModBlocks.INFESTED_LEAVES.values().stream().findFirst().orElseThrow());
    }

    public void toNBTWithoutWorldInfo(class_2487 nbt) {
        nbt.method_10549("progress", this.progress);
        nbt.method_10582("target", class_7923.field_41175.method_10221((Object)this.target).toString());
    }

    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        this.toNBTWithoutWorldInfo(nbt);
    }
}

