/*
 * Decompiled with CFR 0.152.
 */
package wraith.fabricaeexnihilo.modules.strainer;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Objects;
import java.util.stream.IntStream;
import net.fabricmc.fabric.api.object.builder.v1.block.entity.FabricBlockEntityTypeBuilder;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.item.base.SingleStackStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.CombinedStorage;
import net.minecraft.class_1262;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_8567;
import wraith.fabricaeexnihilo.FabricaeExNihilo;
import wraith.fabricaeexnihilo.config.FabricaeExNihiloConfig;
import wraith.fabricaeexnihilo.config.StrainerConfig;
import wraith.fabricaeexnihilo.modules.ModBlocks;
import wraith.fabricaeexnihilo.modules.ModLootContextTypes;
import wraith.fabricaeexnihilo.modules.base.BaseBlockEntity;
import wraith.fabricaeexnihilo.modules.strainer.StrainerBlock;

public class StrainerBlockEntity
extends BaseBlockEntity {
    public static final class_2591<StrainerBlockEntity> TYPE = FabricBlockEntityTypeBuilder.create(StrainerBlockEntity::new, (class_2248[])((class_2248[])ModBlocks.STRAINERS.values().toArray(StrainerBlock[]::new))).build(null);
    public static final class_2960 BLOCK_ENTITY_ID = FabricaeExNihilo.id("strainer");
    private final class_2371<class_1799> inventory = class_2371.method_10213((int)8, (Object)class_1799.field_8037);
    private final StrainerItemStorage storage = new StrainerItemStorage();
    private int timeUntilCatch = ((FabricaeExNihiloConfig)FabricaeExNihilo.CONFIG.get()).strainers().maxWaitTime();

    public StrainerBlockEntity(class_2338 pos, class_2680 state) {
        super(TYPE, pos, state);
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.inventory.clear();
        class_1262.method_5429((class_2487)nbt, this.inventory);
        this.timeUntilCatch = nbt.method_10550("timeUntilCatch");
    }

    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        class_1262.method_5426((class_2487)nbt, this.inventory);
        nbt.method_10569("timeUntilCatch", this.timeUntilCatch);
    }

    public class_2371<class_1799> getInventory() {
        return this.inventory;
    }

    public static void tick(class_1937 world, class_2338 blockPos, class_2680 state, StrainerBlockEntity strainer) {
        if (world.field_9236 || !((Boolean)state.method_11654((class_2769)StrainerBlock.WATERLOGGED)).booleanValue()) {
            return;
        }
        if (strainer.timeUntilCatch-- == 0) {
            class_8567 params = new class_8567.class_8568((class_3218)world).method_51874(class_181.field_1228, (Object)strainer).method_51874(class_181.field_1224, (Object)state).method_51874(class_181.field_24424, (Object)class_243.method_24954((class_2382)blockPos)).method_51875(ModLootContextTypes.STRAINER);
            ObjectArrayList loot = world.method_8503().method_3857().getLootTable(FabricaeExNihilo.id("gameplay/strainer")).method_51878(params);
            for (int i = 0; i < strainer.inventory.size() && !loot.isEmpty(); ++i) {
                if (!((class_1799)strainer.inventory.get(i)).method_7960()) continue;
                strainer.inventory.set(i, (Object)((class_1799)loot.remove(0)));
            }
            StrainerConfig config = ((FabricaeExNihiloConfig)FabricaeExNihilo.CONFIG.get()).strainers();
            strainer.timeUntilCatch = world.field_9229.method_43051(config.minWaitTime(), config.maxWaitTime());
        }
        strainer.method_5431();
    }

    static {
        ItemStorage.SIDED.registerForBlockEntity((entity, dir) -> entity.storage, TYPE);
    }

    private class StrainerItemStorage
    extends CombinedStorage<ItemVariant, StackStorage> {
        public StrainerItemStorage() {
            super(IntStream.range(0, 7).mapToObj(x$0 -> {
                StrainerBlockEntity strainerBlockEntity = StrainerBlockEntity.this;
                Objects.requireNonNull(strainerBlockEntity);
                return strainerBlockEntity.new StackStorage(x$0);
            }).toList());
        }
    }

    private class StackStorage
    extends SingleStackStorage {
        private final int index;

        private StackStorage(int index) {
            this.index = index;
        }

        protected class_1799 getStack() {
            return (class_1799)StrainerBlockEntity.this.inventory.get(this.index);
        }

        protected void setStack(class_1799 stack) {
            StrainerBlockEntity.this.inventory.set(this.index, (Object)stack);
        }

        protected int getCapacity(ItemVariant itemVariant) {
            return 1;
        }

        protected boolean canInsert(ItemVariant itemVariant) {
            return false;
        }

        public boolean supportsInsertion() {
            return false;
        }

        protected void onFinalCommit() {
            StrainerBlockEntity.this.method_5431();
        }
    }
}

