/*
 * Decompiled with CFR 0.152.
 */
package wraith.fabricaeexnihilo.recipe.barrel;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Optional;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.minecraft.class_1263;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2359;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3518;
import net.minecraft.class_3956;
import net.minecraft.class_7923;
import wraith.fabricaeexnihilo.modules.barrels.BarrelBlockEntity;
import wraith.fabricaeexnihilo.recipe.BaseRecipe;
import wraith.fabricaeexnihilo.recipe.ModRecipes;
import wraith.fabricaeexnihilo.recipe.RecipeContext;
import wraith.fabricaeexnihilo.recipe.barrel.BarrelRecipeAction;
import wraith.fabricaeexnihilo.recipe.barrel.BarrelRecipeCondition;
import wraith.fabricaeexnihilo.recipe.barrel.BarrelRecipeTrigger;

public final class BarrelRecipe
extends BaseRecipe<Context> {
    private final BarrelRecipeTrigger trigger;
    private final List<BarrelRecipeCondition> conditions;
    private final List<BarrelRecipeAction> actions;
    private final int duration;
    private final class_1792 icon;

    private BarrelRecipe(class_2960 id, BarrelRecipeTrigger trigger, int duration, List<BarrelRecipeAction> actions, List<BarrelRecipeCondition> conditions, class_1792 icon) {
        super(id);
        this.trigger = trigger;
        this.duration = duration;
        this.actions = actions;
        this.conditions = conditions;
        this.icon = icon;
    }

    public static Optional<BarrelRecipe> findTick(BarrelBlockEntity barrel) {
        class_1937 world = barrel.method_10997();
        if (world == null) {
            return Optional.empty();
        }
        List recipes = world.method_8433().method_17877(ModRecipes.BARREL, (class_1263)new Context(barrel, Optional.empty()), world);
        return recipes.size() > 0 ? Optional.of((BarrelRecipe)recipes.get(world.field_9229.method_43048(recipes.size()))) : Optional.empty();
    }

    public static Optional<BarrelRecipe> findInsert(BarrelBlockEntity barrel, ItemVariant inserted) {
        class_1937 world = barrel.method_10997();
        if (world == null) {
            return Optional.empty();
        }
        List recipes = world.method_8433().method_17877(ModRecipes.BARREL, (class_1263)new Context(barrel, Optional.of(inserted)), world);
        return recipes.size() > 0 ? Optional.of((BarrelRecipe)recipes.get(world.field_9229.method_43048(recipes.size()))) : Optional.empty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean matches(Context context, class_1937 world) {
        if (context.trigger.isPresent()) {
            BarrelRecipeTrigger barrelRecipeTrigger = this.trigger;
            if (!(barrelRecipeTrigger instanceof BarrelRecipeTrigger.ItemInserted)) return false;
            BarrelRecipeTrigger.ItemInserted itemInserted = (BarrelRecipeTrigger.ItemInserted)barrelRecipeTrigger;
            if (!itemInserted.predicate().method_8093(context.trigger.get().toStack())) {
                return false;
            }
        } else {
            BarrelRecipeTrigger barrelRecipeTrigger = this.trigger;
            if (!(barrelRecipeTrigger instanceof BarrelRecipeTrigger.Tick)) return false;
            BarrelRecipeTrigger.Tick tick = (BarrelRecipeTrigger.Tick)barrelRecipeTrigger;
            if (world.field_9229.method_43057() > tick.chance()) {
                return false;
            }
        }
        if (this.conditions.stream().allMatch(condition -> condition.check(world, context.barrel))) return this.actions.stream().allMatch(action -> action.canRun(this, context.barrel));
        return false;
    }

    public boolean canContinue(class_1937 world, BarrelBlockEntity barrel) {
        if (!this.conditions.stream().allMatch(condition -> condition.check(world, barrel))) {
            return false;
        }
        return this.actions.stream().allMatch(action -> action.canRun(this, barrel));
    }

    public void apply(class_3218 world, BarrelBlockEntity barrel) {
        for (BarrelRecipeAction action : this.actions) {
            action.apply(world, barrel);
        }
    }

    public class_1865<?> method_8119() {
        return ModRecipes.BARREL_SERIALIZER;
    }

    public class_3956<?> method_17716() {
        return ModRecipes.BARREL;
    }

    @Override
    public class_1799 getDisplayStack() {
        return this.icon.method_7854();
    }

    public int getDuration() {
        return this.duration;
    }

    public BarrelRecipeTrigger getTrigger() {
        return this.trigger;
    }

    public List<BarrelRecipeCondition> getConditions() {
        return this.conditions;
    }

    public List<BarrelRecipeAction> getActions() {
        return this.actions;
    }

    public record Context(BarrelBlockEntity barrel, Optional<ItemVariant> trigger) implements RecipeContext
    {
    }

    public static final class Serializer
    implements class_1865<BarrelRecipe> {
        public BarrelRecipe read(class_2960 id, JsonObject json) {
            BarrelRecipeTrigger trigger = BarrelRecipeTrigger.fromJson(class_3518.method_15296((JsonObject)json, (String)"trigger"));
            int duration = class_3518.method_15282((JsonObject)json, (String)"duration", (int)0);
            List<BarrelRecipeAction> actions = class_3518.method_15261((JsonObject)json, (String)"actions").asList().stream().map(element -> class_3518.method_15295((JsonElement)element, (String)"action")).map(BarrelRecipeAction::fromJson).toList();
            List<BarrelRecipeCondition> conditions = class_3518.method_15292((JsonObject)json, (String)"conditions", (JsonArray)new JsonArray()).asList().stream().map(element -> class_3518.method_15295((JsonElement)element, (String)"condition")).map(BarrelRecipeCondition::fromJson).toList();
            class_1792 icon = (class_1792)class_7923.field_41178.method_10223(new class_2960(class_3518.method_15265((JsonObject)json, (String)"icon")));
            return new BarrelRecipe(id, trigger, duration, actions, conditions, icon);
        }

        public BarrelRecipe read(class_2960 id, class_2540 buf) {
            BarrelRecipeTrigger trigger = BarrelRecipeTrigger.fromPacket(buf);
            int duration = buf.method_10816();
            List actions = buf.method_34066(BarrelRecipeAction::fromPacket);
            List conditions = buf.method_34066(BarrelRecipeCondition::fromPacket);
            class_1792 icon = (class_1792)buf.method_42064((class_2359)class_7923.field_41178);
            return new BarrelRecipe(id, trigger, duration, actions, conditions, icon);
        }

        public void write(class_2540 buf, BarrelRecipe recipe) {
            recipe.trigger.toPacket(buf);
            buf.method_10804(recipe.duration);
            buf.method_34062(recipe.actions, (buf1, action) -> action.toPacket((class_2540)buf1));
            buf.method_34062(recipe.conditions, (buf1, condition) -> condition.toPacket((class_2540)buf1));
            buf.method_42065((class_2359)class_7923.field_41178, (Object)recipe.icon);
        }
    }
}

