/*
 * Decompiled with CFR 0.152.
 */
package wraith.fabricaeexnihilo.util;

import com.google.common.base.Strings;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;

public class Color {
    public static final Codec<Color> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("value").forGetter(Color::toInt)).apply((Applicative)instance, Color::new));
    public final float r;
    public final float g;
    public final float b;
    public final float a;
    public static final Color DARK_RED = new Color("AA0000");
    public static final Color RED = new Color("FF5555");
    public static final Color GOLDEN = new Color("FFAA00");
    public static final Color YELLOW = new Color("FFFF55");
    public static final Color DARK_GREEN = new Color("00AA00");
    public static final Color GREEN = new Color("55FF55");
    public static final Color AQUA = new Color("55FFFF");
    public static final Color DARK_AQUA = new Color("00AAAA");
    public static final Color DARK_BLUE = new Color("0000AA");
    public static final Color BLUE = new Color("5555FF");
    public static final Color LIGHT_PURPLE = new Color("FF55FF");
    public static final Color DARK_PURPLE = new Color("AA00AA");
    public static final Color WHITE = new Color("FFFFFF");
    public static final Color GRAY = new Color("AAAAAA");
    public static final Color DARK_GRAY = new Color("555555");
    public static final Color BLACK = new Color("000000");
    public static final Color ORANGE = new Color("FFA500");
    public static final Color IRON = new Color("BF8040");
    public static final Color GOLD = new Color("FFFF00");
    public static final Color ALUMINUM = new Color("BFBFBF");
    public static final Color ARDITE = new Color("FF751A");
    public static final Color BERYLLIUM = new Color("E5ECDD");
    public static final Color BORON = new Color("939393");
    public static final Color COBALT = new Color("3333FF");
    public static final Color COPPER = new Color("FF9933");
    public static final Color IRIDIUM = new Color("B1DEC6");
    public static final Color LEAD = new Color("330066");
    public static final Color LITHIUM = new Color("EDEDED");
    public static final Color MAGNESIUM = new Color("F8DEF8");
    public static final Color NICKEL = new Color("FFFFCC");
    public static final Color PLATINUM = new Color("DAF0ED");
    public static final Color SILVER = new Color("F2F2F2");
    public static final Color TIN = new Color("E6FFF2");
    public static final Color TITANIUM = new Color("BD87CA");
    public static final Color THORIUM = new Color("333333");
    public static final Color TUNGSTEN = new Color("1C1C1C");
    public static final Color URANIUM = new Color("4E5B43");
    public static final Color ZINC = new Color("A59C74");
    public static final Color ZIRCONIUM = new Color("E6E8C7");

    public Color(float r, float g, float b, float a) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
    }

    public Color(int color) {
        this(color, true);
    }

    public Color(int color, boolean ignoreAlpha) {
        this((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f, ignoreAlpha ? 1.0f : (float)(color >> 24 & 0xFF) / 255.0f);
    }

    public Color(String hex) {
        this(Color.hexToInt(hex), hex.length() < 8);
    }

    public int toInt() {
        return this.toIntIgnoreAlpha() | (int)(this.a * 255.0f) << 24;
    }

    public int toIntAlphaOne() {
        return this.toIntIgnoreAlpha() | 0xFF000000;
    }

    public int toIntIgnoreAlpha() {
        return (int)(this.r * 255.0f) << 16 | (int)(this.g * 255.0f) << 8 | (int)(this.b * 255.0f);
    }

    public String toHex() {
        return Strings.padStart((String)Integer.toHexString(this.toInt()), (int)8, (char)'0');
    }

    public String toHexNoAlpha() {
        return Strings.padStart((String)Integer.toHexString(this.toIntIgnoreAlpha()), (int)6, (char)'0');
    }

    public int withAlpha() {
        return new Color(this.r, this.g, this.b, this.a).toInt();
    }

    public int withAlpha(float a) {
        return new Color(this.r, this.g, this.b, a).toInt();
    }

    public int withAlpha(double a) {
        return new Color(this.r, this.g, this.b, (float)a).toInt();
    }

    public static Color fromJson(JsonElement json) {
        JsonPrimitive primitive;
        if (!(json instanceof JsonPrimitive) || !(primitive = (JsonPrimitive)json).isString() && !primitive.isNumber()) {
            throw new JsonParseException("Expected string or number but found " + json + "!");
        }
        if (primitive.isString()) {
            return new Color(primitive.getAsString());
        }
        return new Color(json.getAsInt());
    }

    public static int hexToInt(String hex) {
        if (hex.startsWith("#")) {
            hex = hex.substring(1);
        }
        String rgb = hex.length() < 8 ? hex : hex.substring(2);
        String a = hex.length() < 8 ? "FF" : hex.substring(0, 2);
        return Integer.parseInt(a, 16) << 24 | Integer.parseInt(rgb, 16);
    }

    public static Color average(Color left, Color right, float leftWeight) {
        float rightWeight = 1.0f - leftWeight;
        float r = (float)Math.sqrt(left.r * left.r * leftWeight + right.r * right.r * rightWeight);
        float g = (float)Math.sqrt(left.g * left.g * leftWeight + right.g * right.g * rightWeight);
        float b = (float)Math.sqrt(left.b * left.b * leftWeight + right.b * right.b * rightWeight);
        float a = left.a * leftWeight + right.a * rightWeight;
        return new Color(r, g, b, a);
    }

    public static Color average(Color left, Color right, double leftWeight) {
        return Color.average(left, right, (float)leftWeight);
    }
}

