/*
 * Decompiled with CFR 0.152.
 */
package wraith.fabricaeexnihilo.util;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.item.v1.FabricItemSettings;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.fabricmc.fabric.api.registry.FlammableBlockRegistry;
import net.fabricmc.fabric.api.resource.conditions.v1.ConditionJsonProvider;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2320;
import net.minecraft.class_2346;
import net.minecraft.class_2960;
import net.minecraft.class_4970;
import org.jetbrains.annotations.Nullable;
import wraith.fabricaeexnihilo.FabricaeExNihilo;
import wraith.fabricaeexnihilo.api.FENApiModule;
import wraith.fabricaeexnihilo.api.FENRegistries;
import wraith.fabricaeexnihilo.datagen.DatagenItems;
import wraith.fabricaeexnihilo.modules.ModBlocks;
import wraith.fabricaeexnihilo.modules.ModItems;
import wraith.fabricaeexnihilo.modules.barrels.BarrelBlock;
import wraith.fabricaeexnihilo.modules.crucibles.CrucibleBlock;
import wraith.fabricaeexnihilo.modules.farming.PlantableItem;
import wraith.fabricaeexnihilo.modules.farming.TallPlantableItem;
import wraith.fabricaeexnihilo.modules.farming.TransformingItem;
import wraith.fabricaeexnihilo.modules.infested.InfestedLeavesBlock;
import wraith.fabricaeexnihilo.modules.sieves.MeshItem;
import wraith.fabricaeexnihilo.modules.sieves.SieveBlock;
import wraith.fabricaeexnihilo.modules.strainer.StrainerBlock;
import wraith.fabricaeexnihilo.util.Color;
import wraith.fabricaeexnihilo.util.Lazy;

public class EntrypointHelper {
    public static final Map<class_1935, List<ConditionJsonProvider>> CONDITIONS = Maps.newIdentityHashMap();

    public static void callEntrypoints() {
        Stream<Object> entrypoints = FabricLoader.getInstance().getEntrypoints("fabricaeexnihilo:api", FENApiModule.class).stream();
        if (System.getProperty("fabric-api.datagen") != null) {
            DatagenItems.register();
        } else {
            entrypoints = entrypoints.filter(FENApiModule::shouldLoad);
        }
        entrypoints.forEach(entrypoint -> entrypoint.onInit(new FENRegistriesImpl(entrypoint.getResourceCondition())));
    }

    private static class_2960 id(String ore, @Nullable String prefix, @Nullable String suffix) {
        return FabricaeExNihilo.id((prefix == null ? "" : prefix) + ore + (suffix == null ? "" : suffix));
    }

    private static final class FENRegistriesImpl
    implements FENRegistries {
        @Nullable
        private final ConditionJsonProvider condition;

        private FENRegistriesImpl(@Nullable ConditionJsonProvider condition) {
            this.condition = condition;
        }

        @Override
        public FabricItemSettings defaultItemSettings() {
            return new FabricItemSettings();
        }

        @Override
        public FabricBlockSettings gravelyBlockSettings() {
            return FabricBlockSettings.copyOf((class_4970)class_2246.field_10255);
        }

        @Override
        public FabricBlockSettings infestedLeavesBlockSettings() {
            return FabricBlockSettings.copyOf((class_4970.class_2251)ModBlocks.INFESTED_LEAVES_SETTINGS);
        }

        @Override
        public FabricBlockSettings sandyBlockSettings() {
            return FabricBlockSettings.copyOf((class_4970)class_2246.field_10102);
        }

        @Override
        public FabricBlockSettings stoneBlockSettings() {
            return FabricBlockSettings.copyOf((class_4970)class_2246.field_10340).requiresTool();
        }

        @Override
        public FabricBlockSettings woodenBlockSettings() {
            return FabricBlockSettings.copyOf((class_4970)class_2246.field_10161);
        }

        @Override
        public class_2248 registerBarrel(String name, boolean isFireproof, class_4970.class_2251 settings) {
            class_2960 id = EntrypointHelper.id(name, null, "_barrel");
            BarrelBlock block = ModBlocks.BARRELS.computeIfAbsent(id, __ -> {
                BarrelBlock block1 = new BarrelBlock(settings, isFireproof);
                if (!isFireproof) {
                    FlammableBlockRegistry.getDefaultInstance().add((class_2248)block1, 5, 20);
                }
                return block1;
            });
            if (this.condition != null) {
                CONDITIONS.computeIfAbsent((class_1935)block, __ -> new ArrayList()).add(this.condition);
            }
            return block;
        }

        @Override
        public class_2248 registerCrucible(String name, boolean isFireproof, class_4970.class_2251 settings) {
            class_2960 id = EntrypointHelper.id(name, null, "_crucible");
            CrucibleBlock block = ModBlocks.CRUCIBLES.computeIfAbsent(id, __ -> {
                CrucibleBlock block1 = new CrucibleBlock(settings, isFireproof);
                if (!isFireproof) {
                    FlammableBlockRegistry.getDefaultInstance().add((class_2248)block1, 5, 20);
                }
                return block1;
            });
            if (this.condition != null) {
                CONDITIONS.computeIfAbsent((class_1935)block, __ -> new ArrayList()).add(this.condition);
            }
            return block;
        }

        @Override
        public class_2248 registerCrushedBlock(String name, class_4970.class_2251 settings) {
            class_2960 id = EntrypointHelper.id(name, null, null);
            class_2248 block = ModBlocks.CRUSHED.computeIfAbsent(id, __ -> new class_2346(settings));
            if (this.condition != null) {
                CONDITIONS.computeIfAbsent((class_1935)block, __ -> new ArrayList()).add(this.condition);
            }
            return block;
        }

        @Override
        public class_2248 registerInfestedLeaves(String name, class_2960 source, class_4970.class_2251 settings) {
            class_2960 id = EntrypointHelper.id(name, "infested_", "_leaves");
            InfestedLeavesBlock block = ModBlocks.INFESTED_LEAVES.computeIfAbsent(id, __ -> {
                InfestedLeavesBlock block1 = new InfestedLeavesBlock(source, settings);
                FlammableBlockRegistry.getDefaultInstance().add((class_2248)block1, 30, 60);
                return block1;
            });
            if (this.condition != null) {
                CONDITIONS.computeIfAbsent((class_1935)block, __ -> new ArrayList()).add(this.condition);
            }
            return block;
        }

        @Override
        public class_1792 registerMesh(String name, Color color, int enchantability, class_1792.class_1793 settings) {
            class_2960 id = EntrypointHelper.id(name, null, "_mesh");
            MeshItem item = ModItems.MESHES.computeIfAbsent(id, __ -> new MeshItem(color, enchantability, settings));
            if (this.condition != null) {
                CONDITIONS.computeIfAbsent((class_1935)item, __ -> new ArrayList()).add(this.condition);
            }
            return item;
        }

        @Override
        public class_1792 registerOrePiece(String name, class_1792.class_1793 settings) {
            class_2960 id = EntrypointHelper.id(name, "raw_", "_piece");
            class_1792 item = ModItems.ORE_PIECES.computeIfAbsent(id, __ -> new class_1792(settings));
            if (this.condition != null) {
                CONDITIONS.computeIfAbsent((class_1935)item, __ -> new ArrayList()).add(this.condition);
            }
            return item;
        }

        @Override
        public class_1792 registerSeed(String name, Lazy<class_2248[]> plants) {
            class_2960 id = EntrypointHelper.id(name, null, "_seeds");
            class_1792 item = ModItems.SEEDS.computeIfAbsent(id, __ -> new PlantableItem(plants, ModItems.BASE_SETTINGS));
            if (this.condition != null) {
                CONDITIONS.computeIfAbsent((class_1935)item, __ -> new ArrayList()).add(this.condition);
            }
            return item;
        }

        @Override
        public class_2248 registerSieve(String name, boolean isFireproof, class_4970.class_2251 settings) {
            class_2960 id = EntrypointHelper.id(name, null, "_sieve");
            SieveBlock block = ModBlocks.SIEVES.computeIfAbsent(id, __ -> {
                SieveBlock block1 = new SieveBlock(settings);
                if (!isFireproof) {
                    FlammableBlockRegistry.getDefaultInstance().add((class_2248)block1, 5, 20);
                }
                return block1;
            });
            if (this.condition != null) {
                CONDITIONS.computeIfAbsent((class_1935)block, __ -> new ArrayList()).add(this.condition);
            }
            return block;
        }

        @Override
        public class_2248 registerStrainer(String name, boolean isFireproof, class_4970.class_2251 settings) {
            class_2960 id = EntrypointHelper.id(name, null, "_strainer");
            StrainerBlock block = ModBlocks.STRAINERS.computeIfAbsent(id, __ -> {
                StrainerBlock block1 = new StrainerBlock(settings);
                if (!isFireproof) {
                    FlammableBlockRegistry.getDefaultInstance().add((class_2248)block1, 5, 20);
                }
                return block1;
            });
            if (this.condition != null) {
                CONDITIONS.computeIfAbsent((class_1935)block, __ -> new ArrayList()).add(this.condition);
            }
            return block;
        }

        @Override
        public class_1792 registerTallPlantSeed(String name, Lazy<class_2320[]> plants) {
            class_2960 id = EntrypointHelper.id(name, null, "_seeds");
            class_1792 item = ModItems.SEEDS.computeIfAbsent(id, __ -> new TallPlantableItem(plants, ModItems.BASE_SETTINGS));
            if (this.condition != null) {
                CONDITIONS.computeIfAbsent((class_1935)item, __ -> new ArrayList()).add(this.condition);
            }
            return item;
        }

        @Override
        public class_1792 registerTransformingSeed(String name, Lazy<class_2248> from, Lazy<class_2248> to) {
            class_2960 id = EntrypointHelper.id(name, null, "_seeds");
            class_1792 item = ModItems.SEEDS.computeIfAbsent(id, __ -> new TransformingItem(from, to, ModItems.BASE_SETTINGS));
            if (this.condition != null) {
                CONDITIONS.computeIfAbsent((class_1935)item, __ -> new ArrayList()).add(this.condition);
            }
            return item;
        }

        @Override
        public FENRegistries.WoodenBlockBundle registerWood(String name, boolean fireproof, class_4970.class_2251 settings) {
            class_2248 sieve = this.registerSieve(name, fireproof, settings);
            class_2248 strainer = this.registerStrainer(name, fireproof, settings);
            class_2248 barrel = this.registerBarrel(name, fireproof, settings);
            class_2248 crucible = this.registerCrucible(name, fireproof, settings);
            return new WoodBlockBundleImpl(sieve, strainer, barrel, crucible);
        }

        private record WoodBlockBundleImpl(class_2248 sieve, class_2248 strainer, class_2248 barrel, class_2248 crucible) implements FENRegistries.WoodenBlockBundle
        {
        }
    }
}

