/*
 * Decompiled with CFR 0.152.
 */
package com.yyon.grapplinghook.config;

import com.yyon.grapplinghook.item.GrapplehookItem;
import com.yyon.grapplinghook.registry.GrappleModItems;
import com.yyon.grapplinghook.util.GrappleCustomization;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1799;

public class GrappleHookTemplate {
    private static final Map<String, GrappleHookTemplate> defaultTemplates = new LinkedHashMap<String, GrappleHookTemplate>();
    public static final GrappleHookTemplate ENDER_HOOK = GrappleHookTemplate.register(new GrappleHookTemplate("ender_hook", GrappleHookTemplate.property("throwspeed", 3.5), GrappleHookTemplate.property("maxlen", 60.0), GrappleHookTemplate.property("enderstaff", true)));
    public static final GrappleHookTemplate MOTOR_HOOK = GrappleHookTemplate.register(new GrappleHookTemplate("motor_hook", GrappleHookTemplate.property("throwspeed", 3.5), GrappleHookTemplate.property("maxlen", 60.0), GrappleHookTemplate.property("motor", true), GrappleHookTemplate.property("playermovementmult", 2.0)));
    public static final GrappleHookTemplate SMART_HOOK = GrappleHookTemplate.register(new GrappleHookTemplate("smart_hook", GrappleHookTemplate.property("throwspeed", 3.5), GrappleHookTemplate.property("maxlen", 60.0), GrappleHookTemplate.property("motor", true), GrappleHookTemplate.property("smartmotor", true), GrappleHookTemplate.property("playermovementmult", 2.0)));
    public static final GrappleHookTemplate MAGNET_HOOK = GrappleHookTemplate.register(new GrappleHookTemplate("magnet_hook", GrappleHookTemplate.property("throwspeed", 3.5), GrappleHookTemplate.property("maxlen", 60.0), GrappleHookTemplate.property("attract", true), GrappleHookTemplate.property("repel", true)));
    public static final GrappleHookTemplate ROCKET_HOOK = GrappleHookTemplate.register(new GrappleHookTemplate("rocket_hook", GrappleHookTemplate.property("throwspeed", 3.5), GrappleHookTemplate.property("maxlen", 60.0), GrappleHookTemplate.property("rocket", true)));
    public static final GrappleHookTemplate DOUBLE_MOTOR_HOOK = GrappleHookTemplate.register(new GrappleHookTemplate("double_motor_hook", GrappleHookTemplate.property("maxlen", 60.0), GrappleHookTemplate.property("doublehook", true), GrappleHookTemplate.property("motor", true), GrappleHookTemplate.property("motormaxspeed", 10.0), GrappleHookTemplate.property("sticky", true), GrappleHookTemplate.property("hookgravity", 50.0), GrappleHookTemplate.property("verticalthrowangle", 30.0), GrappleHookTemplate.property("sneakingverticalthrowangle", 25.0), GrappleHookTemplate.property("reelin", false), GrappleHookTemplate.property("motorwhencrouching", false), GrappleHookTemplate.property("smartdoublemotor", true), GrappleHookTemplate.property("angle", 25.0), GrappleHookTemplate.property("sneakingangle", 0.0), GrappleHookTemplate.property("throwspeed", 20.0), GrappleHookTemplate.property("playermovementmult", 2.0)));
    public static final GrappleHookTemplate DOUBLE_ROCKET_MOTOR_HOOK = GrappleHookTemplate.register(new GrappleHookTemplate("double_rocket_motor_hook", GrappleHookTemplate.property("maxlen", 60.0), GrappleHookTemplate.property("doublehook", true), GrappleHookTemplate.property("motor", true), GrappleHookTemplate.property("motormaxspeed", 10.0), GrappleHookTemplate.property("sticky", true), GrappleHookTemplate.property("hookgravity", 50.0), GrappleHookTemplate.property("verticalthrowangle", 30.0), GrappleHookTemplate.property("sneakingverticalthrowangle", 25.0), GrappleHookTemplate.property("reelin", false), GrappleHookTemplate.property("motorwhencrouching", true), GrappleHookTemplate.property("smartdoublemotor", true), GrappleHookTemplate.property("angle", 25.0), GrappleHookTemplate.property("sneakingangle", 0.0), GrappleHookTemplate.property("rocket", true), GrappleHookTemplate.property("rocket_vertical_angle", 30.0), GrappleHookTemplate.property("throwspeed", 20.0), GrappleHookTemplate.property("playermovementmult", 2.0)));
    private final String identifier;
    private final Set<AbstractProperty<?>> properties;

    private static GrappleHookTemplate register(GrappleHookTemplate template) {
        defaultTemplates.put(template.getId().toLowerCase(), template);
        return template;
    }

    private static BooleanProperty property(String id, boolean value) {
        return new BooleanProperty(id, value);
    }

    private static DoubleProperty property(String id, double value) {
        return new DoubleProperty(id, value);
    }

    public static Collection<GrappleHookTemplate> getTemplates() {
        return Collections.unmodifiableCollection(defaultTemplates.values());
    }

    private GrappleHookTemplate(String identifier, AbstractProperty<?> ... properties) {
        this.identifier = identifier;
        this.properties = Set.of(properties);
    }

    public String getId() {
        return this.identifier;
    }

    public boolean isEnabled() {
        return this.properties.stream().map(AbstractProperty::getId).noneMatch(p -> GrappleCustomization.optionEnabledInConfig(p) >= 2);
    }

    public GrappleCustomization getCustomizations() {
        GrappleCustomization customization = new GrappleCustomization();
        this.properties.forEach(p -> {
            if (p instanceof BooleanProperty) {
                BooleanProperty b = (BooleanProperty)p;
                customization.setBoolean(b.getId(), (Boolean)b.getValue());
            }
            if (p instanceof DoubleProperty) {
                DoubleProperty d = (DoubleProperty)p;
                customization.setDouble(d.getId(), (Double)d.getValue());
            }
        });
        return customization;
    }

    public class_1799 getAsStack() {
        class_1799 itemStack = ((GrapplehookItem)GrappleModItems.GRAPPLING_HOOK.get()).method_7854();
        ((GrapplehookItem)GrappleModItems.GRAPPLING_HOOK.get()).setCustomOnServer(itemStack, this.getCustomizations());
        return itemStack;
    }

    public static class BooleanProperty
    extends AbstractProperty<Boolean> {
        public BooleanProperty(String id, boolean value) {
            super(id, value);
        }
    }

    public static class DoubleProperty
    extends AbstractProperty<Double> {
        public DoubleProperty(String id, double value) {
            super(id, value);
        }
    }

    private static abstract class AbstractProperty<T> {
        private final String id;
        private final T value;

        public AbstractProperty(String id, T value) {
            this.id = id;
            this.value = value;
        }

        public String getId() {
            return this.id;
        }

        public T getValue() {
            return this.value;
        }
    }
}

