/*
 * Decompiled with CFR 0.152.
 */
package com.yyon.grapplinghook.network.clientbound;

import com.yyon.grapplinghook.GrappleMod;
import com.yyon.grapplinghook.config.GrappleConfig;
import com.yyon.grapplinghook.network.NetworkContext;
import com.yyon.grapplinghook.network.clientbound.BaseMessageClient;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Comparator;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public class LoggedInMessage
extends BaseMessageClient {
    GrappleConfig.Config conf;

    public LoggedInMessage(class_2540 buf) {
        super(buf);
    }

    public LoggedInMessage(GrappleConfig.Config serverconf) {
        this.conf = serverconf;
    }

    public <T> void decodeClass(class_2540 buf, Class<T> theClass, T theObject) {
        Field[] fields = theClass.getDeclaredFields();
        Arrays.sort(fields, Comparator.comparing(Field::getName));
        for (Field field : fields) {
            Type fieldtype = field.getGenericType();
            try {
                if (fieldtype.getTypeName().equals("int")) {
                    field.setInt(theObject, buf.readInt());
                    continue;
                }
                if (fieldtype.getTypeName().equals("double")) {
                    field.setDouble(theObject, buf.readDouble());
                    continue;
                }
                if (fieldtype.getTypeName().equals("boolean")) {
                    field.setBoolean(theObject, buf.readBoolean());
                    continue;
                }
                if (fieldtype.getTypeName().equals("java.lang.String")) {
                    int len = buf.readInt();
                    CharSequence charseq = buf.readCharSequence(len, Charset.defaultCharset());
                    field.set(theObject, charseq.toString());
                    continue;
                }
                if (Object.class.isAssignableFrom(field.getType())) {
                    Class<?> newClass = field.getType();
                    this.decodeClass(buf, newClass, newClass.cast(field.get(theObject)));
                    continue;
                }
                GrappleMod.LOGGER.warn("Unknown Type");
                GrappleMod.LOGGER.warn(fieldtype.getTypeName());
            }
            catch (IllegalAccessException e) {
                GrappleMod.LOGGER.warn((Object)e);
            }
        }
    }

    @Override
    public void decode(class_2540 buf) {
        Class<GrappleConfig.Config> confclass = GrappleConfig.Config.class;
        this.conf = new GrappleConfig.Config();
        this.decodeClass(buf, confclass, this.conf);
    }

    public <T> void encodeClass(class_2540 buf, Class<T> theClass, T theObject) {
        Field[] fields = theClass.getDeclaredFields();
        Arrays.sort(fields, Comparator.comparing(Field::getName));
        for (Field field : fields) {
            Type fieldtype = field.getGenericType();
            try {
                if (fieldtype.getTypeName().equals("int")) {
                    buf.writeInt(field.getInt(theObject));
                    continue;
                }
                if (fieldtype.getTypeName().equals("double")) {
                    buf.writeDouble(field.getDouble(theObject));
                    continue;
                }
                if (fieldtype.getTypeName().equals("boolean")) {
                    buf.writeBoolean(field.getBoolean(theObject));
                    continue;
                }
                if (fieldtype.getTypeName().equals("java.lang.String")) {
                    String str = (String)field.get(theObject);
                    buf.writeInt(str.length());
                    buf.writeCharSequence(str.subSequence(0, str.length()), Charset.defaultCharset());
                    continue;
                }
                if (Object.class.isAssignableFrom(field.getType())) {
                    Class<?> newClass = field.getType();
                    this.encodeClass(buf, newClass, newClass.cast(field.get(theObject)));
                    continue;
                }
                GrappleMod.LOGGER.warn("Unknown Type");
                GrappleMod.LOGGER.warn(fieldtype.getTypeName());
            }
            catch (IllegalAccessException e) {
                GrappleMod.LOGGER.warn((Object)e);
            }
        }
    }

    @Override
    public void encode(class_2540 buf) {
        Class<GrappleConfig.Config> confclass = GrappleConfig.Config.class;
        this.encodeClass(buf, confclass, this.conf);
    }

    @Override
    public class_2960 getChannel() {
        return GrappleMod.id("logged_in");
    }

    @Override
    public void processMessage(NetworkContext ctx) {
        GrappleConfig.setServerOptions(this.conf);
    }
}

