/*
 * Decompiled with CFR 0.152.
 */
package com.yyon.grapplinghook.util;

import com.yyon.grapplinghook.GrappleMod;
import com.yyon.grapplinghook.client.GrappleModClientCheck;
import com.yyon.grapplinghook.config.GrappleConfig;
import com.yyon.grapplinghook.item.ForcefieldItem;
import com.yyon.grapplinghook.item.upgrade.DoubleUpgradeItem;
import com.yyon.grapplinghook.item.upgrade.LimitsUpgradeItem;
import com.yyon.grapplinghook.item.upgrade.MagnetUpgradeItem;
import com.yyon.grapplinghook.item.upgrade.MotorUpgradeItem;
import com.yyon.grapplinghook.item.upgrade.RocketUpgradeItem;
import com.yyon.grapplinghook.item.upgrade.RopeUpgradeItem;
import com.yyon.grapplinghook.item.upgrade.StaffUpgradeItem;
import com.yyon.grapplinghook.item.upgrade.SwingUpgradeItem;
import com.yyon.grapplinghook.item.upgrade.ThrowUpgradeItem;
import com.yyon.grapplinghook.registry.GrappleModItems;
import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import java.util.zip.CRC32;
import net.minecraft.class_1792;
import net.minecraft.class_2487;
import net.minecraft.class_2561;

public class GrappleCustomization {
    public static final String[] booleanoptions = new String[]{"phaserope", "motor", "motorwhencrouching", "motorwhennotcrouching", "smartmotor", "enderstaff", "repel", "attract", "doublehook", "smartdoublemotor", "motordampener", "reelin", "pullbackwards", "oneropepull", "sticky", "detachonkeyrelease", "rocket"};
    public static final String[] doubleoptions = new String[]{"maxlen", "hookgravity", "throwspeed", "motormaxspeed", "motoracceleration", "playermovementmult", "repelforce", "attractradius", "angle", "sneakingangle", "verticalthrowangle", "sneakingverticalthrowangle", "rocket_force", "rocket_active_time", "rocket_refuel_ratio", "rocket_vertical_angle"};
    public double maxlen;
    public boolean phaserope;
    public boolean sticky;
    public double hookgravity;
    public double throwspeed;
    public boolean reelin;
    public double verticalthrowangle;
    public double sneakingverticalthrowangle;
    public boolean detachonkeyrelease;
    public boolean motor;
    public double motormaxspeed;
    public double motoracceleration;
    public boolean motorwhencrouching;
    public boolean motorwhennotcrouching;
    public boolean smartmotor;
    public boolean motordampener;
    public boolean pullbackwards;
    public double playermovementmult;
    public boolean enderstaff;
    public boolean repel;
    public double repelforce;
    public boolean attract;
    public double attractradius;
    public boolean doublehook;
    public boolean smartdoublemotor;
    public double angle;
    public double sneakingangle;
    public boolean oneropepull;
    public boolean rocket;
    public double rocket_force;
    public double rocket_active_time;
    public double rocket_refuel_ratio;
    public double rocket_vertical_angle;
    public static GrappleCustomization DEFAULT = new GrappleCustomization();

    public GrappleCustomization() {
        this.setDefaults();
    }

    public void setDefaults() {
        Object optionconfig;
        for (String option : booleanoptions) {
            optionconfig = GrappleCustomization.getBooleanConfig(option);
            this.setBoolean(option, ((GrappleConfig.Config.GrapplingHook.Custom.BooleanCustomizationOption)optionconfig).default_value);
        }
        for (String option : doubleoptions) {
            optionconfig = GrappleCustomization.getDoubleConfig(option);
            this.setDouble(option, ((GrappleConfig.Config.GrapplingHook.Custom.DoubleCustomizationOption)optionconfig).default_value);
        }
    }

    public static GrappleConfig.Config.GrapplingHook.Custom.BooleanCustomizationOption getBooleanConfig(String option) {
        return switch (option) {
            case "phaserope" -> GrappleConfig.getConf().grapplinghook.custom.rope.phaserope;
            case "motor" -> GrappleConfig.getConf().grapplinghook.custom.motor.motor;
            case "motorwhencrouching" -> GrappleConfig.getConf().grapplinghook.custom.motor.motorwhencrouching;
            case "motorwhennotcrouching" -> GrappleConfig.getConf().grapplinghook.custom.motor.motorwhennotcrouching;
            case "smartmotor" -> GrappleConfig.getConf().grapplinghook.custom.motor.smartmotor;
            case "enderstaff" -> GrappleConfig.getConf().grapplinghook.custom.enderstaff.enderstaff;
            case "repel" -> GrappleConfig.getConf().grapplinghook.custom.forcefield.repel;
            case "attract" -> GrappleConfig.getConf().grapplinghook.custom.magnet.attract;
            case "doublehook" -> GrappleConfig.getConf().grapplinghook.custom.doublehook.doublehook;
            case "smartdoublemotor" -> GrappleConfig.getConf().grapplinghook.custom.doublehook.smartdoublemotor;
            case "motordampener" -> GrappleConfig.getConf().grapplinghook.custom.motor.motordampener;
            case "reelin" -> GrappleConfig.getConf().grapplinghook.custom.hookthrower.reelin;
            case "pullbackwards" -> GrappleConfig.getConf().grapplinghook.custom.motor.pullbackwards;
            case "oneropepull" -> GrappleConfig.getConf().grapplinghook.custom.doublehook.oneropepull;
            case "sticky" -> GrappleConfig.getConf().grapplinghook.custom.rope.sticky;
            case "detachonkeyrelease" -> GrappleConfig.getConf().grapplinghook.custom.hookthrower.detachonkeyrelease;
            case "rocket" -> GrappleConfig.getConf().grapplinghook.custom.rocket.rocketenabled;
            default -> null;
        };
    }

    public static GrappleConfig.Config.GrapplingHook.Custom.DoubleCustomizationOption getDoubleConfig(String option) {
        return switch (option) {
            case "maxlen" -> GrappleConfig.getConf().grapplinghook.custom.rope.maxlen;
            case "hookgravity" -> GrappleConfig.getConf().grapplinghook.custom.hookthrower.hookgravity;
            case "throwspeed" -> GrappleConfig.getConf().grapplinghook.custom.hookthrower.throwspeed;
            case "motormaxspeed" -> GrappleConfig.getConf().grapplinghook.custom.motor.motormaxspeed;
            case "motoracceleration" -> GrappleConfig.getConf().grapplinghook.custom.motor.motoracceleration;
            case "playermovementmult" -> GrappleConfig.getConf().grapplinghook.custom.swing.playermovementmult;
            case "repelforce" -> GrappleConfig.getConf().grapplinghook.custom.forcefield.repelforce;
            case "attractradius" -> GrappleConfig.getConf().grapplinghook.custom.magnet.attractradius;
            case "angle" -> GrappleConfig.getConf().grapplinghook.custom.doublehook.angle;
            case "sneakingangle" -> GrappleConfig.getConf().grapplinghook.custom.doublehook.sneakingangle;
            case "verticalthrowangle" -> GrappleConfig.getConf().grapplinghook.custom.hookthrower.verticalthrowangle;
            case "sneakingverticalthrowangle" -> GrappleConfig.getConf().grapplinghook.custom.hookthrower.sneakingverticalthrowangle;
            case "rocket_force" -> GrappleConfig.getConf().grapplinghook.custom.rocket.rocket_force;
            case "rocket_active_time" -> GrappleConfig.getConf().grapplinghook.custom.rocket.rocket_active_time;
            case "rocket_refuel_ratio" -> GrappleConfig.getConf().grapplinghook.custom.rocket.rocket_refuel_ratio;
            case "rocket_vertical_angle" -> GrappleConfig.getConf().grapplinghook.custom.rocket.rocket_vertical_angle;
            default -> null;
        };
    }

    public class_2487 writeNBT() {
        class_2487 compound = new class_2487();
        for (String option : booleanoptions) {
            compound.method_10556(option, this.getBoolean(option));
        }
        for (String option : doubleoptions) {
            compound.method_10549(option, this.getDouble(option));
        }
        compound.method_10544("crc32", this.getChecksum());
        return compound;
    }

    public void loadNBT(class_2487 compound) {
        for (String option : booleanoptions) {
            if (!compound.method_10545(option)) continue;
            this.setBoolean(option, compound.method_10577(option));
        }
        for (String option : doubleoptions) {
            if (!compound.method_10545(option)) continue;
            this.setDouble(option, compound.method_10574(option));
        }
        if (compound.method_10545("crc32")) {
            long recordedChecksum = compound.method_10537("crc32");
            if (this.getChecksum() != recordedChecksum) {
                GrappleMod.LOGGER.error("Error checksum reading from NBT");
                this.setDefaults();
            }
        }
    }

    public void setBoolean(String option, boolean bool) {
        switch (option) {
            case "phaserope": {
                this.phaserope = bool;
                break;
            }
            case "motor": {
                this.motor = bool;
                break;
            }
            case "motorwhencrouching": {
                this.motorwhencrouching = bool;
                break;
            }
            case "motorwhennotcrouching": {
                this.motorwhennotcrouching = bool;
                break;
            }
            case "smartmotor": {
                this.smartmotor = bool;
                break;
            }
            case "enderstaff": {
                this.enderstaff = bool;
                break;
            }
            case "repel": {
                this.repel = bool;
                break;
            }
            case "attract": {
                this.attract = bool;
                break;
            }
            case "doublehook": {
                this.doublehook = bool;
                break;
            }
            case "smartdoublemotor": {
                this.smartdoublemotor = bool;
                break;
            }
            case "motordampener": {
                this.motordampener = bool;
                break;
            }
            case "reelin": {
                this.reelin = bool;
                break;
            }
            case "pullbackwards": {
                this.pullbackwards = bool;
                break;
            }
            case "oneropepull": {
                this.oneropepull = bool;
                break;
            }
            case "sticky": {
                this.sticky = bool;
                break;
            }
            case "detachonkeyrelease": {
                this.detachonkeyrelease = bool;
                break;
            }
            case "rocket": {
                this.rocket = bool;
                break;
            }
            default: {
                GrappleMod.LOGGER.warn("Option doesn't exist: " + option);
            }
        }
    }

    public boolean getBoolean(String option) {
        return switch (option) {
            case "phaserope" -> this.phaserope;
            case "motor" -> this.motor;
            case "motorwhencrouching" -> this.motorwhencrouching;
            case "motorwhennotcrouching" -> this.motorwhennotcrouching;
            case "smartmotor" -> this.smartmotor;
            case "enderstaff" -> this.enderstaff;
            case "repel" -> this.repel;
            case "attract" -> this.attract;
            case "doublehook" -> this.doublehook;
            case "smartdoublemotor" -> this.smartdoublemotor;
            case "motordampener" -> this.motordampener;
            case "reelin" -> this.reelin;
            case "pullbackwards" -> this.pullbackwards;
            case "oneropepull" -> this.oneropepull;
            case "sticky" -> this.sticky;
            case "detachonkeyrelease" -> this.detachonkeyrelease;
            case "rocket" -> this.rocket;
            default -> {
                GrappleMod.LOGGER.warn("Option doesn't exist: " + option);
                yield false;
            }
        };
    }

    public void setDouble(String option, double d) {
        switch (option) {
            case "maxlen": {
                this.maxlen = d;
                break;
            }
            case "hookgravity": {
                this.hookgravity = d;
                break;
            }
            case "throwspeed": {
                this.throwspeed = d;
                break;
            }
            case "motormaxspeed": {
                this.motormaxspeed = d;
                break;
            }
            case "motoracceleration": {
                this.motoracceleration = d;
                break;
            }
            case "playermovementmult": {
                this.playermovementmult = d;
                break;
            }
            case "repelforce": {
                this.repelforce = d;
                break;
            }
            case "attractradius": {
                this.attractradius = d;
                break;
            }
            case "angle": {
                this.angle = d;
                break;
            }
            case "sneakingangle": {
                this.sneakingangle = d;
                break;
            }
            case "verticalthrowangle": {
                this.verticalthrowangle = d;
                break;
            }
            case "sneakingverticalthrowangle": {
                this.sneakingverticalthrowangle = d;
                break;
            }
            case "rocket_force": {
                this.rocket_force = d;
                break;
            }
            case "rocket_active_time": {
                this.rocket_active_time = d;
                break;
            }
            case "rocket_refuel_ratio": {
                this.rocket_refuel_ratio = d;
                break;
            }
            case "rocket_vertical_angle": {
                this.rocket_vertical_angle = d;
                break;
            }
            default: {
                GrappleMod.LOGGER.warn("Option doesn't exist: " + option);
            }
        }
    }

    public double getDouble(String option) {
        return switch (option) {
            case "maxlen" -> this.maxlen;
            case "hookgravity" -> this.hookgravity;
            case "throwspeed" -> this.throwspeed;
            case "motormaxspeed" -> this.motormaxspeed;
            case "motoracceleration" -> this.motoracceleration;
            case "playermovementmult" -> this.playermovementmult;
            case "repelforce" -> this.repelforce;
            case "attractradius" -> this.attractradius;
            case "angle" -> this.angle;
            case "sneakingangle" -> this.sneakingangle;
            case "verticalthrowangle" -> this.verticalthrowangle;
            case "sneakingverticalthrowangle" -> this.sneakingverticalthrowangle;
            case "rocket_force" -> this.rocket_force;
            case "rocket_active_time" -> this.rocket_active_time;
            case "rocket_refuel_ratio" -> this.rocket_refuel_ratio;
            case "rocket_vertical_angle" -> this.rocket_vertical_angle;
            default -> {
                GrappleMod.LOGGER.warn("Option doesn't exist: " + option);
                yield 0.0;
            }
        };
    }

    public long getChecksum() {
        CRC32 checker = new CRC32();
        for (String option : booleanoptions) {
            checker.update(this.getBoolean(option) ? 1 : 0);
        }
        for (String option : doubleoptions) {
            checker.update(ByteBuffer.allocate(8).putDouble(this.getDouble(option)).array());
        }
        checker.update(54902349);
        return checker.getValue();
    }

    public void writeToBuf(ByteBuf buf) {
        for (String option : booleanoptions) {
            buf.writeBoolean(this.getBoolean(option));
        }
        for (String option : doubleoptions) {
            buf.writeDouble(this.getDouble(option));
        }
        buf.writeLong(this.getChecksum());
    }

    public void readFromBuf(ByteBuf buf) {
        for (String option : booleanoptions) {
            this.setBoolean(option, buf.readBoolean());
        }
        for (String option : doubleoptions) {
            this.setDouble(option, buf.readDouble());
        }
        long recordedChecksum = buf.readLong();
        if (this.getChecksum() != recordedChecksum) {
            GrappleMod.LOGGER.error("Error checksum reading from buffer");
            this.setDefaults();
        }
    }

    public String getName(String option) {
        return "grapplecustomization." + option;
    }

    public String getDescription(String option) {
        return "grapplecustomization." + option + ".desc";
    }

    public boolean isOptionValid(String option) {
        if (option == null) {
            return false;
        }
        if (option.equals("motormaxspeed") || option.equals("motoracceleration") || option.equals("motorwhencrouching") || option.equals("motorwhennotcrouching") || option.equals("smartmotor") || option.equals("motordampener") || option.equals("pullbackwards")) {
            return this.motor;
        }
        if (option.equals("sticky")) {
            return !this.phaserope;
        }
        if (option.equals("sneakingangle")) {
            return this.doublehook && !this.reelin;
        }
        if (option.equals("repelforce")) {
            return this.repel;
        }
        if (option.equals("attractradius")) {
            return this.attract;
        }
        if (option.equals("angle")) {
            return this.doublehook;
        }
        if (option.equals("smartdoublemotor") || option.equals("oneropepull")) {
            return this.doublehook && this.motor;
        }
        if (option.equals("rocket_active_time") || option.equals("rocket_refuel_ratio") || option.equals("rocket_force") || option.equals("rocket_vertical_angle")) {
            return this.rocket;
        }
        return true;
    }

    public static double getMaxFromConfig(String option, int upgrade) {
        GrappleConfig.Config.GrapplingHook.Custom.DoubleCustomizationOption configoption = GrappleCustomization.getDoubleConfig(option);
        return upgrade == 1 ? configoption.max_upgraded : configoption.max;
    }

    public static double getMinFromConfig(String option, int upgrade) {
        GrappleConfig.Config.GrapplingHook.Custom.DoubleCustomizationOption configoption = GrappleCustomization.getDoubleConfig(option);
        return upgrade == 1 ? configoption.min_upgraded : configoption.min;
    }

    public static int optionEnabledInConfig(String option) {
        GrappleConfig.Config.GrapplingHook.Custom.BooleanCustomizationOption configoption = GrappleCustomization.getBooleanConfig(option);
        if (configoption != null) {
            return configoption.enabled;
        }
        return GrappleCustomization.getDoubleConfig((String)option).enabled;
    }

    public boolean equals(GrappleCustomization other) {
        for (String option : booleanoptions) {
            if (this.getBoolean(option) == other.getBoolean(option)) continue;
            return false;
        }
        for (String option : doubleoptions) {
            if (this.getDouble(option) == other.getDouble(option)) continue;
            return false;
        }
        return true;
    }

    public static enum UpgradeCategories {
        ROPE("rope"),
        THROW("throw"),
        MOTOR("motor"),
        SWING("swing"),
        STAFF("staff"),
        FORCEFIELD("forcefield"),
        MAGNET("magnet"),
        DOUBLE("double"),
        LIMITS("limits"),
        ROCKET("rocket");

        private final String nameUnlocalized;

        private UpgradeCategories(String name) {
            this.nameUnlocalized = name;
        }

        public String getName() {
            if (GrappleModClientCheck.isClientLoaded()) {
                return class_2561.method_43471((String)("grapplemod.upgradecategories." + this.nameUnlocalized)).getString();
            }
            return this.nameUnlocalized;
        }

        public static UpgradeCategories fromInt(int i) {
            return UpgradeCategories.values()[i];
        }

        public int toInt() {
            for (int i = 0; i < UpgradeCategories.size(); ++i) {
                if (UpgradeCategories.values()[i] != this) continue;
                return i;
            }
            return -1;
        }

        public static int size() {
            return UpgradeCategories.values().length;
        }

        public class_1792 getItem() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case ROPE -> (RopeUpgradeItem)((Object)GrappleModItems.ROPE_UPGRADE.get());
                case THROW -> (ThrowUpgradeItem)((Object)GrappleModItems.THROW_UPGRADE.get());
                case MOTOR -> (MotorUpgradeItem)((Object)GrappleModItems.MOTOR_UPGRADE.get());
                case SWING -> (SwingUpgradeItem)((Object)GrappleModItems.SWING_UPGRADE.get());
                case STAFF -> (StaffUpgradeItem)((Object)GrappleModItems.ENDER_STAFF_UPGRADE.get());
                case FORCEFIELD -> (ForcefieldItem)((Object)GrappleModItems.FORCE_FIELD.get());
                case MAGNET -> (MagnetUpgradeItem)((Object)GrappleModItems.MAGNET_UPGRADE.get());
                case DOUBLE -> (DoubleUpgradeItem)((Object)GrappleModItems.DOUBLE_UPGRADE.get());
                case LIMITS -> (LimitsUpgradeItem)((Object)GrappleModItems.LIMITS_UPGRADE.get());
                case ROCKET -> (RocketUpgradeItem)((Object)GrappleModItems.ROCKET_UPGRADE.get());
            };
        }
    }
}

