/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.addons.sponge.lib.commons.io.input;

import com.dfsek.terra.addons.sponge.lib.commons.io.TaggedIOException;
import com.dfsek.terra.addons.sponge.lib.commons.io.input.ProxyReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.util.UUID;

public class TaggedReader
extends ProxyReader {
    private final Serializable tag = UUID.randomUUID();

    public TaggedReader(Reader proxy) {
        super(proxy);
    }

    public boolean isCauseOf(Throwable exception) {
        return TaggedIOException.isTaggedWith(exception, this.tag);
    }

    public void throwIfCauseOf(Throwable throwable) throws IOException {
        TaggedIOException.throwCauseIfTaggedWith(throwable, this.tag);
    }

    @Override
    protected void handleIOException(IOException e) throws IOException {
        throw new TaggedIOException(e, this.tag);
    }
}

