/*
 * Decompiled with CFR 0.152.
 */
package nl.enjarai.showmeyourskin.config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1802;
import nl.enjarai.showmeyourskin.config.HideableEquipment;

public class ArmorConfig {
    public static final Codec<ArmorConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("showInCombat").forGetter(config -> config.showInCombat), (App)Codec.BOOL.fieldOf("showNameTag").forGetter(config -> config.showNameTag), (App)Codec.unboundedMap(HideableEquipment.getCodec(), ArmorPieceConfig.CODEC).fieldOf("pieces").forGetter(config -> config.pieces), (App)Codec.unboundedMap(HideableEquipment.getSlotCodec(), ArmorPieceConfig.CODEC).fieldOf("trims").forGetter(config -> config.trims), (App)Codec.unboundedMap(HideableEquipment.getCodec(), ArmorPieceConfig.CODEC).fieldOf("glints").forGetter(config -> config.glints)).apply((Applicative)instance, ArmorConfig::new));
    public static final ArmorConfig VANILLA_VALUES = new ArmorConfig();
    public final HashMap<HideableEquipment, ArmorPieceConfig> pieces = new HashMap();
    public final HashMap<class_1304, ArmorPieceConfig> trims = new HashMap();
    public final HashMap<HideableEquipment, ArmorPieceConfig> glints = new HashMap();
    public boolean showInCombat = true;
    public boolean showNameTag = true;

    public ArmorConfig() {
        this.pieces.put(HideableEquipment.HEAD, new ArmorPieceConfig());
        this.pieces.put(HideableEquipment.CHEST, new ArmorPieceConfig());
        this.pieces.put(HideableEquipment.LEGS, new ArmorPieceConfig());
        this.pieces.put(HideableEquipment.FEET, new ArmorPieceConfig());
        this.pieces.put(HideableEquipment.ELYTRA, new ArmorPieceConfig());
        this.pieces.put(HideableEquipment.SHIELD, new ArmorPieceConfig());
        this.trims.put(class_1304.field_6169, new ArmorPieceConfig());
        this.trims.put(class_1304.field_6174, new ArmorPieceConfig());
        this.trims.put(class_1304.field_6172, new ArmorPieceConfig());
        this.trims.put(class_1304.field_6166, new ArmorPieceConfig());
        this.glints.put(HideableEquipment.HEAD, new ArmorPieceConfig());
        this.glints.put(HideableEquipment.CHEST, new ArmorPieceConfig());
        this.glints.put(HideableEquipment.LEGS, new ArmorPieceConfig());
        this.glints.put(HideableEquipment.FEET, new ArmorPieceConfig());
        this.glints.put(HideableEquipment.ELYTRA, new ArmorPieceConfig());
        this.glints.put(HideableEquipment.SHIELD, new ArmorPieceConfig());
    }

    public ArmorConfig(boolean showInCombat, boolean showNameTag, Map<HideableEquipment, ArmorPieceConfig> pieces, Map<class_1304, ArmorPieceConfig> trims, Map<HideableEquipment, ArmorPieceConfig> glints) {
        this.showInCombat = showInCombat;
        this.showNameTag = showNameTag;
        this.pieces.putAll(pieces);
        this.trims.putAll(trims);
        this.glints.putAll(glints);
    }

    public Map<HideableEquipment, ArmorPieceConfig> getPieces() {
        return this.pieces;
    }

    public Map<class_1304, ArmorPieceConfig> getTrims() {
        return this.trims;
    }

    public Map<HideableEquipment, ArmorPieceConfig> getGlints() {
        return this.glints;
    }

    public boolean shouldTransformCape(class_1657 player) {
        return !(this.getPieces().get((Object)HideableEquipment.CHEST).getTransparency() <= 0 && this.getTrims().get(class_1304.field_6174).getTransparency() <= 0 || player.method_6118(class_1304.field_6174).method_31574(class_1802.field_8833) && this.getPieces().get((Object)HideableEquipment.ELYTRA).getTransparency() <= 0);
    }

    public void ensureValid() {
        for (HideableEquipment hideableEquipment : HideableEquipment.values()) {
            if (this.pieces.containsKey((Object)hideableEquipment)) continue;
            this.pieces.put(hideableEquipment, new ArmorPieceConfig());
        }
        for (HideableEquipment hideableEquipment : class_1304.values()) {
            if (this.trims.containsKey((Object)hideableEquipment)) continue;
            this.trims.put((class_1304)hideableEquipment, new ArmorPieceConfig());
        }
        for (HideableEquipment hideableEquipment : HideableEquipment.values()) {
            if (this.glints.containsKey((Object)hideableEquipment)) continue;
            this.glints.put(hideableEquipment, new ArmorPieceConfig());
        }
    }

    public ArmorConfig copy() {
        return new ArmorConfig(this.showInCombat, this.showNameTag, this.pieces.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((ArmorPieceConfig)e.getValue()).copy())), this.trims.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((ArmorPieceConfig)e.getValue()).copy())), this.glints.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((ArmorPieceConfig)e.getValue()).copy())));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArmorConfig that = (ArmorConfig)o;
        if (this.showInCombat != that.showInCombat) {
            return false;
        }
        if (this.showNameTag != that.showNameTag) {
            return false;
        }
        if (!this.pieces.equals(that.pieces)) {
            return false;
        }
        if (!this.trims.equals(that.trims)) {
            return false;
        }
        return this.glints.equals(that.glints);
    }

    public int hashCode() {
        int result = this.pieces.hashCode();
        result = 31 * result + this.trims.hashCode();
        result = 31 * result + this.glints.hashCode();
        result = 31 * result + (this.showInCombat ? 1 : 0);
        result = 31 * result + (this.showNameTag ? 1 : 0);
        return result;
    }

    public static class ArmorPieceConfig {
        public static final Codec<ArmorPieceConfig> CODEC = Codec.BYTE.fieldOf("transparency").codec().xmap(ArmorPieceConfig::new, ArmorPieceConfig::getTransparency);
        public static final ArmorPieceConfig VANILLA_VALUES = new ArmorPieceConfig();
        public byte transparency = (byte)100;

        public ArmorPieceConfig() {
        }

        public ArmorPieceConfig(byte transparency) {
            this.transparency = transparency;
        }

        public byte getTransparency() {
            return this.transparency;
        }

        public void setTransparency(byte transparency) {
            this.transparency = transparency;
        }

        public ArmorPieceConfig copy() {
            return new ArmorPieceConfig(this.transparency);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ArmorPieceConfig that = (ArmorPieceConfig)o;
            return this.transparency == that.transparency;
        }

        public int hashCode() {
            return this.transparency;
        }
    }
}

