/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.common.util.algorithm;

import com.mojang.datafixers.util.Pair;
import earth.terrarium.ad_astra.common.block.door.SlidingDoorBlock;
import earth.terrarium.ad_astra.common.config.OxygenDistributorConfig;
import earth.terrarium.ad_astra.common.registry.ModTags;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2769;

public class FloodFiller3D {
    public static Set<class_2338> run(class_1937 level, class_2338 start) {
        LinkedHashSet<class_2338> positions = new LinkedHashSet<class_2338>();
        LinkedHashSet<Pair> queue = new LinkedHashSet<Pair>();
        queue.add(Pair.of((Object)start, (Object)class_2350.field_11036));
        while (!queue.isEmpty() && positions.size() < OxygenDistributorConfig.maxBlockChecks) {
            Iterator iterator = queue.iterator();
            Pair pair = (Pair)iterator.next();
            class_2338 pos = ((class_2338)pair.getFirst()).method_10093((class_2350)pair.getSecond());
            iterator.remove();
            class_2680 state = level.method_8320(pos);
            if (FloodFiller3D.runAdditionalChecks(level, state, pos) || state.method_26164(ModTags.BLOCKS_FLOOD_FILL)) continue;
            class_265 collisionShape = state.method_26220((class_1922)level, pos);
            if (!state.method_26215() && !state.method_26164(ModTags.PASSES_FLOOD_FILL) && !collisionShape.method_1110() && FloodFiller3D.isSideSolid(collisionShape, (class_2350)pair.getSecond(), state) && (FloodFiller3D.isFaceSturdy(collisionShape, (class_2350)pair.getSecond(), state) || FloodFiller3D.isFaceSturdy(collisionShape, ((class_2350)pair.getSecond()).method_10153(), state))) continue;
            positions.add(pos);
            for (class_2350 dir : class_2350.values()) {
                if (positions.contains(pos.method_10093(dir))) continue;
                queue.add(Pair.of((Object)pos, (Object)dir));
            }
        }
        return positions;
    }

    private static boolean runAdditionalChecks(class_1937 level, class_2680 state, class_2338 pos) {
        class_2248 block = state.method_26204();
        if (block instanceof SlidingDoorBlock) {
            SlidingDoorBlock door = (SlidingDoorBlock)block;
            class_2680 blockState = level.method_8320(door.getMainPos(state, pos));
            Optional open = blockState.method_28500((class_2769)SlidingDoorBlock.OPEN);
            Optional powered = blockState.method_28500((class_2769)SlidingDoorBlock.POWERED);
            return open.isPresent() && (Boolean)open.get() == false && powered.isPresent() && (Boolean)powered.get() == false;
        }
        return false;
    }

    private static boolean isSideSolid(class_265 collisionShape, class_2350 dir, class_2680 state) {
        return FloodFiller3D.checkBounds(collisionShape.method_1107(), dir.method_10166());
    }

    private static boolean isFaceSturdy(class_265 collisionShape, class_2350 dir, class_2680 state) {
        class_265 faceShape = collisionShape.method_20538(dir);
        if (faceShape.method_1110()) {
            return true;
        }
        return FloodFiller3D.checkBounds((class_238)faceShape.method_1090().get(0), dir.method_10166());
    }

    private static boolean checkBounds(class_238 bounds, class_2350.class_2351 axis) {
        return switch (axis) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.class_2351.field_11048 -> {
                if (bounds.field_1322 <= 0.0 && bounds.field_1325 >= 1.0 && bounds.field_1321 <= 0.0 && bounds.field_1324 >= 1.0) {
                    yield true;
                }
                yield false;
            }
            case class_2350.class_2351.field_11052 -> {
                if (bounds.field_1323 <= 0.0 && bounds.field_1320 >= 1.0 && bounds.field_1321 <= 0.0 && bounds.field_1324 >= 1.0) {
                    yield true;
                }
                yield false;
            }
            case class_2350.class_2351.field_11051 -> bounds.field_1323 <= 0.0 && bounds.field_1320 >= 1.0 && bounds.field_1322 <= 0.0 && bounds.field_1325 >= 1.0;
        };
    }
}

