/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.addons.chunkgenerator.palette;

import com.dfsek.terra.addons.chunkgenerator.lib.jafama.FastMath;
import com.dfsek.terra.api.world.chunk.generation.util.Palette;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class PaletteHolder {
    private final Palette[] palettes;
    private final int offset;

    protected PaletteHolder(Palette[] palettes, int offset) {
        this.palettes = palettes;
        this.offset = offset;
    }

    public Palette getPalette(int y) {
        int index = y + this.offset;
        return index >= 0 ? (index < this.palettes.length ? this.palettes[index] : this.palettes[this.palettes.length - 1]) : this.palettes[0];
    }

    public static PaletteHolder of(List<Map<Palette, Integer>> palettes) {
        PaletteHolderBuilder builder = new PaletteHolderBuilder();
        for (Map<Palette, Integer> layer : palettes) {
            for (Map.Entry<Palette, Integer> entry : layer.entrySet()) {
                builder.add(entry.getValue(), entry.getKey());
            }
        }
        return builder.build();
    }

    private static class PaletteHolderBuilder {
        private final TreeMap<Integer, Palette> paletteMap = new TreeMap();

        private PaletteHolderBuilder() {
        }

        public PaletteHolderBuilder add(int y, Palette palette) {
            this.paletteMap.put(y, palette);
            return this;
        }

        public PaletteHolder build() {
            int min = FastMath.min(this.paletteMap.keySet().stream().min(Integer::compareTo).orElse(0), 0);
            int max = FastMath.max(this.paletteMap.keySet().stream().max(Integer::compareTo).orElse(255), 255);
            Palette[] palettes = new Palette[this.paletteMap.lastKey() + 1 - min];
            for (int y = min; y <= FastMath.max(this.paletteMap.lastKey(), max); ++y) {
                Palette d = null;
                for (Map.Entry<Integer, Palette> e : this.paletteMap.entrySet()) {
                    if (e.getKey() < y) continue;
                    d = e.getValue();
                    break;
                }
                if (d == null) {
                    throw new IllegalArgumentException("No palette for Y=" + y);
                }
                palettes[y - min] = d;
            }
            return new PaletteHolder(palettes, -min);
        }
    }
}

