/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk;

import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongLinkedOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongListIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.stream.LongStream;
import net.minecraft.class_1923;

public class ChunkTracker {
    private final Long2IntOpenHashMap single = new Long2IntOpenHashMap();
    private final Long2IntOpenHashMap merged = new Long2IntOpenHashMap();
    private final LongLinkedOpenHashSet dirty = new LongLinkedOpenHashSet();

    public ChunkTracker() {
        this.single.defaultReturnValue(0);
        this.merged.defaultReturnValue(0);
    }

    public void update() {
        if (this.dirty.isEmpty()) {
            return;
        }
        LongSet dirty = this.markDirtyChunks();
        this.recalculateChunks(dirty);
        this.dirty.clear();
    }

    private void recalculateChunks(LongSet set) {
        LongIterator it = set.iterator();
        while (it.hasNext()) {
            long key = it.nextLong();
            int x = class_1923.method_8325((long)key);
            int z = class_1923.method_8332((long)key);
            int flags = this.single.get(key);
            for (int ox = -1; ox <= 1; ++ox) {
                for (int oz = -1; oz <= 1; ++oz) {
                    flags &= this.single.get(class_1923.method_8331((int)(ox + x), (int)(oz + z)));
                }
            }
            if (flags != 0) {
                this.merged.put(key, flags);
                continue;
            }
            this.merged.remove(key);
        }
    }

    private LongSet markDirtyChunks() {
        LongOpenHashSet dirty = new LongOpenHashSet((LongCollection)this.dirty);
        LongListIterator it = this.dirty.iterator();
        while (it.hasNext()) {
            long key = it.nextLong();
            int x = class_1923.method_8325((long)key);
            int z = class_1923.method_8332((long)key);
            for (int ox = -1; ox <= 1; ++ox) {
                for (int oz = -1; oz <= 1; ++oz) {
                    dirty.add(class_1923.method_8331((int)(ox + x), (int)(oz + z)));
                }
            }
        }
        return dirty;
    }

    public boolean loadChunk(int x, int z) {
        int flags;
        long key = class_1923.method_8331((int)x, (int)z);
        if (this.single.put(key, flags = this.single.get(key) | 1) == flags) {
            return false;
        }
        this.dirty.add(key);
        return true;
    }

    public void onLightDataAdded(int x, int z) {
        long key = class_1923.method_8331((int)x, (int)z);
        int existingFlags = this.single.get(key);
        this.single.put(key, existingFlags | 2);
        this.dirty.add(key);
    }

    public boolean unloadChunk(int x, int z) {
        long key = class_1923.method_8331((int)x, (int)z);
        if ((this.single.remove(class_1923.method_8331((int)x, (int)z)) & 1) != 1) {
            return false;
        }
        this.dirty.add(key);
        return true;
    }

    public boolean hasMergedFlags(int x, int z, int flags) {
        return (this.merged.get(class_1923.method_8331((int)x, (int)z)) & flags) == flags;
    }

    public LongStream getChunks(int flags) {
        return this.single.long2IntEntrySet().stream().filter(entry -> (entry.getIntValue() & flags) == flags).mapToLong(Long2IntMap.Entry::getLongKey);
    }
}

