/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.addons.noise.paralithic.defined;

import com.dfsek.terra.addons.noise.config.templates.FunctionTemplate;
import com.dfsek.terra.addons.noise.lib.paralithic.Expression;
import com.dfsek.terra.addons.noise.lib.paralithic.eval.parser.Parser;
import com.dfsek.terra.addons.noise.lib.paralithic.eval.parser.Scope;
import com.dfsek.terra.addons.noise.lib.paralithic.eval.tokenizer.ParseException;
import com.dfsek.terra.addons.noise.lib.paralithic.functions.dynamic.Context;
import com.dfsek.terra.addons.noise.lib.paralithic.functions.dynamic.DynamicFunction;
import com.dfsek.terra.addons.noise.lib.paralithic.node.Statefulness;
import java.util.HashMap;
import java.util.Map;

public class UserDefinedFunction
implements DynamicFunction {
    private static final Map<FunctionTemplate, UserDefinedFunction> CACHE = new HashMap<FunctionTemplate, UserDefinedFunction>();
    private final Expression expression;
    private final int args;

    protected UserDefinedFunction(Expression expression, int args) {
        this.expression = expression;
        this.args = args;
    }

    public static UserDefinedFunction newInstance(FunctionTemplate template) throws ParseException {
        UserDefinedFunction function = CACHE.get(template);
        if (function == null) {
            Parser parser = new Parser();
            Scope parent = new Scope();
            Scope functionScope = new Scope().withParent(parent);
            template.getArgs().forEach(functionScope::addInvocationVariable);
            for (Map.Entry<String, FunctionTemplate> entry : template.getFunctions().entrySet()) {
                String id = entry.getKey();
                FunctionTemplate nest = entry.getValue();
                parser.registerFunction(id, UserDefinedFunction.newInstance(nest));
            }
            function = new UserDefinedFunction(parser.parse(template.getFunction(), functionScope), template.getArgs().size());
            CACHE.put(template, function);
        }
        return function;
    }

    @Override
    public double eval(double ... args) {
        return this.expression.evaluate(args);
    }

    @Override
    public double eval(Context context, double ... args) {
        return this.expression.evaluate(context, args);
    }

    @Override
    public int getArgNumber() {
        return this.args;
    }

    @Override
    public Statefulness statefulness() {
        return Statefulness.STATELESS;
    }
}

