/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.addons.noise.samplers.noise;

import com.dfsek.terra.addons.noise.lib.jafama.FastMath;
import com.dfsek.terra.addons.noise.samplers.noise.NoiseFunction;
import com.dfsek.terra.addons.noise.samplers.noise.random.WhiteNoiseSampler;

public class GaborNoiseSampler
extends NoiseFunction {
    private final WhiteNoiseSampler rand;
    private double k = 1.0;
    private double a = 0.1;
    private double f0 = 0.625;
    private double kernelRadius = FastMath.sqrt(-FastMath.log(0.05) / Math.PI) / this.a;
    private double impulsesPerKernel = 64.0;
    private double impulseDensity = this.impulsesPerKernel / (Math.PI * this.kernelRadius * this.kernelRadius);
    private double impulsesPerCell = this.impulseDensity * this.kernelRadius * this.kernelRadius;
    private double g = FastMath.exp(-this.impulsesPerCell);
    private double omega0 = 0.7853981633974483;
    private boolean isotropic = true;

    public GaborNoiseSampler() {
        this.rand = new WhiteNoiseSampler();
    }

    private void recalculateRadiusAndDensity() {
        this.kernelRadius = FastMath.sqrt(-FastMath.log(0.05) / Math.PI) / this.a;
        this.impulseDensity = this.impulsesPerKernel / (Math.PI * this.kernelRadius * this.kernelRadius);
        this.impulsesPerCell = this.impulseDensity * this.kernelRadius * this.kernelRadius;
        this.g = FastMath.exp(-this.impulsesPerCell);
    }

    private double gaborNoise(long seed, double x, double y) {
        int xi = GaborNoiseSampler.fastFloor(x /= this.kernelRadius);
        int yi = GaborNoiseSampler.fastFloor(y /= this.kernelRadius);
        double xf = x - (double)xi;
        double yf = y - (double)yi;
        double noise = 0.0;
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                noise += this.calculateCell(seed, xi + dx, yi + dz, xf - (double)dx, yf - (double)dz);
            }
        }
        return noise;
    }

    private double calculateCell(long seed, int xi, int yi, double x, double y) {
        long mashedSeed = GaborNoiseSampler.murmur64(31L * (long)xi + (long)yi) + seed;
        int impulses = 0;
        for (double gaussianSource = (this.rand.getNoiseRaw(mashedSeed++) + 1.0) / 2.0; gaussianSource > this.g; gaussianSource *= (this.rand.getNoiseRaw(mashedSeed++) + 1.0) / 2.0) {
            ++impulses;
        }
        double noise = 0.0;
        for (int i = 0; i < impulses; ++i) {
            noise += this.rand.getNoiseRaw(mashedSeed++) * this.gabor(this.isotropic ? (this.rand.getNoiseRaw(mashedSeed++) + 1.0) * Math.PI : this.omega0, x * this.kernelRadius, y * this.kernelRadius);
        }
        return noise;
    }

    private double gabor(double omega_0, double x, double y) {
        return this.k * (FastMath.exp(-Math.PI * (this.a * this.a) * (x * x + y * y)) * GaborNoiseSampler.fastCos(Math.PI * 2 * this.f0 * (x * GaborNoiseSampler.fastCos(omega_0) + y * GaborNoiseSampler.fastSin(omega_0))));
    }

    public void setA(double a) {
        this.a = a;
        this.recalculateRadiusAndDensity();
    }

    public void setDeviation(double k) {
        this.k = k;
    }

    public void setFrequency0(double f0) {
        this.f0 = f0;
    }

    public void setImpulsesPerKernel(double impulsesPerKernel) {
        this.impulsesPerKernel = impulsesPerKernel;
        this.recalculateRadiusAndDensity();
    }

    public void setIsotropic(boolean isotropic) {
        this.isotropic = isotropic;
    }

    public void setRotation(double omega0) {
        this.omega0 = Math.PI * omega0;
    }

    @Override
    public double getNoiseRaw(long seed, double x, double z) {
        return this.gaborNoise(seed, x, z);
    }

    @Override
    public double getNoiseRaw(long seed, double x, double y, double z) {
        return this.gaborNoise(seed, x, z);
    }
}

