/*
 * Decompiled with CFR 0.152.
 */
package com.dfsek.terra.addons.noise.samplers.noise.random;

import com.dfsek.terra.addons.noise.samplers.noise.NoiseFunction;

public class WhiteNoiseSampler
extends NoiseFunction {
    private static final long POSITIVE_POW1 = 0x3FF0000000000000L;

    public long randomBits(long seed, double x, double y, double z) {
        long hashX = Double.doubleToRawLongBits(x) ^ seed;
        long hashZ = Double.doubleToRawLongBits(y) ^ seed;
        long hash = ((hashX ^ hashX >>> 32) + ((hashZ ^ hashZ >>> 32) << 32) ^ seed) + Double.doubleToRawLongBits(z);
        return WhiteNoiseSampler.murmur64(hash);
    }

    public long randomBits(long seed, double x, double y) {
        long hashX = Double.doubleToRawLongBits(x) ^ seed;
        long hashZ = Double.doubleToRawLongBits(y) ^ seed;
        long hash = (hashX ^ hashX >>> 32) + ((hashZ ^ hashZ >>> 32) << 32) ^ seed;
        return WhiteNoiseSampler.murmur64(hash);
    }

    public double getNoiseRaw(long seed) {
        return (Double.longBitsToDouble(WhiteNoiseSampler.murmur64(seed) & 0xFFFFFFFFFFFFFL | 0x3FF0000000000000L) - 1.5) * 2.0;
    }

    @Override
    public double getNoiseRaw(long seed, double x, double y) {
        return (this.getNoiseUnmapped(seed, x, y) - 1.5) * 2.0;
    }

    @Override
    public double getNoiseRaw(long seed, double x, double y, double z) {
        return (this.getNoiseUnmapped(seed, x, y, z) - 1.5) * 2.0;
    }

    public double getNoiseUnmapped(long seed, double x, double y, double z) {
        long base = this.randomBits(seed, x, y, z) & 0xFFFFFFFFFFFFFL | 0x3FF0000000000000L;
        return Double.longBitsToDouble(base);
    }

    public double getNoiseUnmapped(long seed, double x, double y) {
        long base = this.randomBits(seed, x, y) & 0xFFFFFFFFFFFFFL | 0x3FF0000000000000L;
        return Double.longBitsToDouble(base);
    }
}

