/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.client.render.entity.renderer;

import com.mojang.datafixers.util.Pair;
import immersive_aircraft.client.render.entity.renderer.TrailRenderer;
import immersive_aircraft.entity.AircraftEntity;
import immersive_aircraft.entity.VehicleEntity;
import immersive_aircraft.resources.ObjectLoader;
import immersive_aircraft.util.obj.Face;
import immersive_aircraft.util.obj.FaceVertex;
import immersive_aircraft.util.obj.Mesh;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.class_1058;
import net.minecraft.class_1297;
import net.minecraft.class_1767;
import net.minecraft.class_1921;
import net.minecraft.class_238;
import net.minecraft.class_2582;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4604;
import net.minecraft.class_4608;
import net.minecraft.class_4722;
import net.minecraft.class_4730;
import net.minecraft.class_5321;
import net.minecraft.class_5617;
import net.minecraft.class_6880;
import net.minecraft.class_7833;
import net.minecraft.class_897;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public abstract class AircraftEntityRenderer<T extends AircraftEntity>
extends class_897<T> {
    public AircraftEntityRenderer(class_5617.class_5618 context) {
        super(context);
    }

    protected abstract Model getModel(AircraftEntity var1);

    protected abstract Vector3f getPivot(AircraftEntity var1);

    public void render(T entity, float yaw, float tickDelta, class_4587 matrixStack, class_4597 vertexConsumerProvider, int light) {
        class_4587.class_4665 peek = matrixStack.method_23760();
        matrixStack.method_22903();
        float h = (float)((VehicleEntity)((java.lang.Object)entity)).getDamageWobbleTicks() - tickDelta;
        float j = ((VehicleEntity)((java.lang.Object)entity)).getDamageWobbleStrength() - tickDelta;
        if (j < 0.0f) {
            j = 0.0f;
        }
        if (h > 0.0f) {
            matrixStack.method_22907(class_7833.field_40714.rotationDegrees(class_3532.method_15374((float)h) * h * j / 10.0f * (float)((VehicleEntity)((java.lang.Object)entity)).getDamageWobbleSide()));
        }
        Vector3f effect = entity.method_24828() ? new Vector3f(0.0f, 0.0f, 0.0f) : ((AircraftEntity)((java.lang.Object)entity)).getWindEffect();
        matrixStack.method_22907(class_7833.field_40716.rotationDegrees(-yaw));
        matrixStack.method_22907(class_7833.field_40714.rotationDegrees(entity.method_5695(tickDelta) + effect.z));
        matrixStack.method_22907(class_7833.field_40718.rotationDegrees(((VehicleEntity)((java.lang.Object)entity)).getRoll(tickDelta) + effect.x));
        Vector3f pivot = this.getPivot((AircraftEntity)((java.lang.Object)entity));
        matrixStack.method_46416(pivot.x, pivot.y, pivot.z);
        Model model = this.getModel((AircraftEntity)((java.lang.Object)entity));
        for (Object object : model.getObjects()) {
            if (object.getAnimationConsumer() != null) {
                matrixStack.method_22903();
                object.getAnimationConsumer().run(entity, yaw, tickDelta, matrixStack);
            }
            object.getRenderConsumer().run(vertexConsumerProvider, entity, matrixStack, light, tickDelta);
            if (object.getAnimationConsumer() == null) continue;
            matrixStack.method_22909();
        }
        ((AircraftEntity)((java.lang.Object)entity)).getTrails().forEach(t -> TrailRenderer.render(t, vertexConsumerProvider, peek));
        matrixStack.method_22909();
        super.method_3936(entity, yaw, tickDelta, matrixStack, vertexConsumerProvider, light);
    }

    protected static void renderObject(Mesh mesh, class_4587 matrixStack, class_4588 vertexConsumer, int light) {
        AircraftEntityRenderer.renderObject(mesh, matrixStack, vertexConsumer, light, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    protected static void renderObject(Mesh mesh, class_4587 matrixStack, class_4588 vertexConsumer, int light, float r, float g, float b, float a) {
        class_4587.class_4665 entry = matrixStack.method_23760();
        Matrix4f positionMatrix = entry.method_23761();
        Matrix3f normalMatrix = entry.method_23762();
        for (Face face : mesh.faces) {
            if (face.vertices.size() != 4) continue;
            for (FaceVertex v : face.vertices) {
                vertexConsumer.method_22918(positionMatrix, v.v.x, v.v.y, v.v.z).method_22915(r, g, b, a).method_22913(v.t.u, v.t.v).method_22922(class_4608.field_21444).method_22916(light).method_23763(normalMatrix, v.n.x, v.n.y, v.n.z).method_1344();
            }
        }
    }

    protected static void renderSailObject(Mesh mesh, class_4587 matrixStack, class_4588 vertexConsumer, int light, double time) {
        AircraftEntityRenderer.renderSailObject(mesh, matrixStack, vertexConsumer, light, time, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    protected static void renderSailObject(Mesh mesh, class_4587 matrixStack, class_4588 vertexConsumer, int light, double time, float r, float g, float b, float a) {
        class_4587.class_4665 entry = matrixStack.method_23760();
        Matrix4f positionMatrix = entry.method_23761();
        Matrix3f normalMatrix = entry.method_23762();
        for (Face face : mesh.faces) {
            if (face.vertices.size() != 4) continue;
            for (FaceVertex v : face.vertices) {
                double angle = (double)(v.v.x + v.v.z) + (double)v.v.y * 0.25 + time * 0.25;
                double scale = 0.05;
                float x = (float)((double)v.v.x + (Math.cos(angle) + Math.cos(angle * 1.7)) * scale * (double)v.c.r);
                float z = (float)((double)v.v.z + (Math.sin(angle) + Math.sin(angle * 1.7)) * scale * (double)v.c.r);
                vertexConsumer.method_22918(positionMatrix, x, v.v.y, z).method_22915(r, g, b, a).method_22913(v.t.u, v.t.v).method_22922(class_4608.field_21444).method_22916(light).method_23763(normalMatrix, v.n.x, v.n.y, v.n.z).method_1344();
            }
        }
    }

    protected static void renderBanner(class_4587 matrixStack, class_4597 vertexConsumers, int light, Mesh mesh, boolean isBanner, List<Pair<class_6880<class_2582>, class_1767>> patterns) {
        for (int i = 0; i < 17 && i < patterns.size(); ++i) {
            Pair<class_6880<class_2582>, class_1767> pair = patterns.get(i);
            float[] fs = ((class_1767)pair.getSecond()).method_7787();
            class_6880 bannerPattern = (class_6880)pair.getFirst();
            bannerPattern.method_40230().ifPresent(key -> {
                class_4730 spriteIdentifier = isBanner ? class_4722.method_33081((class_5321)key) : class_4722.method_33083((class_5321)key);
                class_4588 vertexConsumer = spriteIdentifier.method_24145(vertexConsumers, class_1921::method_23588);
                class_1058 sprite = spriteIdentifier.method_24148();
                class_4587.class_4665 entry = matrixStack.method_23760();
                Matrix4f positionMatrix = entry.method_23761();
                Matrix3f normalMatrix = entry.method_23762();
                for (Face face : mesh.faces) {
                    if (face.vertices.size() != 4) continue;
                    for (FaceVertex v : face.vertices) {
                        vertexConsumer.method_22918(positionMatrix, v.v.x, v.v.y, v.v.z).method_22915(fs[0], fs[1], fs[2], 1.0f).method_22913(v.t.u * (sprite.method_4577() - sprite.method_4594()) + sprite.method_4594(), v.t.v * (sprite.method_4575() - sprite.method_4593()) + sprite.method_4593()).method_22922(class_4608.field_21444).method_22916(light).method_23763(normalMatrix, v.n.x, v.n.y, v.n.z).method_1344();
                    }
                }
            });
        }
    }

    protected static Mesh getFaces(class_2960 id, String object) {
        return ObjectLoader.objects.get(id).get(object);
    }

    public boolean shouldRender(T entity, class_4604 frustum, double x, double y, double z) {
        if (!entity.method_5727(x, y, z)) {
            return false;
        }
        class_238 box = entity.method_5830().method_1014(2.5);
        return frustum.method_23093(box);
    }

    protected class Model {
        private final List<Object> objects = new LinkedList<Object>();

        public Model add(Object o) {
            this.objects.add(o);
            return this;
        }

        public List<Object> getObjects() {
            return this.objects;
        }
    }

    protected class Object {
        private final class_2960 id;
        private final String object;
        private AnimationConsumer<T> animationConsumer = null;
        private RenderConsumer<T> renderConsumer = (vertexConsumerProvider, entity, matrixStack, light, tickDelta) -> {
            class_2960 identifier = AircraftEntityRenderer.this.method_3931((class_1297)entity);
            class_4588 vertexConsumer = vertexConsumerProvider.getBuffer(class_1921.method_23576((class_2960)identifier));
            AircraftEntityRenderer.renderObject(this.getMesh(), matrixStack, vertexConsumer, light);
        };

        public Object(class_2960 id, String object) {
            this.id = id;
            this.object = object;
        }

        public Mesh getMesh() {
            Mesh mesh = AircraftEntityRenderer.getFaces(this.id, this.object);
            if (mesh == null) {
                throw new RuntimeException(String.format("Mesh %s in %s does not exist!", this.id, this.object));
            }
            return mesh;
        }

        public class_2960 getId() {
            return this.id;
        }

        public AnimationConsumer<T> getAnimationConsumer() {
            return this.animationConsumer;
        }

        public Object setAnimationConsumer(AnimationConsumer<T> animationConsumer) {
            this.animationConsumer = animationConsumer;
            return this;
        }

        public RenderConsumer<T> getRenderConsumer() {
            return this.renderConsumer;
        }

        public Object setRenderConsumer(RenderConsumer<T> renderConsumer) {
            this.renderConsumer = renderConsumer;
            return this;
        }

        public static interface AnimationConsumer<T> {
            public void run(T var1, float var2, float var3, class_4587 var4);
        }

        public static interface RenderConsumer<T> {
            public void run(class_4597 var1, T var2, class_4587 var3, int var4, float var5);
        }
    }
}

