/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.data;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import immersive_aircraft.Main;
import immersive_aircraft.entity.misc.AircraftBaseUpgradeRegistry;
import immersive_aircraft.item.upgrade.AircraftStat;
import immersive_aircraft.item.upgrade.AircraftUpgrade;
import immersive_aircraft.item.upgrade.AircraftUpgradeRegistry;
import java.util.Map;
import net.minecraft.class_1299;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_7923;

public class BaseStatDataLoader
extends class_4309 {
    public BaseStatDataLoader() {
        super(new Gson(), "aircraft_base_upgrades");
    }

    protected void apply(Map<class_2960, JsonElement> jsonMap, class_3300 manager, class_3695 profiler) {
        AircraftBaseUpgradeRegistry.INSTANCE.reset();
        jsonMap.forEach((identifier, jsonElement) -> {
            try {
                JsonObject jsonObject = jsonElement.getAsJsonObject();
                if (class_7923.field_41177.method_10250(identifier)) {
                    class_1299 type = (class_1299)class_7923.field_41177.method_10223(identifier);
                    AircraftUpgrade upgrade = new AircraftUpgrade();
                    for (String key : jsonObject.keySet()) {
                        AircraftStat stat = AircraftUpgradeRegistry.STATS.get(key);
                        if (stat == null) continue;
                        upgrade.set(stat, jsonObject.get(key).getAsFloat());
                    }
                    AircraftBaseUpgradeRegistry.INSTANCE.setUpgradeModifier(type, upgrade);
                }
            }
            catch (JsonParseException | IllegalArgumentException exception) {
                Main.LOGGER.error("Parsing error on aircraft base upgrade {}: {}", identifier, (Object)exception.getMessage());
            }
        });
    }
}

