/*
 * Decompiled with CFR 0.152.
 */
package com.nettakrim.signed_paintings;

import com.nettakrim.signed_paintings.commands.SignedPaintingsCommands;
import com.nettakrim.signed_paintings.gui.SignEditingInfo;
import com.nettakrim.signed_paintings.rendering.PaintingRenderer;
import com.nettakrim.signed_paintings.util.ImageManager;
import com.nettakrim.signed_paintings.util.URLAlias;
import com.nettakrim.signed_paintings.util.UploadManager;
import java.math.BigDecimal;
import java.math.RoundingMode;
import net.fabricmc.api.ClientModInitializer;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_8242;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignedPaintingsClient
implements ClientModInitializer {
    public static final String MODID = "signed_paintings";
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"signed_paintings");
    public static class_310 client;
    public static ImageManager imageManager;
    public static UploadManager uploadManager;
    public static PaintingRenderer paintingRenderer;
    public static SignEditingInfo currentSignEdit;
    public static final class_5251 textColor;
    public static final class_5251 nameTextColor;
    public static boolean renderSigns;
    public static boolean renderBanners;
    public static boolean renderShields;
    private static boolean loggingEnabled;

    public void onInitializeClient() {
        client = class_310.method_1551();
        imageManager = new ImageManager();
        imageManager.registerURLAlias(new URLAlias("https://i.imgur.com/", new String[]{"i.imgur.com/", "imgur.com/", "imgur:"}, ".png"));
        imageManager.registerURLAlias(new URLAlias("https://iili.io/", new String[]{"freeimage.host/i/", "iili:"}, ".png"));
        imageManager.registerAllowedDomain("https://i.imgur.com/");
        imageManager.registerAllowedDomain("https://iili.io/");
        imageManager.registerAllowedDomain("https://i.ibb.co/");
        paintingRenderer = new PaintingRenderer();
        renderSigns = true;
        renderBanners = true;
        renderShields = true;
        uploadManager = new UploadManager("c1802a39166b9d0");
        SignedPaintingsCommands.initialize();
    }

    public static String combineSignText(class_8242 text) {
        class_2561[] layers = text.method_49877(false);
        if (layers == null) {
            return "";
        }
        StringBuilder combined = new StringBuilder();
        for (class_2561 line : layers) {
            if (line == null) continue;
            combined.append(line.getString());
        }
        return combined.toString();
    }

    public static int getMaxFittingIndex(String reference, int budgetWidth, class_327 textRenderer) {
        int low = 0;
        int high = reference.length();
        int index = Integer.MAX_VALUE;
        while (low <= high) {
            int mid = low + (high - low) / 2;
            int currentWidth = textRenderer.method_1727(reference.substring(0, mid));
            if (currentWidth < budgetWidth) {
                low = mid + 1;
            } else if (currentWidth > budgetWidth) {
                high = mid - 1;
            } else if (currentWidth == budgetWidth) {
                return mid;
            }
            index = mid;
        }
        if (textRenderer.method_1727(reference.substring(0, index)) > budgetWidth) {
            --index;
        }
        return index;
    }

    public static String floatToStringDP(float d, int decimalPlace) {
        BigDecimal bd = new BigDecimal(d);
        bd = bd.setScale(decimalPlace, RoundingMode.HALF_UP);
        String s1 = bd.toString();
        String s2 = Float.toString(d);
        return s1.length() < s2.length() ? s1 : s2;
    }

    public static float roundFloatTo3DP(float value) {
        BigDecimal bd = new BigDecimal(value);
        bd = bd.setScale(3, RoundingMode.HALF_UP);
        BigDecimal bd2 = bd.setScale(2, RoundingMode.HALF_UP);
        double difference = Math.abs(bd.subtract(bd2).doubleValue());
        String s = bd.toString();
        if ((difference < 0.0011 || s.contains("00")) && !s.endsWith(".667") && !s.endsWith(".334")) {
            return bd2.floatValue();
        }
        return bd.floatValue();
    }

    public static void say(String key, Object ... args) {
        if (SignedPaintingsClient.client.field_1724 == null) {
            return;
        }
        class_5250 text = class_2561.method_43471((String)"signed_paintings.say").method_10862(class_2583.field_24360.method_27703(nameTextColor)).method_10852((class_2561)class_2561.method_43469((String)("signed_paintings." + key), (Object[])args).method_10862(class_2583.field_24360.method_27703(textColor)));
        SignedPaintingsClient.client.field_1724.method_43496((class_2561)text);
    }

    public static void sayStyled(String key, class_2583 style, Object ... args) {
        if (SignedPaintingsClient.client.field_1724 == null) {
            return;
        }
        class_5250 text = class_2561.method_43471((String)"signed_paintings.say").method_10862(style.method_27703(nameTextColor)).method_10852((class_2561)class_2561.method_43469((String)("signed_paintings." + key), (Object[])args).method_10862(class_2583.field_24360.method_27703(textColor)));
        SignedPaintingsClient.client.field_1724.method_43496((class_2561)text);
    }

    public static void say(class_5250 text) {
        if (SignedPaintingsClient.client.field_1724 == null) {
            return;
        }
        class_5250 newText = class_2561.method_43471((String)"signed_paintings.say").method_10862(class_2583.field_24360.method_27703(nameTextColor)).method_10852((class_2561)text.method_10862(text.method_10866().method_27703(textColor)));
        SignedPaintingsClient.client.field_1724.method_43496((class_2561)newText);
    }

    public static void sayRaw(class_5250 text) {
        if (SignedPaintingsClient.client.field_1724 == null) {
            return;
        }
        SignedPaintingsClient.client.field_1724.method_43496((class_2561)text);
    }

    public static void longSay(class_5250 text) {
        if (SignedPaintingsClient.client.field_1724 == null) {
            return;
        }
        class_5250 newText = class_2561.method_43471((String)"signed_paintings.long_say").method_10862(class_2583.field_24360.method_27703(nameTextColor)).method_10852((class_2561)text.method_10862(text.method_10866().method_27703(textColor)));
        SignedPaintingsClient.client.field_1724.method_43496((class_2561)newText);
    }

    public static String getScreenshotDirectory() {
        return SignedPaintingsClient.client.field_1697 + "\\screenshots\\";
    }

    public static void info(String s, boolean force) {
        if (loggingEnabled || force) {
            LOGGER.info(s);
        }
    }

    static {
        textColor = class_5251.method_27717((int)0xAAAAAA);
        nameTextColor = class_5251.method_27717((int)4967587);
        loggingEnabled = false;
    }
}

