/*
 * Decompiled with CFR 0.152.
 */
package com.nettakrim.signed_paintings.gui;

import com.nettakrim.signed_paintings.SignedPaintingsClient;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_357;
import org.apache.commons.lang3.StringUtils;

public class InputSlider {
    public final InputTextFieldWidget textFieldWidget;
    public final InputSliderWidget sliderWidget;
    private float value;
    private final float minValue;
    private final float maxValue;
    private static final Predicate<String> textPredicate = text -> StringUtils.countMatches((CharSequence)text, (char)'.') <= 1 && text.replaceAll("[^0-9.-]", "").length() == text.length();
    private Consumer<Float> onValueChanged;

    public InputSlider(int x, int y, int textWidth, int sliderWidth, int height, int elementSpacing, float minSlider, float maxSlider, float sliderStep, float startingValue, float minValue, float maxValue, class_2561 text) {
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.sliderWidget = this.createSlider(x, y, sliderWidth, height, text, minSlider, maxSlider, sliderStep);
        this.sliderWidget.setChangedListener(this::onSliderChanged);
        this.textFieldWidget = this.createTextField(x + textWidth + elementSpacing + 1, y + 1, textWidth - 2, height - 2);
        this.textFieldWidget.method_1863(this::onTextChanged);
        this.textFieldWidget.method_1890(textPredicate);
        this.setValue(startingValue);
    }

    private InputTextFieldWidget createTextField(int x, int y, int width, int height) {
        return new InputTextFieldWidget(SignedPaintingsClient.client.field_1772, x, y, width, height, (class_2561)class_2561.method_43470((String)"0"));
    }

    private InputSliderWidget createSlider(int x, int y, int width, int height, class_2561 text, float min, float max, float step) {
        return new InputSliderWidget(x, y, width, height, text, min, max, step, 0.5);
    }

    public void setOnValueChanged(Consumer<Float> onValueChanged) {
        this.onValueChanged = onValueChanged;
    }

    public boolean isFocused() {
        return this.textFieldWidget.method_25370() || this.sliderWidget.method_25370();
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.textFieldWidget.method_20315()) {
            return this.textFieldWidget.method_25404(keyCode, scanCode, modifiers);
        }
        if (this.sliderWidget.method_25370()) {
            return this.sliderWidget.method_25404(keyCode, scanCode, modifiers);
        }
        return false;
    }

    public boolean charTyped(char chr, int modifiers) {
        if (this.textFieldWidget.method_20315()) {
            return this.textFieldWidget.method_25400(chr, modifiers);
        }
        if (this.sliderWidget.method_25370()) {
            return this.sliderWidget.method_25400(chr, modifiers);
        }
        return false;
    }

    public void onTextChanged(String newValue) {
        try {
            this.value = class_3532.method_15363((float)Float.parseFloat(newValue), (float)this.minValue, (float)this.maxValue);
            if (this.onValueChanged != null) {
                this.onValueChanged.accept(Float.valueOf(this.value));
            }
            this.updateSlider();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void onSliderChanged(float newValue) {
        this.value = class_3532.method_15363((float)newValue, (float)this.minValue, (float)this.maxValue);
        if (this.onValueChanged != null) {
            this.onValueChanged.accept(Float.valueOf(this.value));
        }
        this.updateTextField();
    }

    public void setValue(float to) {
        this.value = class_3532.method_15363((float)to, (float)this.minValue, (float)this.maxValue);
        this.updateTextField();
        this.updateSlider();
    }

    private void updateSlider() {
        this.sliderWidget.setValue(this.value);
    }

    private void updateTextField() {
        this.textFieldWidget.method_1863(null);
        this.textFieldWidget.method_1852(Float.toString(this.value));
        this.textFieldWidget.method_1870();
        this.textFieldWidget.method_1863(this::onTextChanged);
    }

    public float getValue() {
        return this.value;
    }

    public static class InputSliderWidget
    extends class_357 {
        private final float min;
        private final float max;
        private final float step;
        private Consumer<Float> onChange;

        public InputSliderWidget(int x, int y, int width, int height, class_2561 text, float min, float max, float step, double value) {
            super(x, y, width, height, text, value);
            this.min = min;
            this.max = max;
            this.step = step;
        }

        public void setChangedListener(Consumer<Float> onChange) {
            this.onChange = onChange;
        }

        protected void method_25346() {
        }

        public boolean method_25404(int keyCode, int scanCode, int modifiers) {
            if (keyCode == 263 || keyCode == 262) {
                this.field_22753 = class_3532.method_15350((double)(this.field_22753 + (double)((keyCode == 263 ? -this.step : this.step) / (this.max - this.min))), (double)0.0, (double)1.0);
                this.method_25344();
                return true;
            }
            return super.method_25404(keyCode, scanCode, modifiers);
        }

        protected void method_25344() {
            float round = (this.max - this.min) / this.step;
            this.field_22753 = (float)Math.round(this.field_22753 * (double)round) / round;
            float result = (float)((double)this.min + (double)(this.max - this.min) * this.field_22753);
            BigDecimal bd = new BigDecimal(result);
            this.onChange.accept(Float.valueOf(bd.setScale(3, RoundingMode.HALF_UP).floatValue()));
        }

        public void setValue(float to) {
            to = (to - this.min) / (this.max - this.min);
            this.field_22753 = class_3532.method_15363((float)to, (float)0.0f, (float)1.0f);
            this.method_25346();
        }
    }

    public static class InputTextFieldWidget
    extends class_342 {
        public InputTextFieldWidget(class_327 textRenderer, int x, int y, int width, int height, class_2561 text) {
            super(textRenderer, x, y, width, height, text);
        }

        public boolean method_25404(int keyCode, int scanCode, int modifiers) {
            if (keyCode == 257) {
                this.method_25365(false);
                return true;
            }
            if (keyCode == 258) {
                return false;
            }
            return super.method_25404(keyCode, scanCode, modifiers);
        }
    }
}

