/*
 * Decompiled with CFR 0.152.
 */
package com.nettakrim.signed_paintings.rendering;

import com.nettakrim.signed_paintings.SignedPaintingsClient;
import com.nettakrim.signed_paintings.rendering.BackType;
import com.nettakrim.signed_paintings.rendering.Centering;
import com.nettakrim.signed_paintings.rendering.Cuboid;
import com.nettakrim.signed_paintings.rendering.SignType;
import com.nettakrim.signed_paintings.util.ImageData;
import net.minecraft.class_1058;
import net.minecraft.class_1091;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2478;
import net.minecraft.class_2586;
import net.minecraft.class_2625;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_773;

public class PaintingInfo {
    public class_2586 blockEntity;
    public Cuboid cuboid;
    private ImageData image;
    private class_1058 back;
    public SignType.Type signType;
    public float rotation;
    private float width;
    private float height;
    private float depth;
    private float xOffset;
    private float yOffset;
    private float zOffset;
    private Centering.Type xCentering;
    private Centering.Type yCentering;
    private BackType.Type backType;
    private float pixelsPerBlock;
    public boolean working;
    private boolean needsBackUpdate = false;

    public PaintingInfo(ImageData image, boolean isFront, class_2625 blockEntity) {
        this.blockEntity = blockEntity;
        this.image = image;
        this.signType = SignType.getType(blockEntity.method_11010().method_26204());
        this.rotation = isFront ? 0.0f : 180.0f;
        this.resetCuboid();
    }

    public void updateImage(ImageData image) {
        this.image = image;
        this.resetCuboid();
    }

    public void invalidateImage() {
        this.image = null;
    }

    public boolean isReady() {
        return this.image != null && this.image.ready;
    }

    public boolean needsReload() {
        return this.image != null && this.image.needsReload;
    }

    private void resetCuboid() {
        this.depth = 0.0625f;
        this.xCentering = Centering.Type.CENTER;
        this.yCentering = Centering.Type.CENTER;
        this.resetSize();
    }

    public void resetSize() {
        this.width = (float)this.image.width / 16.0f;
        this.height = (float)this.image.height / 16.0f;
        while (this.width > 8.0f || this.height > 8.0f) {
            this.width /= 2.0f;
            this.height /= 2.0f;
        }
        this.width = SignedPaintingsClient.roundFloatTo3DP(this.width);
        this.height = SignedPaintingsClient.roundFloatTo3DP(this.height);
        this.updateCuboid();
    }

    private void updateCuboid() {
        float reducedDepth = this.depth;
        if (this.backType == BackType.Type.NONE) {
            reducedDepth = 0.00390625f;
        }
        this.cuboid = switch (this.signType) {
            default -> throw new IncompatibleClassChangeError();
            case SignType.Type.WALL -> Cuboid.CreateWallCuboid(this.width, this.xCentering, this.height, this.yCentering, reducedDepth, this.xOffset, this.yOffset, this.zOffset);
            case SignType.Type.STANDING -> Cuboid.CreateFlushCuboid(this.width, this.xCentering, this.height, this.yCentering, reducedDepth, this.xOffset, this.yOffset, this.zOffset);
            case SignType.Type.HANGING, SignType.Type.WALL_HANGING -> Cuboid.CreateCentralCuboid(this.width, this.xCentering, this.height, this.yCentering, reducedDepth, this.xOffset, this.yOffset, this.zOffset);
        };
    }

    public void updateCuboidCentering(Centering.Type xCentering, Centering.Type yCentering) {
        this.xCentering = xCentering;
        this.yCentering = yCentering;
        this.updateCuboid();
    }

    public void updateCuboidSize(float xSize, float ySize) {
        this.width = xSize;
        this.height = ySize;
        this.updateCuboid();
    }

    public void updateCuboidOffset(float xOffset, float yOffset, float zOffset) {
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        this.zOffset = zOffset;
        this.updateCuboid();
    }

    public float getYOffset() {
        return this.yOffset;
    }

    public void updatePixelsPerBlock(float pixelsPerBlock) {
        this.pixelsPerBlock = pixelsPerBlock;
    }

    public float getPixelsPerBlock() {
        return this.pixelsPerBlock;
    }

    public void setBackType(BackType.Type backType) {
        this.backType = backType;
        this.updateBack();
        this.updateCuboid();
    }

    public BackType.Type getBackType() {
        return this.backType;
    }

    private void updateBack() {
        class_2680 blockState = null;
        if (this.backType == BackType.Type.BLOCK) {
            class_1937 world = this.blockEntity.method_10997();
            if (world == null) {
                world = SignedPaintingsClient.client.field_1687;
            }
            if (world == null) {
                this.needsBackUpdate = true;
                return;
            }
            class_2338 blockPos = this.blockEntity.method_11016();
            double rotation = ((class_2478)this.blockEntity.method_11010().method_26204()).method_49814(this.blockEntity.method_11010());
            blockPos = switch (this.signType) {
                default -> throw new IncompatibleClassChangeError();
                case SignType.Type.STANDING -> blockPos.method_10074();
                case SignType.Type.WALL -> blockPos.method_10079(class_2350.method_10150((double)(rotation + 180.0)), 1);
                case SignType.Type.HANGING -> blockPos.method_10084();
                case SignType.Type.WALL_HANGING -> this.getSolidWallHang(world, blockPos, class_2350.method_10150((double)(rotation + 90.0)));
            };
            blockState = world.method_8320(blockPos);
            if (blockState.method_27852(class_2246.field_10243)) {
                this.needsBackUpdate = true;
            }
        }
        if (blockState == null || blockState.method_26215()) {
            blockState = this.blockEntity.method_11010();
        }
        class_1058 back = null;
        if (this.backType == BackType.Type.SIGN) {
            String name = ((class_2478)this.blockEntity.method_11010().method_26204()).method_24025().comp_1299();
            back = (class_1058)SignedPaintingsClient.client.method_1549(new class_2960("minecraft", "textures/atlas/blocks.png")).apply(new class_2960("minecraft", "block/" + name + "_planks"));
        }
        class_1091 modelIdentifier = class_773.method_3340((class_2680)blockState);
        if (back == null) {
            back = SignedPaintingsClient.client.method_1554().method_4742(modelIdentifier).method_4711();
        }
        if (back == null) {
            back = SignedPaintingsClient.client.method_1554().method_4744().method_4711();
        }
        this.back = back;
    }

    private class_2338 getSolidWallHang(class_1937 world, class_2338 blockPos, class_2350 direction) {
        return blockPos.method_10079(direction, world.method_8320(blockPos.method_10079(direction, 1)).method_26215() ? -1 : 1);
    }

    public class_2960 getImageIdentifier() {
        if (this.pixelsPerBlock == 0.0f) {
            return this.image.getBaseIdentifier();
        }
        return this.image.getIdentifier(Math.round(this.width * this.pixelsPerBlock), Math.round(this.height * this.pixelsPerBlock), this.working);
    }

    public class_1058 getBackSprite() {
        if (this.needsBackUpdate || this.back == null) {
            this.updateBack();
        }
        return this.back;
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }
}

