/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.guidebook.scene.annotation;

import appeng.client.guidebook.color.MutableColor;
import appeng.client.guidebook.scene.annotation.InWorldAnnotation;
import appeng.client.guidebook.scene.annotation.InWorldBoxAnnotation;
import appeng.client.guidebook.scene.annotation.InWorldLineAnnotation;
import appeng.core.AppEng;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4668;
import net.minecraft.class_5253;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public final class InWorldAnnotationRenderer {
    private static final class_1921 OCCLUDED = class_1921.method_24049((String)"annotation_occluded", (class_293)class_290.field_1590, (class_293.class_5596)class_293.class_5596.field_27382, (int)0x100000, (boolean)false, (boolean)true, (class_1921.class_4688)class_1921.class_4688.method_23598().method_23608(class_1921.field_21383).method_34578(class_1921.field_29448).method_34577((class_4668.class_5939)class_4668.field_21376).method_23615(class_4668.field_21370).method_23604(new class_4668.class_4672(">", 516)).method_23616(class_4668.field_21350).method_23617(false));

    private InWorldAnnotationRenderer() {
    }

    public static void render(class_4597.class_4598 buffers, Iterable<InWorldAnnotation> annotations) {
        class_1058 sprite = (class_1058)class_310.method_1551().method_1549(class_1059.field_5275).apply(AppEng.makeId("block/noise"));
        class_4588 occludedConsumer = buffers.getBuffer(OCCLUDED);
        for (InWorldAnnotation annotation : annotations) {
            MutableColor color;
            if (annotation.isAlwaysOnTop()) continue;
            if (annotation instanceof InWorldBoxAnnotation) {
                InWorldBoxAnnotation boxAnnotation = (InWorldBoxAnnotation)annotation;
                color = MutableColor.of(boxAnnotation.color());
                color.darker(50.0f).setAlpha(color.alpha() * 0.5f);
                if (boxAnnotation.isHovered()) {
                    color.lighter(50.0f);
                }
                InWorldAnnotationRenderer.render(occludedConsumer, boxAnnotation.min(), boxAnnotation.max(), color.toArgb32(), boxAnnotation.thickness(), sprite);
                continue;
            }
            if (!(annotation instanceof InWorldLineAnnotation)) continue;
            InWorldLineAnnotation lineAnnotation = (InWorldLineAnnotation)annotation;
            color = MutableColor.of(lineAnnotation.color());
            color.darker(50.0f).setAlpha(color.alpha() * 0.5f);
            if (lineAnnotation.isHovered()) {
                color.lighter(50.0f);
            }
            InWorldAnnotationRenderer.strut(occludedConsumer, lineAnnotation.min(), lineAnnotation.max(), color.toArgb32(), lineAnnotation.thickness(), true, true, sprite);
        }
        buffers.method_22994(OCCLUDED);
        for (int pass = 1; pass <= 2; ++pass) {
            if (pass == 2) {
                RenderSystem.clear((int)256, (boolean)class_310.field_1703);
            }
            class_4588 consumer = buffers.getBuffer(class_1921.method_23583());
            for (InWorldAnnotation annotation : annotations) {
                MutableColor color;
                if (annotation.isAlwaysOnTop() != (pass == 2)) continue;
                if (annotation instanceof InWorldBoxAnnotation) {
                    InWorldBoxAnnotation boxAnnotation = (InWorldBoxAnnotation)annotation;
                    color = MutableColor.of(boxAnnotation.color());
                    if (boxAnnotation.isHovered()) {
                        color.lighter(50.0f);
                    }
                    InWorldAnnotationRenderer.render(consumer, boxAnnotation.min(), boxAnnotation.max(), color.toArgb32(), boxAnnotation.thickness(), sprite);
                    continue;
                }
                if (!(annotation instanceof InWorldLineAnnotation)) continue;
                InWorldLineAnnotation lineAnnotation = (InWorldLineAnnotation)annotation;
                color = MutableColor.of(lineAnnotation.color());
                if (lineAnnotation.isHovered()) {
                    color.lighter(50.0f);
                }
                InWorldAnnotationRenderer.strut(consumer, lineAnnotation.min(), lineAnnotation.max(), color.toArgb32(), lineAnnotation.thickness(), true, true, sprite);
            }
            buffers.method_22994(class_1921.method_23583());
        }
        buffers.method_22993();
    }

    public static void render(class_4588 consumer, Vector3f min, Vector3f max, int color, float thickness, class_1058 sprite) {
        float thickHalf = thickness * 0.5f;
        Vector3f u = new Vector3f(max.x - min.x, 0.0f, 0.0f);
        Vector3f v = new Vector3f(0.0f, max.y - min.y, 0.0f);
        Vector3f t = new Vector3f(0.0f, 0.0f, max.z - min.z);
        Vector3f uNorm = new Vector3f((Vector3fc)u).normalize();
        Vector3f vNorm = new Vector3f((Vector3fc)v).normalize();
        Vector3f tNorm = new Vector3f((Vector3fc)t).normalize();
        Vector3f[] corners = new Vector3f[]{new Vector3f((Vector3fc)min), new Vector3f((Vector3fc)min).add((Vector3fc)u), new Vector3f((Vector3fc)min).add((Vector3fc)v), new Vector3f((Vector3fc)min).add((Vector3fc)t), new Vector3f((Vector3fc)max), new Vector3f((Vector3fc)max).sub((Vector3fc)u), new Vector3f((Vector3fc)max).sub((Vector3fc)v), new Vector3f((Vector3fc)max).sub((Vector3fc)t)};
        InWorldAnnotationRenderer.strut(consumer, new Vector3f((Vector3fc)uNorm).mulAdd(-thickHalf, (Vector3fc)corners[0]), new Vector3f((Vector3fc)uNorm).mulAdd(thickHalf, (Vector3fc)corners[1]), color, thickness, true, true, sprite);
        InWorldAnnotationRenderer.strut(consumer, new Vector3f((Vector3fc)uNorm).mulAdd(-thickHalf, (Vector3fc)corners[2]), new Vector3f((Vector3fc)uNorm).mulAdd(thickHalf, (Vector3fc)corners[7]), color, thickness, true, true, sprite);
        InWorldAnnotationRenderer.strut(consumer, new Vector3f((Vector3fc)uNorm).mulAdd(-thickHalf, (Vector3fc)corners[3]), new Vector3f((Vector3fc)uNorm).mulAdd(thickHalf, (Vector3fc)corners[6]), color, thickness, true, true, sprite);
        InWorldAnnotationRenderer.strut(consumer, new Vector3f((Vector3fc)uNorm).mulAdd(-thickHalf, (Vector3fc)corners[5]), new Vector3f((Vector3fc)uNorm).mulAdd(thickHalf, (Vector3fc)corners[4]), color, thickness, true, true, sprite);
        InWorldAnnotationRenderer.strut(consumer, new Vector3f((Vector3fc)vNorm).mulAdd(thickHalf, (Vector3fc)corners[0]), new Vector3f((Vector3fc)vNorm).mulAdd(-thickHalf, (Vector3fc)corners[2]), color, thickness, false, false, sprite);
        InWorldAnnotationRenderer.strut(consumer, new Vector3f((Vector3fc)vNorm).mulAdd(thickHalf, (Vector3fc)corners[1]), new Vector3f((Vector3fc)vNorm).mulAdd(-thickHalf, (Vector3fc)corners[7]), color, thickness, false, false, sprite);
        InWorldAnnotationRenderer.strut(consumer, new Vector3f((Vector3fc)vNorm).mulAdd(thickHalf, (Vector3fc)corners[3]), new Vector3f((Vector3fc)vNorm).mulAdd(-thickHalf, (Vector3fc)corners[5]), color, thickness, false, false, sprite);
        InWorldAnnotationRenderer.strut(consumer, new Vector3f((Vector3fc)vNorm).mulAdd(thickHalf, (Vector3fc)corners[6]), new Vector3f((Vector3fc)vNorm).mulAdd(-thickHalf, (Vector3fc)corners[4]), color, thickness, false, false, sprite);
        InWorldAnnotationRenderer.strut(consumer, new Vector3f((Vector3fc)tNorm).mulAdd(thickHalf, (Vector3fc)corners[0]), new Vector3f((Vector3fc)tNorm).mulAdd(-thickHalf, (Vector3fc)corners[3]), color, thickness, false, false, sprite);
        InWorldAnnotationRenderer.strut(consumer, new Vector3f((Vector3fc)tNorm).mulAdd(thickHalf, (Vector3fc)corners[1]), new Vector3f((Vector3fc)tNorm).mulAdd(-thickHalf, (Vector3fc)corners[6]), color, thickness, false, false, sprite);
        InWorldAnnotationRenderer.strut(consumer, new Vector3f((Vector3fc)tNorm).mulAdd(thickHalf, (Vector3fc)corners[2]), new Vector3f((Vector3fc)tNorm).mulAdd(-thickHalf, (Vector3fc)corners[5]), color, thickness, false, false, sprite);
        InWorldAnnotationRenderer.strut(consumer, new Vector3f((Vector3fc)tNorm).mulAdd(thickHalf, (Vector3fc)corners[7]), new Vector3f((Vector3fc)tNorm).mulAdd(-thickHalf, (Vector3fc)corners[4]), color, thickness, false, false, sprite);
    }

    private static void strut(class_4588 consumer, Vector3f from, Vector3f to, int color, float thickness, boolean startCap, boolean endCap, class_1058 sprite) {
        Vector3f norm = new Vector3f((Vector3fc)to).sub((Vector3fc)from).normalize();
        Vector3f prefUp = Math.abs(from.x - to.x) < 0.01f && Math.abs(from.z - to.z) < 0.01f ? new Vector3f(1.0f, 0.0f, 0.0f) : new Vector3f(0.0f, 1.0f, 0.0f);
        Vector3f rightNorm = new Vector3f((Vector3fc)norm).cross((Vector3fc)prefUp).normalize();
        Vector3f leftNorm = new Vector3f((Vector3fc)rightNorm).negate();
        Vector3f upNorm = new Vector3f((Vector3fc)rightNorm).cross((Vector3fc)norm).normalize();
        Vector3f downNorm = new Vector3f((Vector3fc)upNorm).negate();
        Vector3f up = new Vector3f((Vector3fc)upNorm).mul(thickness * 0.5f);
        Vector3f right = new Vector3f((Vector3fc)rightNorm).mul(thickness * 0.5f);
        if (startCap) {
            InWorldAnnotationRenderer.quad(consumer, downNorm, color, new Vector3f((Vector3fc)from).add((Vector3fc)up).sub((Vector3fc)right), new Vector3f((Vector3fc)from).sub((Vector3fc)up).sub((Vector3fc)right), new Vector3f((Vector3fc)from).sub((Vector3fc)up).add((Vector3fc)right), new Vector3f((Vector3fc)from).add((Vector3fc)up).add((Vector3fc)right), sprite);
        }
        if (endCap) {
            InWorldAnnotationRenderer.quad(consumer, norm, color, new Vector3f((Vector3fc)to).add((Vector3fc)up).add((Vector3fc)right), new Vector3f((Vector3fc)to).sub((Vector3fc)up).add((Vector3fc)right), new Vector3f((Vector3fc)to).sub((Vector3fc)up).sub((Vector3fc)right), new Vector3f((Vector3fc)to).add((Vector3fc)up).sub((Vector3fc)right), sprite);
        }
        InWorldAnnotationRenderer.quad(consumer, leftNorm, color, new Vector3f((Vector3fc)from).sub((Vector3fc)right).add((Vector3fc)up), new Vector3f((Vector3fc)to).sub((Vector3fc)right).add((Vector3fc)up), new Vector3f((Vector3fc)to).sub((Vector3fc)right).sub((Vector3fc)up), new Vector3f((Vector3fc)from).sub((Vector3fc)right).sub((Vector3fc)up), sprite);
        InWorldAnnotationRenderer.quad(consumer, rightNorm, color, new Vector3f((Vector3fc)to).add((Vector3fc)right).sub((Vector3fc)up), new Vector3f((Vector3fc)to).add((Vector3fc)right).add((Vector3fc)up), new Vector3f((Vector3fc)from).add((Vector3fc)right).add((Vector3fc)up), new Vector3f((Vector3fc)from).add((Vector3fc)right).sub((Vector3fc)up), sprite);
        InWorldAnnotationRenderer.quad(consumer, upNorm, color, new Vector3f((Vector3fc)from).add((Vector3fc)up).sub((Vector3fc)right), new Vector3f((Vector3fc)from).add((Vector3fc)up).add((Vector3fc)right), new Vector3f((Vector3fc)to).add((Vector3fc)up).add((Vector3fc)right), new Vector3f((Vector3fc)to).add((Vector3fc)up).sub((Vector3fc)right), sprite);
        InWorldAnnotationRenderer.quad(consumer, downNorm, color, new Vector3f((Vector3fc)to).sub((Vector3fc)up).sub((Vector3fc)right), new Vector3f((Vector3fc)to).sub((Vector3fc)up).add((Vector3fc)right), new Vector3f((Vector3fc)from).sub((Vector3fc)up).add((Vector3fc)right), new Vector3f((Vector3fc)from).sub((Vector3fc)up).sub((Vector3fc)right), sprite);
    }

    private static void quad(class_4588 consumer, Vector3f faceNormal, int color, Vector3f v1, Vector3f v2, Vector3f v3, Vector3f v4, class_1058 sprite) {
        class_2350 d = class_2350.method_10147((float)faceNormal.x, (float)faceNormal.y, (float)faceNormal.z);
        float shade = switch (d) {
            case class_2350.field_11033 -> 0.5f;
            case class_2350.field_11043, class_2350.field_11035 -> 0.8f;
            case class_2350.field_11039, class_2350.field_11034 -> 0.6f;
            default -> 1.0f;
        };
        color = class_5253.class_5254.method_27763((int)class_5253.class_5254.method_27764((int)255, (int)((int)(shade * 255.0f)), (int)((int)(shade * 255.0f)), (int)((int)(shade * 255.0f))), (int)color);
        InWorldAnnotationRenderer.vertex(consumer, faceNormal, color, v1, sprite.method_4594(), sprite.method_4575());
        InWorldAnnotationRenderer.vertex(consumer, faceNormal, color, v2, sprite.method_4594(), sprite.method_4593());
        InWorldAnnotationRenderer.vertex(consumer, faceNormal, color, v3, sprite.method_4577(), sprite.method_4593());
        InWorldAnnotationRenderer.vertex(consumer, faceNormal, color, v4, sprite.method_4577(), sprite.method_4575());
    }

    private static void vertex(class_4588 consumer, Vector3f faceNormal, int color, Vector3f bottomLeft, float u, float v) {
        consumer.method_22912((double)bottomLeft.x, (double)bottomLeft.y, (double)bottomLeft.z).method_39415(color).method_22913(u, v).method_22916(0xF000F0).method_22914(faceNormal.x(), faceNormal.y(), faceNormal.z()).method_1344();
    }
}

