/*
 * Decompiled with CFR 0.152.
 */
package appeng.crafting.pattern;

import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import java.util.LinkedHashMap;
import java.util.Map;

final class AEPatternHelper {
    private AEPatternHelper() {
    }

    public static GenericStack[] condenseStacks(GenericStack[] sparseInput) {
        LinkedHashMap<AEKey, Long> map = new LinkedHashMap<AEKey, Long>();
        for (GenericStack input : sparseInput) {
            if (input == null) continue;
            map.merge(input.what(), input.amount(), Long::sum);
        }
        if (map.isEmpty()) {
            throw new IllegalStateException("No pattern here!");
        }
        GenericStack[] out = new GenericStack[map.size()];
        int i = 0;
        for (Map.Entry entry : map.entrySet()) {
            out[i++] = new GenericStack((AEKey)entry.getKey(), (Long)entry.getValue());
        }
        return out;
    }
}

