/*
 * Decompiled with CFR 0.152.
 */
package appeng.crafting.pattern;

import appeng.api.stacks.GenericStack;
import com.google.common.base.Preconditions;
import java.util.Objects;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3955;

class CraftingPatternEncoding {
    private static final String NBT_INPUTS = "in";
    private static final String NBT_OUTPUTS = "out";
    private static final String NBT_SUBSITUTE = "substitute";
    private static final String NBT_SUBSITUTE_FLUIDS = "substituteFluids";
    private static final String NBT_RECIPE_ID = "recipe";

    CraftingPatternEncoding() {
    }

    public static GenericStack[] getCraftingInputs(class_2487 nbt) {
        Objects.requireNonNull(nbt, "Pattern must have a tag.");
        class_2499 tag = nbt.method_10554(NBT_INPUTS, 10);
        Preconditions.checkArgument((tag.size() <= 9 ? 1 : 0) != 0, (Object)"Cannot use more than 9 ingredients");
        GenericStack[] result = new GenericStack[tag.size()];
        for (int x = 0; x < tag.size(); ++x) {
            class_2487 ingredientTag = tag.method_10602(x);
            if (ingredientTag.method_33133()) continue;
            result[x] = GenericStack.fromItemStack(class_1799.method_7915((class_2487)ingredientTag));
        }
        return result;
    }

    public static boolean canSubstitute(class_2487 nbt) {
        Objects.requireNonNull(nbt, "Pattern must have a tag.");
        return nbt.method_10577(NBT_SUBSITUTE);
    }

    public static boolean canSubstituteFluids(class_2487 nbt) {
        Objects.requireNonNull(nbt, "Pattern must have a tag.");
        return nbt.method_10577(NBT_SUBSITUTE_FLUIDS);
    }

    public static class_2960 getRecipeId(class_2487 nbt) {
        Objects.requireNonNull(nbt, "Pattern must have a tag.");
        return new class_2960(nbt.method_10558(NBT_RECIPE_ID));
    }

    public static class_1799 getCraftingResult(class_2487 nbt) {
        Objects.requireNonNull(nbt, "Pattern must have a tag.");
        return class_1799.method_7915((class_2487)nbt.method_10562(NBT_OUTPUTS));
    }

    public static void encodeCraftingPattern(class_2487 tag, class_3955 recipe, class_1799[] sparseInputs, class_1799 output, boolean allowSubstitution, boolean allowFluidSubstitution) {
        tag.method_10566(NBT_INPUTS, (class_2520)CraftingPatternEncoding.encodeItemStackList(sparseInputs));
        tag.method_10556(NBT_SUBSITUTE, allowSubstitution);
        tag.method_10556(NBT_SUBSITUTE_FLUIDS, allowFluidSubstitution);
        tag.method_10566(NBT_OUTPUTS, (class_2520)output.method_7953(new class_2487()));
        tag.method_10582(NBT_RECIPE_ID, recipe.method_8114().toString());
    }

    private static class_2499 encodeItemStackList(class_1799[] stacks) {
        class_2499 tag = new class_2499();
        boolean foundStack = false;
        for (class_1799 stack : stacks) {
            if (stack.method_7960()) {
                tag.add((Object)new class_2487());
                continue;
            }
            tag.add((Object)stack.method_7953(new class_2487()));
            foundStack = true;
        }
        Preconditions.checkArgument((boolean)foundStack, (Object)"List passed to pattern must contain at least one stack.");
        return tag;
    }
}

