/*
 * Decompiled with CFR 0.152.
 */
package appeng.datagen.providers.loot;

import appeng.core.AppEng;
import appeng.core.definitions.AEBlocks;
import appeng.core.definitions.AEItems;
import appeng.core.definitions.BlockDefinition;
import appeng.datagen.providers.IAE2DataProvider;
import appeng.datagen.providers.tags.ConventionTags;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.class_104;
import net.minecraft.class_117;
import net.minecraft.class_141;
import net.minecraft.class_173;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_201;
import net.minecraft.class_2248;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_44;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_55;
import net.minecraft.class_5658;
import net.minecraft.class_5662;
import net.minecraft.class_7403;
import net.minecraft.class_7699;
import net.minecraft.class_77;
import net.minecraft.class_7784;
import net.minecraft.class_7788;
import net.minecraft.class_79;
import net.minecraft.class_7923;
import net.minecraft.class_8490;
import net.minecraft.class_85;
import net.minecraft.class_91;
import net.minecraft.class_94;
import org.jetbrains.annotations.NotNull;

public class BlockDropProvider
extends class_7788
implements IAE2DataProvider {
    private final Map<class_2248, Function<class_2248, class_52.class_53>> overrides = this.createOverrides();
    private final Path outputFolder;

    @NotNull
    private ImmutableMap<class_2248, Function<class_2248, class_52.class_53>> createOverrides() {
        return ImmutableMap.builder().put((Object)AEBlocks.MATRIX_FRAME.block(), $ -> class_52.method_324()).put((Object)AEBlocks.MYSTERIOUS_CUBE.block(), BlockDropProvider::mysteriousCube).put((Object)AEBlocks.FLAWLESS_BUDDING_QUARTZ.block(), this.flawlessBuddingQuartz()).put((Object)AEBlocks.FLAWED_BUDDING_QUARTZ.block(), this.buddingQuartz(AEBlocks.CHIPPED_BUDDING_QUARTZ)).put((Object)AEBlocks.CHIPPED_BUDDING_QUARTZ.block(), this.buddingQuartz(AEBlocks.DAMAGED_BUDDING_QUARTZ)).put((Object)AEBlocks.DAMAGED_BUDDING_QUARTZ.block(), this.buddingQuartz(AEBlocks.QUARTZ_BLOCK)).put((Object)AEBlocks.SMALL_QUARTZ_BUD.block(), this::quartzBud).put((Object)AEBlocks.MEDIUM_QUARTZ_BUD.block(), this::quartzBud).put((Object)AEBlocks.LARGE_QUARTZ_BUD.block(), this::quartzBud).put((Object)AEBlocks.QUARTZ_CLUSTER.block(), BlockDropProvider::quartzCluster).build();
    }

    public BlockDropProvider(class_7784 output) {
        super(Set.of(), class_7699.method_45397());
        this.outputFolder = output.method_45971();
    }

    public void method_10379() {
    }

    public void method_10399(BiConsumer<class_2960, class_52.class_53> biConsumer) {
        super.method_10399(biConsumer);
    }

    public CompletableFuture<?> method_10319(class_7403 cache) {
        ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>();
        for (Map.Entry entry : class_7923.field_41175.method_29722()) {
            if (!((class_5321)entry.getKey()).method_29177().method_12836().equals("ae2")) continue;
            class_52.class_53 builder = this.overrides.getOrDefault(entry.getValue(), this::defaultBuilder).apply((class_2248)entry.getValue());
            futures.add(class_2405.method_10320((class_7403)cache, (JsonElement)this.toJson(builder), (Path)this.getPath(this.outputFolder, ((class_5321)entry.getKey()).method_29177())));
        }
        futures.add(class_2405.method_10320((class_7403)cache, (JsonElement)this.toJson(class_52.method_324().method_336(class_55.method_347().method_352((class_5658)class_5662.method_32462((float)1.0f, (float)3.0f)).method_351((class_79.class_80)class_77.method_411(AEBlocks.SKY_STONE_BLOCK)))), (Path)this.getPath(this.outputFolder, AppEng.makeId("chests/meteorite"))));
        return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
    }

    private class_52.class_53 defaultBuilder(class_2248 block) {
        class_85.class_86 entry = class_77.method_411((class_1935)block);
        class_55.class_56 pool = class_55.method_347().method_352((class_5658)class_44.method_32448((float)1.0f)).method_351((class_79.class_80)entry).method_356(class_201.method_871());
        return class_52.method_324().method_336(pool);
    }

    private Function<class_2248, class_52.class_53> flawlessBuddingQuartz() {
        return b -> this.method_45976((class_1935)AEBlocks.FLAWED_BUDDING_QUARTZ.block());
    }

    private Function<class_2248, class_52.class_53> buddingQuartz(BlockDefinition<?> degradedVersion) {
        return b -> this.method_45983((class_2248)b, degradedVersion);
    }

    private class_52.class_53 quartzBud(class_2248 bud) {
        return this.method_45983(bud, AEItems.CERTUS_QUARTZ_DUST);
    }

    private static class_52.class_53 quartzCluster(class_2248 cluster) {
        return BlockDropProvider.method_45989((class_2248)cluster, (class_79.class_80)class_77.method_411(AEItems.CERTUS_QUARTZ_CRYSTAL).method_438((class_117.class_118)class_141.method_621((class_5658)class_44.method_32448((float)4.0f))).method_438((class_117.class_118)class_94.method_456((class_1887)class_1893.field_9130)).method_438((class_117.class_118)class_104.method_478()));
    }

    private static class_52.class_53 mysteriousCube(class_2248 block) {
        return BlockDropProvider.method_45989((class_2248)block, (class_79.class_80)class_91.method_35517(ConventionTags.INSCRIBER_PRESSES).method_421(class_201.method_871()));
    }

    private Path getPath(Path root, class_2960 id) {
        return root.resolve("data/" + id.method_12836() + "/loot_tables/blocks/" + id.method_12832() + ".json");
    }

    public JsonElement toJson(class_52.class_53 builder) {
        return class_8490.field_44498.method_51203().toJsonTree((Object)this.finishBuilding(builder));
    }

    public class_52 finishBuilding(class_52.class_53 builder) {
        return builder.method_334(class_173.field_1172).method_338();
    }

    public String method_10321() {
        return "Applied Energistics 2 Block Drops";
    }
}

