/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.jei;

import appeng.api.stacks.GenericStack;
import appeng.client.gui.AEBaseScreen;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.InventoryActionPacket;
import appeng.helpers.InventoryAction;
import appeng.integration.modules.jei.GenericEntryStackHelper;
import appeng.menu.AEBaseMenu;
import appeng.menu.slot.AppEngSlot;
import appeng.menu.slot.FakeSlot;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_768;
import org.jetbrains.annotations.Nullable;

class GhostIngredientHandler
implements IGhostIngredientHandler<AEBaseScreen> {
    GhostIngredientHandler() {
    }

    public <I> List<IGhostIngredientHandler.Target<I>> getTargetsTyped(AEBaseScreen gui, ITypedIngredient<I> ingredient, boolean doStart) {
        class_1799 wrapped = GhostIngredientHandler.wrapDraggedItem(ingredient.getType(), ingredient.getIngredient());
        if (wrapped == null) {
            return Collections.emptyList();
        }
        ArrayList<IGhostIngredientHandler.Target<I>> targets = new ArrayList<IGhostIngredientHandler.Target<I>>();
        GhostIngredientHandler.addItemStackTargets(gui, targets, wrapped, ingredient.getType());
        return targets;
    }

    @Nullable
    private static <T> class_1799 wrapDraggedItem(IIngredientType<T> type, T ingredient) {
        return VanillaTypes.ITEM_STACK.castIngredient(ingredient).or(() -> {
            GenericStack genericStack = GenericEntryStackHelper.ingredientToStack(type, ingredient);
            if (genericStack != null) {
                return Optional.of(GenericStack.wrapInItemStack(genericStack));
            }
            return Optional.empty();
        }).orElse(null);
    }

    private static <I> void addItemStackTargets(AEBaseScreen<?> gui, List<IGhostIngredientHandler.Target<I>> targets, class_1799 draggedStack, IIngredientType<I> type) {
        for (class_1735 slot : ((AEBaseMenu)gui.method_17577()).field_7761) {
            FakeSlot fakeSlot;
            if (!slot.method_7682() || !(slot instanceof FakeSlot) || !(fakeSlot = (FakeSlot)slot).canSetFilterTo(draggedStack)) continue;
            targets.add(new ItemSlotTarget<I>(type, gui, fakeSlot));
        }
    }

    public void onComplete() {
    }

    private static class ItemSlotTarget<I>
    implements IGhostIngredientHandler.Target<I> {
        private final IIngredientType<I> type;
        private final AppEngSlot slot;
        private final class_768 area;

        public ItemSlotTarget(IIngredientType<I> type, AEBaseScreen<?> screen, AppEngSlot slot) {
            this.type = type;
            this.slot = slot;
            this.area = new class_768(screen.getGuiLeft() + slot.field_7873, screen.getGuiTop() + slot.field_7872, 16, 16);
        }

        public class_768 getArea() {
            return this.area;
        }

        public void accept(I ingredient) {
            class_1799 wrapped = GhostIngredientHandler.wrapDraggedItem(this.type, ingredient);
            if (wrapped != null) {
                NetworkHandler.instance().sendToServer(new InventoryActionPacket(InventoryAction.SET_FILTER, this.slot.field_7874, wrapped));
            }
        }
    }
}

