/*
 * Decompiled with CFR 0.152.
 */
package appeng.recipes.entropy;

import appeng.recipes.entropy.PropertyUtils;
import appeng.recipes.entropy.StateMatcher;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2540;
import net.minecraft.class_2688;
import net.minecraft.class_2689;
import net.minecraft.class_2769;

class SingleValueMatcher<T extends Comparable<T>>
implements StateMatcher {
    private final class_2769<T> property;
    private final T value;

    private SingleValueMatcher(class_2769<T> property, String value) {
        this.property = Objects.requireNonNull(property, "property must not be null");
        this.value = PropertyUtils.getRequiredPropertyValue(property, value);
    }

    @Override
    public boolean matches(class_2688<?, ?> state) {
        return this.value.equals(state.method_11654(this.property));
    }

    @Override
    public void writeToPacket(class_2540 buffer) {
        buffer.method_10817((Enum)StateMatcher.MatcherType.SINGLE);
        buffer.method_10814(this.property.method_11899());
        buffer.method_10814(this.property.method_11901(this.value));
    }

    public String getValueName() {
        return this.property.method_11901(this.value);
    }

    public class_2769<T> getProperty() {
        return this.property;
    }

    public static SingleValueMatcher<?> create(class_2689<?, ?> stateDefinition, String propertyName, String value) {
        class_2769<?> property = PropertyUtils.getRequiredProperty(stateDefinition, propertyName);
        return new SingleValueMatcher(property, value);
    }

    @Environment(value=EnvType.CLIENT)
    public static SingleValueMatcher<?> readFromPacket(class_2689<?, ?> stateDefinition, class_2540 buffer) {
        String propertyName = buffer.method_19772();
        String value = buffer.method_19772();
        return SingleValueMatcher.create(stateDefinition, propertyName, value);
    }
}

