/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.client.music;

import dev.felnull.imp.client.music.LoadCompleteListener;
import dev.felnull.imp.client.music.MusicEngine;
import dev.felnull.imp.client.music.loader.IMPMusicLoaders;
import dev.felnull.imp.client.music.loader.MusicLoader;
import dev.felnull.imp.client.music.player.MusicLoadChunk;
import dev.felnull.imp.client.music.player.MusicPlayer;
import dev.felnull.imp.client.music.speaker.MusicSpeaker;
import dev.felnull.imp.client.music.task.MusicDestroyRunner;
import dev.felnull.imp.client.music.task.MusicLoaderDestroyRunner;
import dev.felnull.imp.music.resource.MusicSource;
import dev.felnull.imp.music.tracker.MusicTracker;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;

public class MusicEntry {
    private final Map<UUID, MusicTracker> reserveTrackers = new HashMap<UUID, MusicTracker>();
    private final AtomicReference<MusicPlayer<?, ?>> musicPlayer = new AtomicReference();
    private final MusicSource source;
    private final long startPosition;
    private final UUID musicPlayerId;
    private boolean loaded;
    private boolean stopped;
    private boolean loadFailed;

    public float getCurrentPositionProgress() {
        if (this.source.isLive()) {
            return 0.0f;
        }
        return (float)this.getCurrentPosition() / (float)this.source.getDuration();
    }

    protected MusicPlayer<?, ?> getMusicPlayer() {
        return this.musicPlayer.get();
    }

    protected int getTaskCount() {
        if (this.musicPlayer.get() != null) {
            return this.musicPlayer.get().getTaskCount();
        }
        return 0;
    }

    protected MusicEntry(UUID musicPlayerId, MusicSource source, long position) {
        this.musicPlayerId = musicPlayerId;
        this.source = source;
        this.startPosition = position;
    }

    public MusicSource getSource() {
        return this.source;
    }

    public long getStartPosition() {
        return this.startPosition;
    }

    public List<MusicLoadChunk> getLoadChunks() {
        if (this.musicPlayer.get() != null) {
            return this.musicPlayer.get().getLoadChunks();
        }
        return new ArrayList<MusicLoadChunk>();
    }

    public int getChannels() {
        if (this.musicPlayer.get() != null) {
            return this.musicPlayer.get().getAudioInfo().channel();
        }
        return 0;
    }

    public long getCurrentPosition() {
        long pos;
        if (this.musicPlayer.get() != null && (pos = this.musicPlayer.get().getPosition()) >= 0L) {
            return pos;
        }
        return this.startPosition;
    }

    public float getCurrentAudioWave(int channel) {
        if (this.musicPlayer.get() != null) {
            return this.musicPlayer.get().getCurrentAudioWave(channel);
        }
        return 0.0f;
    }

    protected void playStart(long delay) {
        this.musicPlayer.get().play(delay);
    }

    protected boolean tick() {
        if (this.loadFailed) {
            this.destroy();
            return false;
        }
        if (this.musicPlayer.get() != null) {
            if (this.musicPlayer.get().waitDestroy()) {
                this.destroy();
                return false;
            }
            if (this.musicPlayer.get().isDestroy()) {
                return false;
            }
            this.musicPlayer.get().tick();
        }
        return true;
    }

    protected void pause() {
        if (this.musicPlayer.get() != null) {
            this.musicPlayer.get().pause();
        }
    }

    protected void resume() {
        if (this.musicPlayer.get() != null) {
            this.musicPlayer.get().resume();
        }
    }

    protected void destroy() {
        this.stopped = true;
        if (this.musicPlayer.get() != null) {
            this.musicPlayer.get().destroyNonThrow();
        }
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public boolean isPlaying() {
        if (this.musicPlayer.get() != null) {
            return this.musicPlayer.get().isPlaying();
        }
        return false;
    }

    protected int getSpeakerCount() {
        if (this.musicPlayer.get() != null) {
            return this.musicPlayer.get().getSpeakerCount();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean updateMusicTracker(UUID speakerId, MusicTracker tracker) {
        MusicPlayer<?, ?> player = this.musicPlayer.get();
        if (player == null) {
            Map<UUID, MusicTracker> map = this.reserveTrackers;
            synchronized (map) {
                return this.reserveTrackers.put(speakerId, tracker) != null;
            }
        }
        MusicSpeaker sp = player.getSpeaker(speakerId);
        if (sp != null) {
            sp.setTracker(tracker);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removeSpeaker(UUID speakerId) {
        MusicPlayer<?, ?> player = this.musicPlayer.get();
        if (player == null) {
            Map<UUID, MusicTracker> map = this.reserveTrackers;
            synchronized (map) {
                return this.reserveTrackers.remove(speakerId) != null;
            }
        }
        if (!player.existSpeaker(speakerId)) {
            return false;
        }
        player.removeSpeaker(speakerId);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean addSpeaker(UUID speakerId, MusicTracker tracker) {
        if (this.musicPlayer.get() == null) {
            Map<UUID, MusicTracker> map = this.reserveTrackers;
            synchronized (map) {
                if (this.reserveTrackers.containsKey(speakerId)) {
                    return false;
                }
                this.reserveTrackers.put(speakerId, tracker);
            }
            return true;
        }
        MusicSpeaker spk = this.musicPlayer.get().getSpeaker(speakerId);
        if (spk != null) {
            return false;
        }
        this.musicPlayer.get().addSpeaker(speakerId, new MusicSpeaker(this.musicPlayerId, speakerId, tracker));
        return true;
    }

    private MusicDestroyRunner createDestroyRunner() {
        MusicEngine me = MusicEngine.getInstance();
        return new MusicLoaderDestroyRunner(me.getMusicDestroyRunner(), () -> this.stopped);
    }

    protected void loadStart(LoadCompleteListener listener) {
        long startTime = System.currentTimeMillis();
        MusicEngine me = MusicEngine.getInstance();
        MusicDestroyRunner runner = this.createDestroyRunner();
        CompletionStage cf = ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            MusicLoader loader = this.selectLoader(this.source);
            if (loader == null) {
                throw new RuntimeException("No available loaders found");
            }
            return loader;
        }, me.getMusicAsyncExecutor()).thenApplyAsync(ret -> ret.createMusicPlayer(this.musicPlayerId), me.getMusicTickExecutor())).thenApplyAsync(ret -> {
            this.musicPlayer.set((MusicPlayer<?, ?>)ret);
            runner.run(ret::destroyNonThrow);
            return ret;
        }, (Executor)me.getMusicAsyncExecutor())).thenApplyAsync(ret -> {
            Map<UUID, MusicTracker> map = this.reserveTrackers;
            synchronized (map) {
                this.reserveTrackers.forEach(this::addSpeaker);
                this.reserveTrackers.clear();
            }
            runner.run(ret::destroyNonThrow);
            return ret;
        }, me.getMusicTickExecutor())).thenApplyAsync(ret -> new MusicLoadStartResult(ret, ret.loadStart(this.startPosition)), me.getMusicTickExecutor())).thenApplyAsync(ret -> {
            try {
                MusicLoadEndResult aret = ret.loadAsync();
                runner.run(() -> ret.musicPlayer().destroyNonThrow());
                return new MusicLoadAsyncResult(new LoadResult(true, null), aret, ret.musicPlayer());
            }
            catch (Exception e) {
                return new MusicLoadAsyncResult(new LoadResult(false, e), null, null);
            }
        }, (Executor)me.getMusicAsyncExecutor())).thenApplyAsync(ret -> {
            runner.run(() -> {
                if (ret.musicPlayer() != null) {
                    ret.musicPlayer().destroyNonThrow();
                }
            });
            if (ret.musicLoadEndResult() != null) {
                ret.musicLoadEndResult().apply();
                runner.run(() -> ret.musicLoadEndResult().musicPlayer().destroyNonThrow());
            }
            return ret.loadResult();
        }, me.getMusicTickExecutor());
        ((CompletableFuture)cf).whenCompleteAsync((ret, throwable) -> {
            boolean bl = this.loaded = ret != null && ret.success;
            if (throwable != null) {
                this.loadFailed = true;
                if (!(throwable instanceof RuntimeException)) {
                    MusicEngine.getInstance().getLogger().error("Music load error", throwable);
                }
                listener.onComplete(false, 0L, (Throwable)throwable, this.musicPlayer.get() != null);
                return;
            }
            if (ret != null) {
                listener.onComplete(ret.success, System.currentTimeMillis() - startTime, ret.error, this.musicPlayer.get() != null);
            }
        }, me.getMusicTickExecutor());
    }

    private MusicLoader selectLoader(MusicSource source) {
        List<MusicLoader> loaders = IMPMusicLoaders.getAllLoader().stream().map(Supplier::get).sorted(Comparator.comparingInt(MusicLoader::priority).reversed()).toList();
        for (MusicLoader loader : loaders) {
            try {
                loader.tryLoad(source);
                return loader;
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    private record LoadResult(boolean success, Throwable error) {
    }

    private record MusicLoadAsyncResult(LoadResult loadResult, MusicLoadEndResult<?> musicLoadEndResult, MusicPlayer<?, ?> musicPlayer) {
    }

    private record MusicLoadEndResult<T>(MusicPlayer<?, T> musicPlayer, T result) {
        private void apply() {
            this.musicPlayer.loadApply(this.result);
        }
    }

    private record MusicLoadStartResult<T, E>(MusicPlayer<T, E> musicPlayer, T input) {
        private MusicLoadEndResult<E> loadAsync() throws Exception {
            return new MusicLoadEndResult<E>(this.musicPlayer, this.musicPlayer.loadAsync(this.input));
        }
    }

    public record MusicLoadRange(long first, long last) {
    }
}

