/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.source.youtube;

import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.io.PersistentHttpStream;
import dev.felnull.imp.include.org.apache.http.client.utils.URIBuilder;
import dev.felnull.imp.include.org.slf4j.Logger;
import dev.felnull.imp.include.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;

public class YoutubePersistentHttpStream
extends PersistentHttpStream {
    private static final Logger log = LoggerFactory.getLogger(YoutubePersistentHttpStream.class);
    private static final long BUFFER_SIZE = 500000L;
    private long rangeEnd;

    public YoutubePersistentHttpStream(HttpInterface httpInterface, URI contentUrl, long contentLength) {
        super(httpInterface, contentUrl, contentLength);
    }

    @Override
    protected URI getConnectUrl() {
        if (this.position > 0L && !this.contentUrl.toString().contains("rn=")) {
            URI rangeUrl = this.getNextRangeUrl();
            log.debug("Range URL: {}", (Object)rangeUrl.toString());
            return rangeUrl;
        }
        return this.contentUrl;
    }

    @Override
    protected int internalRead(byte[] b, int off, int len, boolean attemptReconnect) throws IOException {
        long nextExpectedPosition = this.position + (long)len;
        try {
            int result;
            this.connect(false);
            if (nextExpectedPosition + 250000L >= this.rangeEnd && this.rangeEnd != 0L) {
                if (this.rangeEnd == this.contentLength) {
                    result = this.currentContent.read(b, off, len);
                    this.position += (long)result;
                } else {
                    result = 0;
                    this.handleRangeEnd(null, attemptReconnect);
                }
            } else {
                result = this.currentContent.read(b, off, len);
                if (result >= 0) {
                    this.position += (long)result;
                    if (this.position >= this.rangeEnd && !this.contentUrl.toString().contains("rn=")) {
                        this.handleRangeEnd(null, attemptReconnect);
                    }
                }
            }
            return result;
        }
        catch (IOException e) {
            this.handleRangeEnd(e, attemptReconnect);
            return this.internalRead(b, off, len, false);
        }
    }

    @Override
    protected long internalSkip(long n, boolean attemptReconnect) throws IOException {
        long nextExpectedPosition = this.position + n;
        try {
            long result;
            this.connect(false);
            if (nextExpectedPosition + 250000L >= this.rangeEnd && this.rangeEnd != 0L) {
                if (this.rangeEnd == this.contentLength) {
                    result = this.currentContent.skip(n);
                    this.position += result;
                } else {
                    result = n;
                    this.position += n;
                    this.handleRangeEnd(null, attemptReconnect);
                }
            } else {
                result = this.currentContent.skip(n);
                if (result >= 0L) {
                    this.position += result;
                    if (this.position >= this.rangeEnd && !this.contentUrl.toString().contains("rn=")) {
                        this.handleRangeEnd(null, attemptReconnect);
                    }
                }
            }
            return result;
        }
        catch (IOException e) {
            this.handleRangeEnd(e, attemptReconnect);
            return this.internalSkip(n, false);
        }
    }

    private URI getNextRangeUrl() {
        this.rangeEnd = this.position + 500000L;
        if (this.rangeEnd > this.contentLength) {
            this.rangeEnd = this.contentLength;
        }
        try {
            return new URIBuilder(this.contentUrl).addParameter("range", this.position + "-" + this.rangeEnd).build();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    protected void handleRangeEnd(IOException exception, boolean attemptReconnect) throws IOException {
        if (!attemptReconnect || !HttpClientTools.isRetriableNetworkException(exception) && exception != null) {
            throw exception;
        }
        this.close();
    }

    @Override
    protected boolean useHeadersForRange() {
        return false;
    }

    @Override
    public boolean canSeekHard() {
        return true;
    }
}

